/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid6;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.FileFormat;
import uk.gov.nationalarchives.droid.core.signature.FileFormatCollection;
import uk.gov.nationalarchives.droid.core.signature.FileFormatHit;
import uk.gov.nationalarchives.droid.core.signature.droid6.InternalSignature;
import uk.gov.nationalarchives.droid.core.signature.droid6.InternalSignatureCollection;
import uk.gov.nationalarchives.droid.core.signature.droid6.InternalSignatureComparator;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class FFSignatureFile
extends SimpleElement {
    private static final int DEFAULT_TENTATIVE_EXTENSION_SIZE = 100;
    private static final int DEFAULT_ALL_EXTENSION_SIZE = 300;
    private String version = "";
    private String dateCreated = "";
    private FileFormatCollection formatCollection;
    private InternalSignatureCollection intSigs;
    private Map<String, List<FileFormat>> tentativeFormats = new HashMap<String, List<FileFormat>>(100);
    private Map<String, List<FileFormat>> formatsForExtension = new HashMap<String, List<FileFormat>>(300);
    private long maxBytesToScan = -1L;

    public final void setFileFormatCollection(FileFormatCollection coll) {
        this.formatCollection = coll;
    }

    public final void setInternalSignatureCollection(InternalSignatureCollection col3) {
        this.intSigs = col3;
    }

    private void setVersion(String vers) {
        this.version = vers;
    }

    private void setDateCreated(String created) {
        this.dateCreated = created;
    }

    @Override
    public final void setAttributeValue(String name, String value) {
        if ("Version".equals(name)) {
            this.setVersion(value.trim());
        } else if ("DateCreated".equals(name)) {
            this.setDateCreated(value);
        } else {
            this.unknownAttributeWarning(name, this.getElementName());
        }
    }

    private int getNumInternalSignatures() {
        return this.intSigs.getInternalSignatures().size();
    }

    public List<InternalSignature> getSignatures() {
        return this.intSigs.getInternalSignatures();
    }

    private InternalSignature getInternalSignature(int theIndex) {
        return this.intSigs.getInternalSignatures().get(theIndex);
    }

    public final int getNumFileFormats() {
        return this.formatCollection.getFileFormats().size();
    }

    public final FileFormat getFileFormat(int theIndex) {
        return this.formatCollection.getFileFormats().get(theIndex);
    }

    public final FileFormat getFileFormat(String puid) {
        return this.formatCollection.getFormatForPUID(puid);
    }

    public FileFormatCollection getFileFormatCollection() {
        return this.formatCollection;
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getDateCreated() {
        return this.dateCreated;
    }

    public final void prepareForUse() {
        this.prepareInternalSignatures();
    }

    public final void puidHasOverridingSignatures(String puid) {
        FileFormat format = this.getFileFormat(puid);
        if (format != null) {
            List<Integer> removedSignatureIDs = format.clearSignatures();
            for (Integer id : removedSignatureIDs) {
                InternalSignature signature = this.intSigs.getInternalSignature(id);
                if (signature == null) continue;
                signature.removeFileFormat(format);
                if (signature.getNumFileFormats() != 0) continue;
                this.intSigs.removeInternalSignature(signature);
            }
            for (String extension : format.getExtensions()) {
                List<FileFormat> tentativeFormatsForExtension = this.tentativeFormats.get(extension);
                if (tentativeFormatsForExtension == null) continue;
                tentativeFormatsForExtension.remove(format);
                if (tentativeFormatsForExtension.size() != 0) continue;
                this.tentativeFormats.remove(extension);
            }
        }
    }

    private void prepareInternalSignatures() {
        this.setAllSignatureFileFormats();
        this.intSigs.prepareForUse();
        this.intSigs.sortSignatures(new InternalSignatureComparator());
        this.buildFileExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugWriteOutInternalSignatures() {
        OutputStream out = null;
        Writer writer = null;
        try {
            File outputFile = new File(System.getProperty("user.home") + File.separator + "DROID4 Signature Sequences.csv");
            if (outputFile.exists()) {
                outputFile.delete();
            }
            try {
                outputFile.createNewFile();
                out = new FileOutputStream(outputFile);
                writer = new OutputStreamWriter(out);
                int stop = this.getNumInternalSignatures();
                for (int signatureIndex = 0; signatureIndex < stop; ++signatureIndex) {
                    InternalSignature sig = this.getInternalSignature(signatureIndex);
                    sig.debugWriteOutSignatureSequences(writer);
                }
            }
            catch (IOException ex) {
                this.getLog().error((Object)ex.getMessage());
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                this.getLog().error((Object)ex.getMessage());
            }
        }
    }

    private void setAllSignatureFileFormats() {
        int numFormats = this.getNumFileFormats();
        for (int iFormat = 0; iFormat < numFormats; ++iFormat) {
            int numFormatInternalSignatures = this.getFileFormat(iFormat).getNumInternalSignatures();
            block1: for (int iFileSig = 0; iFileSig < numFormatInternalSignatures; ++iFileSig) {
                int iFileSigID = this.getFileFormat(iFormat).getInternalSignatureID(iFileSig);
                int numTotalInternalSignatures = this.getNumInternalSignatures();
                for (int iIntSig = 0; iIntSig < numTotalInternalSignatures; ++iIntSig) {
                    if (this.getInternalSignature(iIntSig).getID() != iFileSigID) continue;
                    this.getInternalSignature(iIntSig).addFileFormat(this.getFileFormat(iFormat));
                    continue block1;
                }
            }
        }
    }

    private void buildFileExtensions() {
        int numFileFormats = this.getNumFileFormats();
        for (int iFormat = 0; iFormat < numFileFormats; ++iFormat) {
            FileFormat theFormat = this.getFileFormat(iFormat);
            if (theFormat.getNumInternalSignatures() == 0) {
                this.addTentativeFormat(theFormat);
            }
            this.addExtensions(theFormat);
        }
    }

    private void addTentativeFormat(FileFormat tentativeFormat) {
        int numExtensions = tentativeFormat.getNumExtensions();
        for (int iExtension = 0; iExtension < numExtensions; ++iExtension) {
            String extension = tentativeFormat.getExtension(iExtension).toUpperCase();
            List<FileFormat> formatList = this.tentativeFormats.get(extension);
            if (formatList == null) {
                formatList = new ArrayList<FileFormat>();
                this.tentativeFormats.put(extension, formatList);
            }
            formatList.add(tentativeFormat);
        }
    }

    private void addExtensions(FileFormat format) {
        int numExtensions = format.getNumExtensions();
        for (int iExtension = 0; iExtension < numExtensions; ++iExtension) {
            String extension = format.getExtension(iExtension).toUpperCase();
            List<FileFormat> formatList = this.formatsForExtension.get(extension);
            if (formatList == null) {
                formatList = new ArrayList<FileFormat>();
                this.formatsForExtension.put(extension, formatList);
            }
            formatList.add(format);
        }
    }

    public List<FileFormat> getTentativeFormatsForExtension(String extension) {
        return this.tentativeFormats.get(extension.toUpperCase());
    }

    public List<FileFormat> getFileFormatsForExtension(String extension) {
        return this.formatsForExtension.get(extension.toUpperCase());
    }

    public final long getMaxBytesToScan() {
        return this.maxBytesToScan;
    }

    public void setMaxBytesToScan(long maxBytesToScan) {
        this.maxBytesToScan = maxBytesToScan;
    }

    public final void runFileIdentification(ByteReader targetFile) {
        List<InternalSignature> matchingSigs = this.intSigs.getMatchingSignatures(targetFile, this.maxBytesToScan);
        int numSigs = matchingSigs.size();
        for (int i = 0; i < numSigs; ++i) {
            InternalSignature internalSig = matchingSigs.get(i);
            targetFile.setPositiveIdent();
            int numFileFormats = internalSig.getNumFileFormats();
            for (int fileFormatIndex = 0; fileFormatIndex < numFileFormats; ++fileFormatIndex) {
                FileFormatHit fileHit = new FileFormatHit(internalSig.getFileFormat(fileFormatIndex), 15, internalSig.isSpecific(), "");
                targetFile.addHit(fileHit);
            }
        }
    }
}

