/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.io.FilenameUtils;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class BZipArchiveHandler
implements ArchiveHandler {
    private AsynchDroid droidCore;
    private IdentificationRequestFactory<InputStream> factory;
    private ResultHandler resultHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(IdentificationRequest request) throws IOException {
        IdentificationRequest<InputStream> archiveRequest = null;
        try (InputStream in = request.getSourceInputStream();){
            URI parent = request.getIdentifier().getUri();
            long correlationId = request.getIdentifier().getNodeId();
            URI uri = ArchiveFileUtils.toBZipUri(parent);
            String path = uri.getSchemeSpecificPart();
            String fileName = FilenameUtils.getName((String)path);
            RequestMetaData metaData = new RequestMetaData(null, null, fileName);
            RequestIdentifier identifier = new RequestIdentifier(uri);
            identifier.setAncestorId(request.getIdentifier().getAncestorId());
            identifier.setParentId(correlationId);
            archiveRequest = this.factory.newRequest(metaData, identifier);
            try (BZip2CompressorInputStream bzin = new BZip2CompressorInputStream(in);){
                archiveRequest.open((InputStream)bzin);
            }
        }
        if (archiveRequest != null) {
            this.droidCore.submit(archiveRequest);
        }
    }

    public final void setFactory(IdentificationRequestFactory factory) {
        this.factory = factory;
    }

    public final void setDroidCore(AsynchDroid droidCore) {
        this.droidCore = droidCore;
    }

    public final void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }
}

