/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ant.compress.util.FileAwareArchiveStreamFactory;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ZipStreamFactory
implements FileAwareArchiveStreamFactory {
    public ArchiveInputStream getArchiveStream(InputStream stream, String encoding) throws IOException {
        return new ZipArchiveInputStream(stream, encoding, true);
    }

    public ArchiveOutputStream getArchiveStream(OutputStream stream, String encoding) throws IOException {
        ZipArchiveOutputStream o = new ZipArchiveOutputStream(stream);
        o.setEncoding(encoding);
        return o;
    }

    public ArchiveInputStream getArchiveInputStream(File file, String encoding) throws IOException {
        return this.getArchiveStream(new BufferedInputStream(new FileInputStream(file)), encoding);
    }

    public ArchiveOutputStream getArchiveOutputStream(File file, String encoding) throws IOException {
        ZipArchiveOutputStream o = new ZipArchiveOutputStream(file);
        o.setEncoding(encoding);
        return o;
    }
}

