/*
 * Decompiled with CFR 0.152.
 */
package net.harawata.appdirs.impl;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.WinNT;
import net.harawata.appdirs.AppDirsException;
import net.harawata.appdirs.impl.WindowsAppDirs;
import net.harawata.appdirs.impl.WindowsFolderResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellFolderResolver
implements WindowsFolderResolver {
    private static final Logger logger = LoggerFactory.getLogger(ShellFolderResolver.class);

    @Override
    public String resolveFolder(WindowsAppDirs.FolderId folderId) {
        char[] pszPath;
        int folder = this.convertFolderId(folderId);
        WinNT.HRESULT result = Shell32.INSTANCE.SHGetFolderPath(null, folder, null, null, pszPath = new char[260]);
        if (W32Errors.S_OK.equals((Object)result)) {
            return Native.toString((char[])pszPath);
        }
        logger.error("SHGetFolderPath returns an error: {}", (Object)result.intValue());
        throw new AppDirsException("SHGetFolderPath returns an error: " + result.intValue());
    }

    protected int convertFolderId(WindowsAppDirs.FolderId folderId) {
        switch (folderId) {
            case APPDATA: {
                return 26;
            }
            case LOCAL_APPDATA: {
                return 28;
            }
            case COMMON_APPDATA: {
                return 35;
            }
        }
        throw new AppDirsException("Unknown folder ID " + (Object)((Object)folderId) + " was specified.");
    }
}

