/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command;

import java.io.IOException;
import java.util.List;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.archive.ArcArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.command.archive.Bzip2ArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.command.archive.GZipArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.command.archive.IsoArchiveContainerIdentifier;
import uk.gov.nationalarchives.droid.command.archive.SevenZipArchiveContainerIdentifier;
import uk.gov.nationalarchives.droid.command.archive.TarArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.command.archive.WarcArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.command.archive.ZipArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.command.container.Ole2ContainerContentIdentifier;
import uk.gov.nationalarchives.droid.command.container.ZipContainerContentIdentifier;
import uk.gov.nationalarchives.droid.container.ContainerFileIdentificationRequestFactory;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.IdentifierEngine;
import uk.gov.nationalarchives.droid.container.TriggerPuid;
import uk.gov.nationalarchives.droid.container.ole2.Ole2IdentifierEngine;
import uk.gov.nationalarchives.droid.container.zip.ZipIdentifierEngine;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;

public class ResultPrinter {
    private static final String R_SLASH = "/";
    private static final String L_BRACKET = "(";
    private static final String R_BRACKET = ")";
    private static final String SPACE = " ";
    private static final String OLE2_CONTAINER = "OLE2";
    private static final String ZIP_CONTAINER = "ZIP";
    private static final String ZIP_ARCHIVE = "x-fmt/263";
    private static final String JIP_ARCHIVE = "x-fmt/412";
    private static final String TAR_ARCHIVE = "x-fmt/265";
    private static final String GZIP_ARCHIVE = "x-fmt/266";
    private static final String ARC_ARCHIVE = "x-fmt/219";
    private static final String OTHERARC_ARCHIVE = "fmt/410";
    private static final String WARC_ARCHIVE = "fmt/289";
    private static final String ISO_9660 = "fmt/468";
    private static final String SEVEN_ZIP = "fmt/484";
    private static final String BZIP2_ARCHIVE = "x-fmt/268";
    private BinarySignatureIdentifier binarySignatureIdentifier;
    private ContainerSignatureDefinitions containerSignatureDefinitions;
    private List<TriggerPuid> triggerPuids;
    private IdentificationRequestFactory requestFactory;
    private String path;
    private String slash;
    private String slash1;
    private String wrongSlash;
    private boolean archives;
    private boolean webArchives;

    public ResultPrinter(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1, boolean archives, boolean webArchives) {
        this.binarySignatureIdentifier = binarySignatureIdentifier;
        this.containerSignatureDefinitions = containerSignatureDefinitions;
        this.path = path;
        this.slash = slash;
        this.slash1 = slash1;
        this.wrongSlash = this.slash.equals(R_SLASH) ? "\\" : R_SLASH;
        this.archives = archives;
        this.webArchives = webArchives;
        if (containerSignatureDefinitions != null) {
            this.triggerPuids = containerSignatureDefinitions.getTiggerPuids();
        }
    }

    public void print(IdentificationResultCollection results, IdentificationRequest request) throws CommandExecutionException {
        String fileName = (this.path + request.getFileName()).replace(this.wrongSlash, this.slash);
        IdentificationResultCollection containerResults = this.getContainerResults(results, request, fileName);
        IdentificationResultCollection finalResults = new IdentificationResultCollection(request);
        boolean container = false;
        if (containerResults.getResults().size() > 0) {
            container = true;
            finalResults = containerResults;
        } else if (results.getResults().size() > 0) {
            finalResults = results;
        }
        if (finalResults.getResults().size() > 0) {
            this.binarySignatureIdentifier.removeLowerPriorityHits(finalResults);
        }
        if (finalResults.getResults().size() > 0) {
            for (IdentificationResult identResult : finalResults.getResults()) {
                String puid = identResult.getPuid();
                if (!container && JIP_ARCHIVE.equals(puid)) {
                    puid = ZIP_ARCHIVE;
                }
                System.out.println(fileName + "," + puid);
                if (this.archives && !container) {
                    if (GZIP_ARCHIVE.equals(puid)) {
                        GZipArchiveContentIdentifier gzipArchiveIdentifier = new GZipArchiveContentIdentifier(this.binarySignatureIdentifier, this.containerSignatureDefinitions, this.path, this.slash, this.slash1, this.webArchives);
                        gzipArchiveIdentifier.identify(results.getUri(), request);
                    } else if (TAR_ARCHIVE.equals(puid)) {
                        TarArchiveContentIdentifier tarArchiveIdentifier = new TarArchiveContentIdentifier(this.binarySignatureIdentifier, this.containerSignatureDefinitions, this.path, this.slash, this.slash1);
                        tarArchiveIdentifier.identify(results.getUri(), request);
                    } else if (ZIP_ARCHIVE.equals(puid) || JIP_ARCHIVE.equals(puid)) {
                        ZipArchiveContentIdentifier zipArchiveIdentifier = new ZipArchiveContentIdentifier(this.binarySignatureIdentifier, this.containerSignatureDefinitions, this.path, this.slash, this.slash1);
                        zipArchiveIdentifier.identify(results.getUri(), request);
                    } else if (ISO_9660.equals(puid)) {
                        IsoArchiveContainerIdentifier isoArchiveContainerIdentifier = new IsoArchiveContainerIdentifier(this.binarySignatureIdentifier, this.containerSignatureDefinitions, this.path, this.slash, this.slash1);
                        isoArchiveContainerIdentifier.identify(results.getUri(), request);
                    } else if (SEVEN_ZIP.equals(puid)) {
                        SevenZipArchiveContainerIdentifier sevenZipArchiveContainerIdentifier = new SevenZipArchiveContainerIdentifier(this.binarySignatureIdentifier, this.containerSignatureDefinitions, this.path, this.slash, this.slash1);
                        sevenZipArchiveContainerIdentifier.identify(results.getUri(), request);
                    } else if (BZIP2_ARCHIVE.equals(puid)) {
                        Bzip2ArchiveContentIdentifier bzip2ArchiveContentIdentifier = new Bzip2ArchiveContentIdentifier(this.binarySignatureIdentifier, this.containerSignatureDefinitions, this.path, this.slash, this.slash1, this.webArchives);
                        bzip2ArchiveContentIdentifier.identify(results.getUri(), request);
                    }
                }
                if (!this.webArchives || container) continue;
                if (ARC_ARCHIVE.equals(puid) || OTHERARC_ARCHIVE.equals(puid)) {
                    ArcArchiveContentIdentifier arcArchiveIdentifier = new ArcArchiveContentIdentifier(this.binarySignatureIdentifier, this.containerSignatureDefinitions, this.path, this.slash, this.slash1);
                    arcArchiveIdentifier.identify(results.getUri(), request);
                    continue;
                }
                if (!WARC_ARCHIVE.equals(puid)) continue;
                WarcArchiveContentIdentifier warcArchiveIdentifier = new WarcArchiveContentIdentifier(this.binarySignatureIdentifier, this.containerSignatureDefinitions, this.path, this.slash, this.slash1);
                warcArchiveIdentifier.identify(results.getUri(), request);
            }
        } else {
            System.out.println(fileName + ",Unknown");
        }
    }

    private IdentificationResultCollection getContainerResults(IdentificationResultCollection results, IdentificationRequest request, String fileName) throws CommandExecutionException {
        IdentificationResultCollection containerResults = new IdentificationResultCollection(request);
        if (results.getResults().size() > 0 && this.containerSignatureDefinitions != null) {
            for (IdentificationResult identResult : results.getResults()) {
                TriggerPuid containerPuid;
                String filePuid = identResult.getPuid();
                if (filePuid == null || (containerPuid = this.getTriggerPuidByPuid(filePuid)) == null) continue;
                this.requestFactory = new ContainerFileIdentificationRequestFactory();
                String containerType = containerPuid.getContainerType();
                if (OLE2_CONTAINER.equals(containerType)) {
                    try {
                        Ole2ContainerContentIdentifier ole2Identifier = new Ole2ContainerContentIdentifier();
                        ole2Identifier.init(this.containerSignatureDefinitions, containerType);
                        Ole2IdentifierEngine ole2IdentifierEngine = new Ole2IdentifierEngine();
                        ole2IdentifierEngine.setRequestFactory(this.requestFactory);
                        ole2Identifier.setIdentifierEngine((IdentifierEngine)ole2IdentifierEngine);
                        containerResults = ole2Identifier.process(request.getSourceInputStream(), containerResults);
                    }
                    catch (IOException e) {
                        System.err.println(e + SPACE + L_BRACKET + fileName + R_BRACKET);
                    }
                    continue;
                }
                if (ZIP_CONTAINER.equals(containerType)) {
                    try {
                        ZipContainerContentIdentifier zipIdentifier = new ZipContainerContentIdentifier();
                        zipIdentifier.init(this.containerSignatureDefinitions, containerType);
                        ZipIdentifierEngine zipIdentifierEngine = new ZipIdentifierEngine();
                        zipIdentifierEngine.setRequestFactory(this.requestFactory);
                        zipIdentifier.setIdentifierEngine((IdentifierEngine)zipIdentifierEngine);
                        containerResults = zipIdentifier.process(request.getSourceInputStream(), containerResults);
                    }
                    catch (IOException e) {
                        System.err.println(e + SPACE + L_BRACKET + fileName + R_BRACKET);
                    }
                    continue;
                }
                throw new CommandExecutionException("Unknown container type: " + containerPuid);
            }
        }
        return containerResults;
    }

    private TriggerPuid getTriggerPuidByPuid(String puid) {
        for (TriggerPuid tp : this.triggerPuids) {
            if (!tp.getPuid().equals(puid)) continue;
            return tp;
        }
        return null;
    }
}

