/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Criterion;
import uk.gov.nationalarchives.droid.planet.xml.dao.PlanetsXMLData;
import uk.gov.nationalarchives.droid.profile.ProfileContextLocator;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileInstanceManager;
import uk.gov.nationalarchives.droid.report.ReportUtils;
import uk.gov.nationalarchives.droid.report.dao.ReportLineItem;
import uk.gov.nationalarchives.droid.report.interfaces.CancellableProgressObserver;
import uk.gov.nationalarchives.droid.report.interfaces.GroupedFieldItem;
import uk.gov.nationalarchives.droid.report.interfaces.Report;
import uk.gov.nationalarchives.droid.report.interfaces.ReportCancelledException;
import uk.gov.nationalarchives.droid.report.interfaces.ReportItem;
import uk.gov.nationalarchives.droid.report.interfaces.ReportManager;
import uk.gov.nationalarchives.droid.report.interfaces.ReportRequest;
import uk.gov.nationalarchives.droid.report.interfaces.ReportSpec;
import uk.gov.nationalarchives.droid.report.interfaces.ReportSpecDao;
import uk.gov.nationalarchives.droid.report.interfaces.ReportSpecItem;
import uk.gov.nationalarchives.droid.report.planets.xml.PlanetsXMLGenerator;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class ReportManagerImpl
implements ReportManager {
    private final Log log = LogFactory.getLog(this.getClass());
    private ProfileContextLocator profileContextLocator;
    private ReportSpecDao reportSpecDao;
    private ProgressObserver observer;
    private DroidGlobalConfig config;

    @Deprecated
    public void generatePlanetsXML(String profileId, String nameAndPathOfTheFile) {
        long startTime = System.currentTimeMillis();
        if (!this.profileContextLocator.hasProfileContext(profileId)) {
            throw new RuntimeException("Profile not available");
        }
        ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
        ProfileInstanceManager profileInstancemanager = this.profileContextLocator.openProfileInstanceManager(profile);
        PlanetsXMLData planetsData = profileInstancemanager.getPlanetsData();
        planetsData.getProfileStat().setProfileStartDate(profile.getProfileStartDate());
        planetsData.getProfileStat().setProfileEndDate(profile.getProfileEndDate());
        planetsData.getProfileStat().setProfileSaveDate(profile.getDateCreated());
        planetsData.setTopLevelItems(ReportUtils.toResourcePaths(profile.getProfileSpec().getResources()));
        PlanetsXMLGenerator planetXMLGenerator = new PlanetsXMLGenerator(this.observer, nameAndPathOfTheFile, planetsData);
        planetXMLGenerator.generate();
        long stopTime = System.currentTimeMillis();
        this.log.info((Object)String.format("Time for profile [%s]: %s ms", profileId, stopTime - startTime));
    }

    public Report generateReport(ReportRequest request, Filter optionalFilter, CancellableProgressObserver progressObserver) throws ReportCancelledException {
        this.log.info((Object)String.format("Generating report: %s", request.getReportSpec().getName()));
        int totalSteps = request.getProfileIds().size() * request.getReportSpec().getItems().size();
        int stepCount = 0;
        Report report = new Report();
        report.setTitle(request.getReportSpec().getName());
        for (ReportSpecItem specItem : request.getReportSpec().getItems()) {
            ReportItem item = new ReportItem();
            item.setReportSpecItem(specItem);
            report.addItem(item);
            LinkedHashMap<String, GroupedFieldItem> groups = new LinkedHashMap<String, GroupedFieldItem>();
            for (String profileId : request.getProfileIds()) {
                ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
                report.addProfile(profile);
                ProfileInstanceManager profileInstanceManager = this.profileContextLocator.openProfileInstanceManager(profile);
                Filter filterToUse = optionalFilter == null ? profile.getFilter() : optionalFilter;
                Criterion filter = ReportUtils.buildFilter(filterToUse, (Filter)specItem.getFilter());
                List reportData = profileInstanceManager.getReportData(filter, specItem.getField(), specItem.getGroupByFields());
                for (ReportLineItem reportLineItem : reportData) {
                    List groupByValues = reportLineItem.getGroupByValues();
                    String groupKey = this.getStringListKey(groupByValues);
                    if (!groups.containsKey(groupKey)) {
                        GroupedFieldItem newGroup = new GroupedFieldItem();
                        newGroup.setValues(groupByValues);
                        item.addGroupedFieldItem(newGroup);
                        groups.put(groupKey, newGroup);
                    }
                    GroupedFieldItem groupedFieldItem = (GroupedFieldItem)groups.get(groupKey);
                    groupedFieldItem.addProfileData(ReportUtils.buildProfileReportData(profile, reportLineItem));
                }
                if (progressObserver == null) continue;
                progressObserver.onProgress(Integer.valueOf(100 * stepCount++ / totalSteps));
                if (!progressObserver.isCancelled()) continue;
                throw new ReportCancelledException();
            }
        }
        return report;
    }

    private String getStringListKey(List<String> values) {
        String result = "";
        for (String value : values) {
            result = result + value + "@";
        }
        return result;
    }

    public List<ReportSpec> listReportSpecs() {
        File reportDefDir = this.config.getReportDefinitionDir();
        FileFilter xslFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                boolean result = false;
                String name = f.getName();
                if (FilenameUtils.isExtension((String)name, (String)"xsl")) {
                    String baseName = FilenameUtils.getBaseName((String)name);
                    result = baseName.indexOf(46) > -1;
                }
                return result;
            }
        };
        ArrayList<File> globalTransforms = new ArrayList<File>();
        for (File transform : reportDefDir.listFiles(xslFileFilter)) {
            globalTransforms.add(transform);
        }
        ArrayList<ReportSpec> reportSpecs = new ArrayList<ReportSpec>();
        FileFilter xmlFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return FilenameUtils.isExtension((String)f.getName(), (String)"xml");
            }
        };
        for (File reportDir : reportDefDir.listFiles()) {
            if (!reportDir.isDirectory()) continue;
            ArrayList<File> reportTransforms = new ArrayList<File>();
            for (File transform : reportDir.listFiles(xslFileFilter)) {
                reportTransforms.add(transform);
            }
            reportTransforms.addAll(globalTransforms);
            for (File reportDef : reportDir.listFiles(xmlFileFilter)) {
                if (!reportDef.isFile()) continue;
                ReportSpec reportSpec = this.reportSpecDao.readReportSpec(reportDef.getPath());
                reportSpec.setXslTransforms(reportTransforms);
                reportSpecs.add(reportSpec);
            }
        }
        return reportSpecs;
    }

    public void setProfileContextLocator(ProfileContextLocator profileContextLocator) {
        this.profileContextLocator = profileContextLocator;
    }

    public void setObserver(ProgressObserver observer) {
        this.observer = observer;
    }

    public void setReportSpecDao(ReportSpecDao reportSpecDao) {
        this.reportSpecDao = reportSpecDao;
    }

    public void init() throws IOException {
        ReportUtils.populateReportDefinitionsDirectory(this.config.getReportDefinitionDir(), this.getClass().getClassLoader());
    }

    public void setConfig(DroidGlobalConfig config) {
        this.config = config;
    }
}

