/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.seda1;

import ch.docuteam.darc.ead.C;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.mdconfig.CSVMetadataValue;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.RDFMetadataValue;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.mets.structmap.StructureMap;
import ch.docuteam.darc.premis.Event;
import ch.docuteam.darc.premis.Object;
import ch.docuteam.mapping.ExporterSEDA;
import ch.docuteam.mapping.seda1.SEDA1NamespacePrefixMapper;
import ch.docuteam.mapping.util.ExporterUtil;
import ch.docuteam.mapping.util.MetsExportFacade;
import ch.docuteam.tools.id.UniqueID;
import ch.docuteam.tools.out.Logger;
import fr.gouv.culture.archivesdefrance.seda.v1.AccessRestrictionRuleType;
import fr.gouv.culture.archivesdefrance.seda.v1.AppraisalRuleType;
import fr.gouv.culture.archivesdefrance.seda.v1.ArchiveObjectType;
import fr.gouv.culture.archivesdefrance.seda.v1.ArchiveTransferType;
import fr.gouv.culture.archivesdefrance.seda.v1.ArchiveType;
import fr.gouv.culture.archivesdefrance.seda.v1.ContentDescriptionType;
import fr.gouv.culture.archivesdefrance.seda.v1.CustodialHistoryType;
import fr.gouv.culture.archivesdefrance.seda.v1.DocumentType;
import fr.gouv.culture.archivesdefrance.seda.v1.KeywordType;
import fr.gouv.culture.archivesdefrance.seda.v1.OrganizationType;
import fr.gouv.culture.archivesdefrance.seda.v1.OtherMetadataType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.ArchivesBinaryObjectType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.ArchivesDurationType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.ArchivesHashcodeBinaryObjectType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.ArchivesIDType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.CodeAccessRestrictionType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.CodeAppraisalType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.CodeDescriptionLevelType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.CodeDocumentType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.CodeKeywordType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.CodeLanguageType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.CustodialHistoryItemType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.KeywordContentType;
import fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.MeasureType;
import info.lc.xmlns.premis_v2.EventComplexType;
import info.lc.xmlns.premis_v2.EventIdentifierComplexType;
import info.lc.xmlns.premis_v2.EventOutcomeInformationComplexType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import un.unece.uncefact.codelist.draft.daf.accessrestrictioncode._2009_08_18.AccessRestrictionCodeType;
import un.unece.uncefact.codelist.draft.daf.appraisalcode._2009_08_18.AppraisalCodeType;
import un.unece.uncefact.codelist.draft.daf.descriptionlevelcode._2009_08_18.LevelDescriptionType;
import un.unece.uncefact.codelist.draft.daf.documenttypecode._2009_08_18.DocumentTypeCodeType;
import un.unece.uncefact.codelist.draft.daf.filetypecode._2011_11_03.FileTypeCodeType;
import un.unece.uncefact.codelist.standard._6.recommendation20._7.MeasurementUnitCommonCodeContentType;
import un.unece.uncefact.codelist.standard.iana.mimemediatype._2011_02_16.MIMEMediaTypeContentType;
import un.unece.uncefact.data.standard.unqualifieddatatype._10.ObjectFactory;
import un.unece.uncefact.data.standard.unqualifieddatatype._10.TextType;

public class Exporter
implements ExporterSEDA {
    static final String DEFAULT_LANGUAGE_FRA = "fra";
    static final MeasurementUnitCommonCodeContentType SIZE_UNIT_CODE_2P = MeasurementUnitCommonCodeContentType.fromValue("2P");
    static final String EVENT_OUTCOME_ELEMENT_NAME = "eventOutcome";
    static final String EVENT_ELEMENT_NAME = "event";
    static final String PREMIS_PREFIX = "premis";
    static final String METS_APPRAISAL_RULE_CODE_KEEP = "Keep";
    static final String CONTEXT_PATH_SEDA_V1 = "fr.gouv.culture.archivesdefrance.seda.v1";
    static final String CONTEXT_PATH_PREMIS = "info.lc.xmlns.premis_v2";
    static final String SCHEMA_LOCATION = "fr:gouv:culture:archivesdefrance:seda:v1.0 seda_v1-0_archivetransfer.xsd info:lc/xmlns/premis-v2 http://www.loc.gov/premis/v2/premis.xsd";
    static final String XPATH_OTHER_METADATA = ".//*[local-name() = 'OtherMetadata']";

    @Override
    public boolean exportMetsToSEDA(Path metsDocumentPath, Path sedaSIPPath, String operatorName) {
        ch.docuteam.darc.mets.Document metsDocument = null;
        try {
            metsDocument = ch.docuteam.darc.mets.Document.openReadOnly((String)metsDocumentPath.toString(), (String)operatorName);
            Path sedaMetadataPath = ExporterUtil.getValidSEDAMetadataPath(sedaSIPPath);
            Marshaller marshaller = this.getMarshaller();
            fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory = new fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory();
            ArchiveTransferType archiveTransferType = this.createArchiveTransfer(sedaObjectFactory, metsDocument);
            StructureMap structureMap = metsDocument.getStructureMap();
            NodeAbstract rootNode = structureMap.getRoot();
            ArchiveType archiveType = this.createArchive(rootNode, archiveTransferType, sedaObjectFactory);
            ArchiveObjectType rootAchiveObject = sedaObjectFactory.createArchiveObjectType();
            archiveType.getArchiveObject().add(rootAchiveObject);
            HashMap<NodeAbstract, String> nodesToUniqueFileNamesMap = new HashMap<NodeAbstract, String>();
            this.createArchiveObjectRecursive(rootNode, rootAchiveObject, sedaObjectFactory, nodesToUniqueFileNamesMap);
            JAXBElement<ArchiveTransferType> archiveTransfer = sedaObjectFactory.createArchiveTransfer(archiveTransferType);
            try (FileOutputStream outputStream = new FileOutputStream(sedaMetadataPath.toFile());){
                marshaller.marshal(archiveTransfer, (OutputStream)outputStream);
                this.copyFiles(metsDocument, archiveTransfer, sedaSIPPath);
            }
            Exporter.postProcessOtherMetadata(sedaMetadataPath.toFile());
            return true;
        }
        catch (Exception e) {
            Logger.error((java.lang.Object)"error at exportMetsToSEDA because of: ", (Throwable)e);
            return false;
        }
    }

    static void postProcessOtherMetadata(File file) throws IOException, DocumentException {
        Document domDocument = new SAXReader().read(file);
        List elements = domDocument.getRootElement().selectNodes(XPATH_OTHER_METADATA);
        for (Element element : elements) {
            StringWriter stringWriter = Exporter.writeElement(element, new StringWriter());
            Element parentElement = element.getParent();
            element.detach();
            parentElement.addComment(stringWriter.getBuffer().toString());
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);
             OutputStreamWriter oswriter = new OutputStreamWriter((OutputStream)outputStream, "utf-8");){
            Exporter.writeDocument(domDocument, oswriter);
        }
    }

    static StringWriter writeElement(Element element, StringWriter writer) throws IOException {
        OutputFormat outformat = Exporter.getOutputFormat();
        XMLWriter xmlWriter = new XMLWriter((Writer)writer, outformat);
        xmlWriter.write(element);
        xmlWriter.flush();
        xmlWriter.close();
        return writer;
    }

    private static OutputFormat getOutputFormat() {
        OutputFormat outformat = new OutputFormat();
        outformat.setEncoding("UTF-8");
        outformat.setIndent(false);
        outformat.setNewlines(false);
        return outformat;
    }

    static Writer writeDocument(Document document, Writer writer) throws IOException {
        OutputFormat outformat = Exporter.getOutputFormat();
        XMLWriter xmlWriter = new XMLWriter(writer, outformat);
        xmlWriter.write(document);
        xmlWriter.flush();
        xmlWriter.close();
        return writer;
    }

    private ArchiveType createArchive(NodeAbstract rootNode, ArchiveTransferType archiveTransferType, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory) {
        ArchiveType archiveType = sedaObjectFactory.createArchiveType();
        archiveTransferType.getArchive().add(archiveType);
        archiveType.setId(ExporterUtil.getIdForSEDA(UniqueID.getXML()));
        CodeLanguageType descriptionLanguage = this.createQualifieddatatypeObjectFactory().createCodeLanguageType();
        descriptionLanguage.setValue(DEFAULT_LANGUAGE_FRA);
        archiveType.getDescriptionLanguage().add(descriptionLanguage);
        archiveType.setContentDescription(this.createContentDescriptionForArchive(rootNode, sedaObjectFactory));
        TextType archiveName = this.createTextType();
        archiveName.setValue(rootNode.getLabel());
        archiveType.setName(archiveName);
        AccessRestrictionRuleType accessRestrictionRule = this.createAccessRestrictionRule(rootNode, sedaObjectFactory);
        if (accessRestrictionRule != null) {
            archiveType.setAccessRestrictionRule(accessRestrictionRule);
        } else {
            accessRestrictionRule = sedaObjectFactory.createAccessRestrictionRuleType();
            archiveType.setAccessRestrictionRule(accessRestrictionRule);
        }
        return archiveType;
    }

    private Marshaller getMarshaller() throws JAXBException, PropertyException {
        JAXBContext sedaJAXBContext = JAXBContext.newInstance((String)"fr.gouv.culture.archivesdefrance.seda.v1:info.lc.xmlns.premis_v2");
        Marshaller marshaller = sedaJAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (java.lang.Object)new Boolean(true));
        SEDA1NamespacePrefixMapper mapper = new SEDA1NamespacePrefixMapper();
        marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (java.lang.Object)mapper);
        marshaller.setProperty("jaxb.schemaLocation", (java.lang.Object)SCHEMA_LOCATION);
        return marshaller;
    }

    private void copyFiles(ch.docuteam.darc.mets.Document metsDocument, JAXBElement<ArchiveTransferType> archiveTransfer, Path sedaSIPPath) {
        List<ArchiveObjectType> archiveObjectList = ((ArchiveTransferType)archiveTransfer.getValue()).getArchive().get(0).getArchiveObject();
        this.copyFileRecursive(metsDocument, archiveObjectList, sedaSIPPath);
    }

    private void copyFileRecursive(ch.docuteam.darc.mets.Document metsDocument, List<ArchiveObjectType> archiveObjectList, Path sedaSIPPath) {
        for (ArchiveObjectType archiveObject : archiveObjectList) {
            for (DocumentType document : archiveObject.getDocument()) {
                String id = document.getId();
                String relPath = document.getAttachment().getUri();
                ExporterUtil.copyFile(metsDocument, ExporterUtil.getMETSId(id), sedaSIPPath, relPath);
            }
            this.copyFileRecursive(metsDocument, archiveObject.getArchiveObject(), sedaSIPPath);
        }
    }

    private ArchiveObjectType createArchiveObjectRecursive(NodeAbstract metsStructMapNode, ArchiveObjectType archiveObject, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory, Map<NodeAbstract, String> nodesToUniqueFileNamesMap) {
        String adminId = ExporterUtil.getIdForSEDA(metsStructMapNode.getAdmId());
        archiveObject.setId(adminId);
        TextType title = this.createTextType();
        String fileOrFolderName = metsStructMapNode.getUnitTitle();
        if (metsStructMapNode.isFile()) {
            ExporterUtil.addUniqueFileName(metsStructMapNode, nodesToUniqueFileNamesMap);
        }
        title.setValue(fileOrFolderName);
        archiveObject.setName(title);
        this.createArchiveObjectContentDescription(metsStructMapNode, archiveObject, sedaObjectFactory);
        AccessRestrictionRuleType accessRestrictionRule = this.createAccessRestrictionRule(metsStructMapNode, sedaObjectFactory);
        if (accessRestrictionRule != null) {
            archiveObject.setAccessRestrictionRule(accessRestrictionRule);
        }
        this.createAppraisalRule(metsStructMapNode, archiveObject, sedaObjectFactory);
        this.createDocument(metsStructMapNode, archiveObject, sedaObjectFactory, nodesToUniqueFileNamesMap);
        int childCount = metsStructMapNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            NodeAbstract metsChildNode = (NodeAbstract)metsStructMapNode.getChildAt(i);
            ArchiveObjectType childAchiveObject = sedaObjectFactory.createArchiveObjectType();
            archiveObject.getArchiveObject().add(childAchiveObject);
            this.createArchiveObjectRecursive(metsChildNode, childAchiveObject, sedaObjectFactory, nodesToUniqueFileNamesMap);
        }
        return archiveObject;
    }

    private void createArchiveObjectContentDescription(NodeAbstract metsStructMapNode, ArchiveObjectType archiveObject, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory) {
        ContentDescriptionType contentDescription = this.createContentDescription(metsStructMapNode, sedaObjectFactory);
        List archivalHistory = MetsExportFacade.getEADComponent(metsStructMapNode).getArchivalHistory();
        if (archivalHistory != null && archivalHistory.size() > 0) {
            this.createCustodialHistory(archivalHistory, contentDescription, sedaObjectFactory);
        }
        this.createKeywords(metsStructMapNode, contentDescription, sedaObjectFactory);
        this.createOriginatingAgency(metsStructMapNode, contentDescription, sedaObjectFactory);
        this.createOtherMetadataPremisEvent(metsStructMapNode, contentDescription, sedaObjectFactory);
        archiveObject.setContentDescription(contentDescription);
    }

    private ContentDescriptionType createContentDescription(NodeAbstract metsStructMapNode, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory) {
        List to;
        ContentDescriptionType contentDescription = sedaObjectFactory.createContentDescriptionType();
        CodeDescriptionLevelType levelType = this.getLevelType(metsStructMapNode, sedaObjectFactory);
        contentDescription.setDescriptionLevel(levelType);
        List scopeContent = MetsExportFacade.getEADComponent(metsStructMapNode).getScopeContent();
        if (scopeContent != null && scopeContent.size() > 0) {
            TextType description = this.createTextType();
            description.setValue((String)scopeContent.get(0));
            contentDescription.setDescription(description);
        }
        String language = MetsExportFacade.getLanguage(metsStructMapNode);
        CodeLanguageType codeLanguageType = this.createQualifieddatatypeObjectFactory().createCodeLanguageType();
        if (language != null) {
            codeLanguageType.setValue(language);
        } else {
            codeLanguageType.setValue(DEFAULT_LANGUAGE_FRA);
        }
        contentDescription.getLanguage().add(codeLanguageType);
        List from = MetsExportFacade.getEADComponent(metsStructMapNode).getFrom();
        if (from != null && from.size() > 0) {
            contentDescription.setOldestDate(ExporterUtil.getXMLGregorianCalendarDATE((String)from.get(0), "yyyy-MM-dd"));
        }
        if ((to = MetsExportFacade.getEADComponent(metsStructMapNode).getTo()) != null && to.size() > 0) {
            contentDescription.setLatestDate(ExporterUtil.getXMLGregorianCalendarDATE((String)to.get(0), "yyyy-MM-dd"));
        }
        return contentDescription;
    }

    private ContentDescriptionType createContentDescriptionForArchive(NodeAbstract metsStructMapNode, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory) {
        ContentDescriptionType contentDescription = sedaObjectFactory.createContentDescriptionType();
        CodeDescriptionLevelType levelType = this.getLevelType(metsStructMapNode, sedaObjectFactory);
        levelType.setValue(LevelDescriptionType.FILE);
        contentDescription.setDescriptionLevel(levelType);
        CodeLanguageType codeLanguageType = this.createQualifieddatatypeObjectFactory().createCodeLanguageType();
        codeLanguageType.setValue(DEFAULT_LANGUAGE_FRA);
        contentDescription.getLanguage().add(codeLanguageType);
        CustodialHistoryType custodialHistory = this.createCustodialHistoryFromHeader(metsStructMapNode, sedaObjectFactory);
        contentDescription.setCustodialHistory(custodialHistory);
        return contentDescription;
    }

    private void createOtherMetadataPremisEvent(NodeAbstract metsStructMapNode, ContentDescriptionType contentDescription, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory) {
        for (Event darcPremisEvent : MetsExportFacade.getDigiprovWithPremis(metsStructMapNode).getEvents()) {
            JAXBElement<EventComplexType> event = this.createPremisEventElement(darcPremisEvent);
            OtherMetadataType otherMetadataType = sedaObjectFactory.createOtherMetadataType();
            otherMetadataType.setAny(event);
            contentDescription.getOtherMetadata().add(otherMetadataType);
        }
    }

    private JAXBElement<EventComplexType> createPremisEventElement(Event darcPremisEvent) {
        info.lc.xmlns.premis_v2.ObjectFactory premisObjectFactory = new info.lc.xmlns.premis_v2.ObjectFactory();
        EventComplexType eventComplexType = premisObjectFactory.createEventComplexType();
        eventComplexType.setEventDateTime(darcPremisEvent.getDateTime());
        eventComplexType.setEventDetail(darcPremisEvent.getDetail());
        EventIdentifierComplexType eventIdentifierComplexType = premisObjectFactory.createEventIdentifierComplexType();
        eventIdentifierComplexType.setEventIdentifierValue(ExporterUtil.getIdForSEDA(darcPremisEvent.getId()));
        eventIdentifierComplexType.setEventIdentifierType(darcPremisEvent.getIdType());
        eventComplexType.setEventIdentifier(eventIdentifierComplexType);
        eventComplexType.setEventType(darcPremisEvent.getType());
        EventOutcomeInformationComplexType eventOutcomeInformation = premisObjectFactory.createEventOutcomeInformationComplexType();
        QName eventOutComeQName = new QName("info:lc/xmlns/premis-v2", EVENT_OUTCOME_ELEMENT_NAME, PREMIS_PREFIX);
        JAXBElement eventOutcome = new JAXBElement(eventOutComeQName, String.class, (java.lang.Object)darcPremisEvent.getOutcome());
        eventOutcomeInformation.getContent().add(eventOutcome);
        eventComplexType.getEventOutcomeInformation().add(eventOutcomeInformation);
        QName qName = new QName("info:lc/xmlns/premis-v2", EVENT_ELEMENT_NAME, PREMIS_PREFIX);
        JAXBElement event = new JAXBElement(qName, EventComplexType.class, (java.lang.Object)eventComplexType);
        return event;
    }

    private void createOriginatingAgency(NodeAbstract metsStructMapNode, ContentDescriptionType contentDescription, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory) {
        List originationAgency = MetsExportFacade.getEADComponent(metsStructMapNode).getOriginationAgency();
        if (originationAgency != null && originationAgency.size() > 0) {
            OrganizationType organizationType = sedaObjectFactory.createOrganizationType();
            ArchivesIDType identifierType = this.createQualifieddatatypeObjectFactory().createArchivesIDType();
            identifierType.setValue((String)originationAgency.get(0));
            organizationType.setIdentification(identifierType);
            contentDescription.getOriginatingAgency().add(organizationType);
        }
    }

    private void createKeywords(NodeAbstract metsStructMapNode, ContentDescriptionType contentDescription, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory) {
        this.createKeywordGeneric(sedaObjectFactory, contentDescription, un.unece.uncefact.codelist.draft.daf.keywordtypecode._2009_08_18.KeywordType.CORPNAME, metsStructMapNode, "institution");
        this.createKeywordGeneric(sedaObjectFactory, contentDescription, un.unece.uncefact.codelist.draft.daf.keywordtypecode._2009_08_18.KeywordType.FAMNAME, metsStructMapNode, "familyName");
        this.createKeywordGeneric(sedaObjectFactory, contentDescription, un.unece.uncefact.codelist.draft.daf.keywordtypecode._2009_08_18.KeywordType.FUNCTION, metsStructMapNode, "function");
        this.createKeywordGeneric(sedaObjectFactory, contentDescription, un.unece.uncefact.codelist.draft.daf.keywordtypecode._2009_08_18.KeywordType.GENREFORM, metsStructMapNode, "objectType");
        this.createKeywordGeneric(sedaObjectFactory, contentDescription, un.unece.uncefact.codelist.draft.daf.keywordtypecode._2009_08_18.KeywordType.GEOGNAME, metsStructMapNode, "geogName");
        this.createKeywordGeneric(sedaObjectFactory, contentDescription, un.unece.uncefact.codelist.draft.daf.keywordtypecode._2009_08_18.KeywordType.NAME, metsStructMapNode, "keyword");
        this.createKeywordGeneric(sedaObjectFactory, contentDescription, un.unece.uncefact.codelist.draft.daf.keywordtypecode._2009_08_18.KeywordType.OCCUPATION, metsStructMapNode, "occupation");
        this.createKeywordGeneric(sedaObjectFactory, contentDescription, un.unece.uncefact.codelist.draft.daf.keywordtypecode._2009_08_18.KeywordType.PERSNAME, metsStructMapNode, "creator");
        this.createKeywordGeneric(sedaObjectFactory, contentDescription, un.unece.uncefact.codelist.draft.daf.keywordtypecode._2009_08_18.KeywordType.SUBJECT, metsStructMapNode, "subjectGeneral");
    }

    private void createKeywordGeneric(fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory, ContentDescriptionType contentDescription, un.unece.uncefact.codelist.draft.daf.keywordtypecode._2009_08_18.KeywordType keywordTypeValue, NodeAbstract metsStructMapNode, String accessorName) {
        List values;
        try {
            values = metsStructMapNode.getAllDynamicMetadataValuesForName_NoCheck(accessorName);
        }
        catch (MetadataElementIsNotDefinedException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Logger.warn((java.lang.Object)("Error reading metadata values for accessor '" + accessorName + "'"));
            return;
        }
        if (values == null || values.size() == 0) {
            return;
        }
        MetadataElement metadataElement = MetsExportFacade.getMetadataElement(metsStructMapNode, accessorName);
        boolean isMetadataElementOfTypeRDF = metadataElement != null && metadataElement.getValueType().equals((java.lang.Object)MetadataElement.VALUE_TYPE.skosFile);
        boolean isMetadataElementOfTypeCSV = metadataElement != null && metadataElement.getValueType().equals((java.lang.Object)MetadataElement.VALUE_TYPE.csvFile);
        for (String value : values) {
            if (value.isEmpty()) continue;
            String reference = null;
            if (isMetadataElementOfTypeRDF) {
                reference = value;
                value = RDFMetadataValue.getRDFLabelENorDefault((List)metadataElement.getRdfAllowedValues(), (String)reference);
            } else if (isMetadataElementOfTypeCSV) {
                reference = value;
                value = CSVMetadataValue.getCSVLabelEN((List)metadataElement.getCsvAllowedValues(), (String)reference);
            }
            this.createKeyword(sedaObjectFactory, contentDescription, keywordTypeValue, value, reference);
        }
    }

    private void createKeyword(fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory, ContentDescriptionType contentDescription, un.unece.uncefact.codelist.draft.daf.keywordtypecode._2009_08_18.KeywordType keywordTypeValue, String content, String reference) {
        KeywordType keywordType = sedaObjectFactory.createKeywordType();
        CodeKeywordType type = this.createQualifieddatatypeObjectFactory().createCodeKeywordType();
        type.setValue(keywordTypeValue);
        keywordType.setKeywordType(type);
        KeywordContentType keywordContent = this.createQualifieddatatypeObjectFactory().createKeywordContentType();
        keywordContent.setValue(content);
        keywordType.setKeywordContent(keywordContent);
        if (reference != null) {
            ArchivesIDType archivesIDType = this.createQualifieddatatypeObjectFactory().createArchivesIDType();
            archivesIDType.setValue(reference);
            keywordType.setKeywordReference(archivesIDType);
        }
        contentDescription.getKeyword().add(keywordType);
    }

    private void createCustodialHistory(List<String> archivalHistoryList, ContentDescriptionType contentDescription, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory) {
        CustodialHistoryType custodialHistory = sedaObjectFactory.createCustodialHistoryType();
        contentDescription.setCustodialHistory(custodialHistory);
        Iterator<String> iterator = archivalHistoryList.iterator();
        while (iterator.hasNext()) {
            this.createCustodialHistoryItem(iterator.next(), custodialHistory);
        }
    }

    private void createCustodialHistoryItem(String custodialHistoryItemValue, CustodialHistoryType custodialHistory) {
        CustodialHistoryItemType custodialHistoryItem = this.createQualifieddatatypeObjectFactory().createCustodialHistoryItemType();
        custodialHistoryItem.setValue(custodialHistoryItemValue);
        custodialHistory.getCustodialHistoryItem().add(custodialHistoryItem);
    }

    private CustodialHistoryType createCustodialHistoryFromHeader(NodeAbstract metsStructMapNode, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory) {
        Object headerPremisObject = MetsExportFacade.getHeaderPremisObject(metsStructMapNode.getDocument());
        CustodialHistoryType custodialHistory = sedaObjectFactory.createCustodialHistoryType();
        this.createCustodialHistoryItem(headerPremisObject.getSwName(), custodialHistory);
        this.createCustodialHistoryItem(headerPremisObject.getSwType(), custodialHistory);
        return custodialHistory;
    }

    private CodeDescriptionLevelType getLevelType(NodeAbstract metsStructMapNode, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory) {
        LevelOfDescription metsLevel = metsStructMapNode.getLevel();
        CodeDescriptionLevelType levelType = this.createQualifieddatatypeObjectFactory().createCodeDescriptionLevelType();
        try {
            Logger.debug((java.lang.Object)("getLevelType: " + metsLevel.getName() + " for " + metsStructMapNode.getLabel()));
            levelType.setValue(LevelDescriptionType.fromValue(metsLevel.getName().toLowerCase()));
        }
        catch (IllegalArgumentException e) {
            levelType.setValue(LevelDescriptionType.FILE);
            Logger.warn((java.lang.Object)("catch IllegalArgumentException at getLevelType(). " + metsLevel.getName().toLowerCase() + " cannot be mapped to the LevelDescriptionType, so use a default."));
        }
        return levelType;
    }

    private fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.ObjectFactory createQualifieddatatypeObjectFactory() {
        return new fr.gouv.culture.archivesdefrance.seda.v1_0.qualifieddatatype._1.ObjectFactory();
    }

    private TextType createTextType() {
        TextType title = new ObjectFactory().createTextType();
        return title;
    }

    private ArchiveTransferType createArchiveTransfer(fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory, ch.docuteam.darc.mets.Document metsDocument) {
        ArchiveTransferType archiveTransferType = new ArchiveTransferType();
        archiveTransferType.setDate(ExporterUtil.getNewXMLGregorianCalendar());
        archiveTransferType.setId(MetsExportFacade.getHeaderAdmId(metsDocument));
        ArchivesIDType identifierType = this.createQualifieddatatypeObjectFactory().createArchivesIDType();
        archiveTransferType.setTransferIdentifier(identifierType);
        String archivalAgency = MetsExportFacade.getArchivalAgencyFromSubmissionAgreement(metsDocument);
        OrganizationType organizationType = this.createOrganizationType(sedaObjectFactory, archivalAgency);
        archiveTransferType.setArchivalAgency(organizationType);
        String transferringAgency = MetsExportFacade.getTransferringAgencyFromSubmissionAgreement(metsDocument);
        OrganizationType transferringAgencyOrganization = this.createOrganizationType(sedaObjectFactory, transferringAgency);
        archiveTransferType.setTransferringAgency(transferringAgencyOrganization);
        return archiveTransferType;
    }

    private OrganizationType createOrganizationType(fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory, String identifierTypeValue) {
        OrganizationType organizationType = sedaObjectFactory.createOrganizationType();
        ArchivesIDType identification = this.createQualifieddatatypeObjectFactory().createArchivesIDType();
        identification.setValue(identifierTypeValue);
        organizationType.setIdentification(identification);
        return organizationType;
    }

    private AccessRestrictionRuleType createAccessRestrictionRule(NodeAbstract metsStructMapNode, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory) {
        List accessRestrictionPeriodBaseYear;
        C eAD_C = MetsExportFacade.getEADComponent(metsStructMapNode);
        boolean dataFound = false;
        AccessRestrictionRuleType accessRuleType = sedaObjectFactory.createAccessRestrictionRuleType();
        String accessRestrictionStatus = MetsExportFacade.getAccessRestrictionStatus(metsStructMapNode);
        if (accessRestrictionStatus != null && !accessRestrictionStatus.isEmpty()) {
            CodeAccessRestrictionType codeAccessRestrictionType = this.createQualifieddatatypeObjectFactory().createCodeAccessRestrictionType();
            AccessRestrictionCodeType accessRestrictionCode = null;
            try {
                accessRestrictionCode = AccessRestrictionCodeType.fromValue(accessRestrictionStatus);
            }
            catch (IllegalArgumentException e) {
                Logger.error((java.lang.Object)("catch IllegalArgumentException at createAccessRestrictionRule(): " + accessRestrictionStatus + " cannot be mapped to a AccessRestrictionCodeType, so stop the export"));
                throw e;
            }
            codeAccessRestrictionType.setValue(accessRestrictionCode);
            accessRuleType.setCode(codeAccessRestrictionType);
            dataFound = true;
        }
        if ((accessRestrictionPeriodBaseYear = eAD_C.getAccessRestrictionPeriodBaseYear()) != null && accessRestrictionPeriodBaseYear.size() > 0) {
            XMLGregorianCalendar startDate = ExporterUtil.getXMLGregorianCalendarDATE((String)accessRestrictionPeriodBaseYear.get(0), "yyyy-MM-dd");
            if (startDate != null) {
                accessRuleType.setStartDate(startDate);
                dataFound = true;
            }
        } else {
            accessRuleType.setStartDate(ExporterUtil.getXMLGregorianCalendar(System.currentTimeMillis()));
        }
        if (dataFound) {
            return accessRuleType;
        }
        return null;
    }

    private void createAppraisalRule(NodeAbstract metsStructMapNode, ArchiveObjectType archiveObject, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory) {
        List retentionPeriodBaseYear;
        String retentionPolicy;
        boolean dataFound = false;
        C eAD_C = MetsExportFacade.getEADComponent(metsStructMapNode);
        AppraisalRuleType appraisalRule = sedaObjectFactory.createAppraisalRuleType();
        List appraisalAndDestruction = eAD_C.getAppraisalAndDestruction();
        if (appraisalAndDestruction != null && appraisalAndDestruction.size() > 0) {
            CodeAppraisalType codeAppraisal = this.createQualifieddatatypeObjectFactory().createCodeAppraisalType();
            AppraisalCodeType value = this.getAppraisalCode(appraisalAndDestruction);
            codeAppraisal.setValue(value);
            appraisalRule.setCode(codeAppraisal);
            dataFound = true;
        }
        if ((retentionPolicy = MetsExportFacade.getRententionPolicy(metsStructMapNode)) != null && !retentionPolicy.isEmpty()) {
            ArchivesDurationType archivesDuration = this.createQualifieddatatypeObjectFactory().createArchivesDurationType();
            Duration duration = null;
            try {
                duration = DatatypeFactory.newInstance().newDuration(retentionPolicy);
                archivesDuration.setValue(duration);
                appraisalRule.setDuration(archivesDuration);
                dataFound = true;
            }
            catch (Exception e) {
                Logger.error((java.lang.Object)"error at createAppraisalRule: ", (Throwable)e);
            }
        }
        if ((retentionPeriodBaseYear = eAD_C.getRetentionPeriodBaseYear()) != null && retentionPeriodBaseYear.size() > 0) {
            XMLGregorianCalendar startDate = ExporterUtil.getXMLGregorianCalendarDATE((String)retentionPeriodBaseYear.get(0), "yyyy-MM-dd");
            appraisalRule.setStartDate(startDate);
            dataFound = true;
        } else {
            appraisalRule.setStartDate(ExporterUtil.getXMLGregorianCalendar(System.currentTimeMillis()));
        }
        if (dataFound) {
            archiveObject.setAppraisalRule(appraisalRule);
        }
    }

    private AppraisalCodeType getAppraisalCode(List<String> metsAppraisalAndDestruction) {
        if (METS_APPRAISAL_RULE_CODE_KEEP.equals(metsAppraisalAndDestruction.get(0))) {
            return AppraisalCodeType.CONSERVER;
        }
        return AppraisalCodeType.DETRUIRE;
    }

    private void createDocument(NodeAbstract metsStructMapNode, ArchiveObjectType archiveObject, fr.gouv.culture.archivesdefrance.seda.v1.ObjectFactory sedaObjectFactory, Map<NodeAbstract, String> nodesToUniqueFileNamesMap) {
        if (metsStructMapNode instanceof NodeFile) {
            ch.docuteam.darc.mets.filesec.File metsFile;
            Optional<MIMEMediaTypeContentType> mimeCode;
            DocumentType document = sedaObjectFactory.createDocumentType();
            String fileId = ExporterUtil.getIdForSEDA(((NodeFile)metsStructMapNode).getFileId());
            document.setId(fileId);
            ArchivesBinaryObjectType archivesBinaryObject = this.createQualifieddatatypeObjectFactory().createArchivesBinaryObjectType();
            String uniqueFileName = this.getUniqueFileName((NodeFile)metsStructMapNode, nodesToUniqueFileNamesMap);
            archivesBinaryObject.setFilename(uniqueFileName);
            Object premisObject = MetsExportFacade.getPremisObject((NodeAbstract)((NodeFile)metsStructMapNode));
            Optional<String> formatId = this.getFormatId(premisObject);
            if (formatId.isPresent()) {
                archivesBinaryObject.setFormat(formatId.get());
            }
            if ((mimeCode = this.getMimeCode(metsFile = ((NodeFile)metsStructMapNode).getMyFileSectionFile())).isPresent()) {
                archivesBinaryObject.setMimeCode(mimeCode.get());
            }
            archivesBinaryObject.setUri(ExporterUtil.getSEDA_Uri(uniqueFileName));
            document.setAttachment(archivesBinaryObject);
            TextType description = this.createTextType();
            description.setValue(premisObject.getFormatName());
            document.setDescription(description);
            ArchivesHashcodeBinaryObjectType integrity = this.createQualifieddatatypeObjectFactory().createArchivesHashcodeBinaryObjectType();
            integrity.setAlgorithme(premisObject.getMessageDigestAlgorithm());
            try {
                integrity.setValue(premisObject.getMessageDigest().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.error((java.lang.Object)"error at createDocument: ", (Throwable)e);
            }
            document.setIntegrity(integrity);
            long ioFileLastModified = metsFile.getFile().lastModified();
            XMLGregorianCalendar xMLGregorianCalendar = ExporterUtil.getXMLGregorianCalendar(ioFileLastModified);
            document.setIssue(xMLGregorianCalendar);
            MeasureType measure = this.createQualifieddatatypeObjectFactory().createMeasureType();
            BigDecimal size = BigDecimal.valueOf(Long.valueOf(premisObject.getSize()));
            measure.setValue(size);
            measure.setUnitCode(SIZE_UNIT_CODE_2P);
            document.setSize(measure);
            List sourceType = MetsExportFacade.getEADComponent(metsStructMapNode).getSourceType();
            if (sourceType != null && sourceType.size() > 0) {
                CodeDocumentType type = this.createQualifieddatatypeObjectFactory().createCodeDocumentType();
                type.setValue(DocumentTypeCodeType.fromValue((String)sourceType.get(0)));
                document.getType().add(type);
            }
            archiveObject.getDocument().add(document);
        }
    }

    private Optional<MIMEMediaTypeContentType> getMimeCode(ch.docuteam.darc.mets.filesec.File metsFile) {
        Optional<MIMEMediaTypeContentType> mimeTypeOptional = Optional.empty();
        String mimeType = metsFile.getMimeType();
        if (mimeType != null && !mimeType.trim().isEmpty()) {
            try {
                mimeTypeOptional = Optional.of(MIMEMediaTypeContentType.fromValue(mimeType));
            }
            catch (IllegalArgumentException e) {
                Logger.warn((java.lang.Object)String.format("MIME type '%s' not allowed in SEDA1", mimeType));
            }
        }
        return mimeTypeOptional;
    }

    private Optional<String> getFormatId(Object premisObject) {
        Optional<String> formatId = Optional.empty();
        String formatID = premisObject.getFormatRegistryKey();
        if (formatID != null && !formatID.trim().isEmpty()) {
            try {
                FileTypeCodeType.fromValue(formatID);
                formatId = Optional.of(formatID);
            }
            catch (IllegalArgumentException e) {
                Logger.warn((java.lang.Object)String.format("PUID '%s' not allowed in SEDA1", formatID));
            }
        }
        return formatId;
    }

    String getUniqueFileName(NodeFile nodeFile, Map<NodeAbstract, String> nodesToUniqueFileNamesMap) {
        return nodesToUniqueFileNamesMap.get(nodeFile);
    }
}

