/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import ch.docuteam.tools.file.FileChecksumCalculator;
import ch.docuteam.tools.file.MetadataProviderDROID;
import ch.docuteam.tools.file.MetadataProviderJHOVE;
import ch.docuteam.tools.out.Logger;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;

public class FileWithMetadata
extends File {
    private static final String Unknown = "(n/a)";
    private FileChecksumCalculator.Algorithm DefaultChecksumAlgorithm = FileChecksumCalculator.Algorithm.MD5;
    private IdentificationResult DROIDData = null;
    private boolean alreadyTriedToRetrieveDROID = false;
    private RepInfo jhoveData = null;
    private boolean alreadyTriedToRetrieveJhove = false;

    public FileWithMetadata(String pathname) {
        super(pathname);
    }

    public FileWithMetadata(URI uri) {
        super(uri);
    }

    public FileWithMetadata(String parent, String child) {
        super(parent, child);
    }

    public FileWithMetadata(File parent, String child) {
        super(parent, child);
    }

    public FileChecksumCalculator.Algorithm getDefaultChecksumAlgorithm() {
        return this.DefaultChecksumAlgorithm;
    }

    public void setDefaultChecksumAlgorithm(FileChecksumCalculator.Algorithm algorithm) {
        this.DefaultChecksumAlgorithm = algorithm;
    }

    public String getFormatName() {
        String formatNameDroid = this.getFileFormatName_droid();
        return Unknown.equals(formatNameDroid) ? this.getFormat_jhove() : formatNameDroid;
    }

    public String getFormatName(Provider provider) {
        if (provider == Provider.DROID) {
            return this.getFileFormatName_droid();
        }
        if (provider == Provider.JHOVE) {
            return this.getFormat_jhove();
        }
        return Unknown;
    }

    public String getFormatPronomID() {
        return this.getFileFormatPUID_droid();
    }

    public String getMimeType() {
        String mimeTypeDroid = this.getMimeType_droid();
        String mimeType = Unknown.equals(mimeTypeDroid) ? this.getMimeType_jhove() : mimeTypeDroid;
        Optional<String> firstMimeTypeOptional = Stream.of(mimeType.split("\\s?,\\s?")).findFirst();
        if (firstMimeTypeOptional.isPresent()) {
            return firstMimeTypeOptional.get();
        }
        return mimeType;
    }

    String getMimeType(Provider provider) {
        if (provider == Provider.DROID) {
            return this.getMimeType_droid();
        }
        if (provider == Provider.JHOVE) {
            return this.getMimeType_jhove();
        }
        return Unknown;
    }

    public int getWellFormed() {
        return this.getWellFormed_jhove();
    }

    public int getValid() {
        return this.getValid_jhove();
    }

    public boolean isConsistent() {
        return this.isConsistent_jhove();
    }

    public long getSize() {
        return this.getSize_jhove();
    }

    public Module getModule() {
        return this.getModule_jhove();
    }

    public List<String> getProfile() {
        return this.getProfile_jhove();
    }

    public String getChecksum() throws NoSuchAlgorithmException, IOException {
        return this.DefaultChecksumAlgorithm.getDigest(this.getAbsolutePath());
    }

    public String getChecksum(FileChecksumCalculator.Algorithm algorithm) throws NoSuchAlgorithmException, IOException {
        if (algorithm == null) {
            return null;
        }
        return FileChecksumCalculator.Algorithm.valueOf(algorithm.toString()).getDigest(this.getAbsolutePath());
    }

    private RepInfo getJhoveMetadata() {
        Logger.debug("Getting jhove Metadata...");
        if (this.jhoveData == null) {
            this.initializeJhoveMetadata();
        }
        return this.jhoveData;
    }

    private void initializeJhoveMetadata() {
        String filePath;
        if (this.alreadyTriedToRetrieveJhove) {
            Logger.debug("NOT retrying to retrieve jhove Metadata for file:" + this.getPath());
            return;
        }
        try {
            filePath = this.getCanonicalPath();
        }
        catch (IOException e) {
            Logger.warn("Could not get canonical path for file", e);
            return;
        }
        Logger.debug("Retrieving jhove Metadata for file:" + filePath + "...");
        this.jhoveData = MetadataProviderJHOVE.getRepInfo(filePath);
        if (this.jhoveData == null) {
            Logger.debug("...NOK!");
        } else {
            Logger.debug("...OK");
        }
        this.alreadyTriedToRetrieveJhove = true;
    }

    private IdentificationResult getDroidMetadata() {
        Logger.debug("Getting droid Metadata...");
        if (this.DROIDData == null) {
            this.initializeDroidMetadata();
        }
        return this.DROIDData;
    }

    private void initializeDroidMetadata() {
        String filePath;
        if (this.alreadyTriedToRetrieveDROID) {
            Logger.debug("NOT retrying to retrieve droid Metadata for file:" + this.getPath());
            return;
        }
        try {
            filePath = this.getCanonicalPath();
        }
        catch (IOException e) {
            Logger.warn("Could not get canonical path for file", e);
            return;
        }
        Logger.debug("Retrieving droid Metadata for file:" + filePath + "...");
        try {
            this.DROIDData = MetadataProviderDROID.getIdentificationResult(filePath);
            Logger.debug("...OK");
        }
        catch (Exception ex) {
            Logger.debug("...NOK!");
        }
        this.alreadyTriedToRetrieveDROID = true;
    }

    private int getWellFormed_jhove() {
        if (this.getJhoveMetadata() == null) {
            return -1;
        }
        return this.jhoveData.getWellFormed();
    }

    private int getValid_jhove() {
        if (this.getJhoveMetadata() == null) {
            return -1;
        }
        return this.jhoveData.getValid();
    }

    private boolean isConsistent_jhove() {
        if (this.getJhoveMetadata() == null) {
            return false;
        }
        return this.jhoveData.isConsistent();
    }

    private String getMimeType_jhove() {
        if (this.getJhoveMetadata() == null) {
            return Unknown;
        }
        return this.jhoveData.getMimeType();
    }

    private String getFormat_jhove() {
        if (this.getJhoveMetadata() == null) {
            return Unknown;
        }
        return this.jhoveData.getFormat();
    }

    private long getSize_jhove() {
        if (this.getJhoveMetadata() == null) {
            return -1L;
        }
        return this.jhoveData.getSize();
    }

    private Module getModule_jhove() {
        if (this.getJhoveMetadata() == null) {
            return null;
        }
        return this.jhoveData.getModule();
    }

    private List<String> getProfile_jhove() {
        if (this.getJhoveMetadata() == null) {
            return new ArrayList<String>();
        }
        return this.jhoveData.getProfile();
    }

    private String getMimeType_droid() {
        if (this.getDroidMetadata() == null) {
            return Unknown;
        }
        return this.DROIDData.getMimeType();
    }

    private String getFileFormatName_droid() {
        if (this.getDroidMetadata() == null) {
            return Unknown;
        }
        return this.DROIDData.getName();
    }

    private String getFileFormatPUID_droid() {
        if (this.getDroidMetadata() == null) {
            return Unknown;
        }
        return this.DROIDData.getPuid();
    }

    public static enum Provider {
        DROID,
        JHOVE;

    }
}

