/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import ch.docuteam.tools.file.MetadataProviderDROID_IdentificationResult;
import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.file.exception.DROIDCouldNotInitializeException;
import ch.docuteam.tools.file.exception.DROIDMultipleIdentificationsFoundException;
import ch.docuteam.tools.file.exception.DROIDNoIdentificationFoundException;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.container.Ole2ContainerContentIdentifier;
import uk.gov.nationalarchives.droid.command.container.ZipContainerContentIdentifier;
import uk.gov.nationalarchives.droid.container.ContainerFileIdentificationRequestFactory;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.ContainerSignatureSaxParser;
import uk.gov.nationalarchives.droid.container.IdentifierEngine;
import uk.gov.nationalarchives.droid.container.TriggerPuid;
import uk.gov.nationalarchives.droid.container.ole2.Ole2IdentifierEngine;
import uk.gov.nationalarchives.droid.container.zip.ZipIdentifierEngine;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier_Extended;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.signature.FileFormat;

public abstract class MetadataProviderDROID {
    private static final String DEFAULT_SIGNATURE_FILE = "/config/DROID_SignatureFile_V95.xml";
    private static final String DEFAULT_CONTAINER_SIGNATURE_FILE = "/config/container-signature-20180920.xml";
    private static final int DEFAULT_EXTENSION_USAGE = 1;
    private static String signatureFile;
    private static String containerSignatureFile;
    private static int extensionUsage;
    private static BinarySignatureIdentifier_Extended signatureIdentificator;
    private static ContainerSignatureDefinitions containerSignatureDefs;
    private static List<TriggerPuid> containerSignatureTriggerPuids;
    private static Boolean isInitialized;

    public static void setSignatureFile(String newSignatureFile) throws FileNotFoundException {
        if (!new File(newSignatureFile).exists()) {
            throw new FileNotFoundException(newSignatureFile);
        }
        Logger.debug("setSignatureFile - newSignatureFile: " + newSignatureFile);
        signatureFile = newSignatureFile;
        isInitialized = false;
    }

    public static List<String> getExtensions(String puid) throws DROIDCouldNotInitializeException {
        if (puid == null || puid.trim().isEmpty()) {
            return Collections.emptyList();
        }
        MetadataProviderDROID.initializeIfNecessary();
        return signatureIdentificator.getFileFormatForPuid(puid).getExtensions();
    }

    public static void setContainerSignatureFile(String newContainerSignatureFile) {
        Logger.debug("setContainerSignatureFile - newContainerSignatureFile: " + newContainerSignatureFile);
        containerSignatureFile = newContainerSignatureFile;
        isInitialized = false;
    }

    public static void setExtensionUsage(int levelOfExtensionUsage) {
        extensionUsage = levelOfExtensionUsage;
    }

    public static IdentificationResult getIdentificationResult(String filePath) throws DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileNotFoundException {
        List<IdentificationResult> resultList = MetadataProviderDROID.getIdentificationResults(filePath);
        if (resultList == null || resultList.isEmpty()) {
            throw new DROIDNoIdentificationFoundException(filePath);
        }
        if (resultList.size() != 1) {
            throw new DROIDMultipleIdentificationsFoundException(filePath, resultList);
        }
        return resultList.get(0);
    }

    public static String getFileFormatPUID(String fileName) throws DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileNotFoundException {
        IdentificationResult result = MetadataProviderDROID.getIdentificationResult(fileName);
        return result == null ? null : result.getPuid();
    }

    public static String getMimeType(String fileName) throws DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileNotFoundException {
        Optional firstMimeTypeOptional;
        IdentificationResult result = MetadataProviderDROID.getIdentificationResult(fileName);
        String mimeType = result == null ? null : result.getMimeType();
        Optional<Object> optional = firstMimeTypeOptional = mimeType == null ? Optional.empty() : Stream.of(mimeType.split("\\s?,\\s?")).findFirst();
        if (firstMimeTypeOptional.isPresent()) {
            return (String)firstMimeTypeOptional.get();
        }
        return mimeType;
    }

    public static String getFileFormatName(String fileName) throws DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileNotFoundException {
        IdentificationResult result = MetadataProviderDROID.getIdentificationResult(fileName);
        return result == null ? null : result.getName();
    }

    public static String getFileFormatVersion(String fileName) throws DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileNotFoundException {
        IdentificationResult result = MetadataProviderDROID.getIdentificationResult(fileName);
        return result == null ? null : result.getVersion();
    }

    public static String getFileFormatMethod(String fileName) throws DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileNotFoundException {
        IdentificationResult result = MetadataProviderDROID.getIdentificationResult(fileName);
        return result == null ? null : result.getMethod().getMethod();
    }

    private static void initializeIfNecessary() throws DROIDCouldNotInitializeException {
        if (isInitialized.booleanValue()) {
            return;
        }
        try {
            Logger.debug("Initializing DROID...");
            Logger.debug("signatureFile: " + signatureFile);
            Logger.debug("containerSignatureFile: " + containerSignatureFile);
            if (!new File(signatureFile).exists()) {
                throw new FileNotFoundException(signatureFile);
            }
            if (!new File(containerSignatureFile).exists()) {
                throw new FileNotFoundException(containerSignatureFile);
            }
            signatureIdentificator = new BinarySignatureIdentifier_Extended();
            signatureIdentificator.setSignatureFile(signatureFile);
            signatureIdentificator.init();
            containerSignatureDefs = new ContainerSignatureSaxParser().parse((InputStream)new FileInputStream(containerSignatureFile));
            containerSignatureTriggerPuids = containerSignatureDefs.getTiggerPuids();
            isInitialized = true;
            Logger.debug("...OK");
        }
        catch (Exception ex) {
            Logger.debug("...NOK!");
            throw new DROIDCouldNotInitializeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<IdentificationResult> getIdentificationResults(String filePath) throws DROIDCouldNotInitializeException, FileNotFoundException {
        MetadataProviderDROID.initializeIfNecessary();
        if (!new File(filePath).exists()) {
            throw new FileNotFoundException(filePath);
        }
        File file = new File(filePath);
        RequestMetaData metadata = new RequestMetaData(Long.valueOf(file.length()), Long.valueOf(file.lastModified()), file.getName());
        RequestIdentifier id = new RequestIdentifier(file.toURI());
        FileSystemIdentificationRequest request = new FileSystemIdentificationRequest(metadata, id);
        try {
            IdentificationResultCollection finalResultCollection;
            request.open((Object)file);
            IdentificationResultCollection signatureResultCollection = signatureIdentificator.matchBinarySignatures((IdentificationRequest)request);
            IdentificationResultCollection containerResultCollection = MetadataProviderDROID.getContainerResults((IdentificationRequest)request, signatureResultCollection);
            if (containerResultCollection.getResults().size() > 0) {
                finalResultCollection = containerResultCollection;
            } else if (signatureResultCollection.getResults().size() > 0) {
                finalResultCollection = signatureResultCollection;
            } else {
                switch (extensionUsage) {
                    case 1: {
                        finalResultCollection = signatureIdentificator.matchExtensions((IdentificationRequest)request, false);
                        break;
                    }
                    case 2: {
                        finalResultCollection = signatureIdentificator.matchExtensions((IdentificationRequest)request, true);
                        break;
                    }
                    default: {
                        finalResultCollection = containerResultCollection;
                    }
                }
            }
            signatureIdentificator.removeLowerPriorityHits(finalResultCollection);
            List list = finalResultCollection.getResults();
            return list;
        }
        catch (Exception e) {
            Logger.warn("Exception occured while trying to identify file: " + filePath, e);
            List<IdentificationResult> list = null;
            return list;
        }
        finally {
            try {
                request.close();
            }
            catch (IOException ex) {
                Logger.error("at request.close() ", ex);
            }
        }
    }

    private static IdentificationResultCollection getContainerResults(IdentificationRequest request, IdentificationResultCollection results) throws CommandExecutionException {
        IdentificationResultCollection containerResults = new IdentificationResultCollection(request);
        for (IdentificationResult identResult : results.getResults()) {
            String filePuid = identResult.getPuid();
            if (filePuid == null) continue;
            TriggerPuid containerPuid = null;
            for (TriggerPuid tp : containerSignatureTriggerPuids) {
                if (!tp.getPuid().equals(filePuid)) continue;
                containerPuid = tp;
                break;
            }
            if (containerPuid == null) continue;
            ContainerFileIdentificationRequestFactory requestFactory = new ContainerFileIdentificationRequestFactory();
            String containerType = containerPuid.getContainerType();
            if ("OLE2".equals(containerType)) {
                try {
                    Ole2ContainerContentIdentifier ole2Identifier = new Ole2ContainerContentIdentifier();
                    ole2Identifier.init(containerSignatureDefs, containerType);
                    Ole2IdentifierEngine ole2IdentifierEngine = new Ole2IdentifierEngine();
                    ole2IdentifierEngine.setRequestFactory((IdentificationRequestFactory)requestFactory);
                    ole2Identifier.setIdentifierEngine((IdentifierEngine)ole2IdentifierEngine);
                    ole2Identifier.process(request.getSourceInputStream(), containerResults);
                }
                catch (IOException e) {
                    Logger.warn("Couldn't identify OLE2 container in more detail", e);
                }
                continue;
            }
            if ("ZIP".equals(containerType)) {
                try {
                    ZipContainerContentIdentifier zipIdentifier = new ZipContainerContentIdentifier();
                    zipIdentifier.init(containerSignatureDefs, containerType);
                    ZipIdentifierEngine zipIdentifierEngine = new ZipIdentifierEngine();
                    zipIdentifierEngine.setRequestFactory((IdentificationRequestFactory)requestFactory);
                    zipIdentifier.setIdentifierEngine((IdentifierEngine)zipIdentifierEngine);
                    zipIdentifier.process(request.getSourceInputStream(), containerResults);
                }
                catch (IOException e) {
                    Logger.warn("Couldn't identify ZIP container in more detail", e);
                }
                continue;
            }
            throw new CommandExecutionException("Unknown container type: " + containerPuid);
        }
        IdentificationResultCollection finalContainerResults = new IdentificationResultCollection(request);
        for (IdentificationResult r : containerResults.getResults()) {
            FileFormat ff = signatureIdentificator.getFileFormatForPuid(r.getPuid());
            finalContainerResults.addResult((IdentificationResult)new MetadataProviderDROID_IdentificationResult(r, ff));
        }
        return finalContainerResults;
    }

    static {
        File containerSignatureFileObject;
        signatureFile = DEFAULT_SIGNATURE_FILE;
        containerSignatureFile = DEFAULT_CONTAINER_SIGNATURE_FILE;
        extensionUsage = 1;
        signatureIdentificator = null;
        containerSignatureDefs = null;
        containerSignatureTriggerPuids = null;
        isInitialized = false;
        File signatureFileObject = ResourceUtil.getResource(DEFAULT_SIGNATURE_FILE);
        if (signatureFileObject != null) {
            try {
                signatureFile = signatureFileObject.getCanonicalPath();
            }
            catch (IOException e) {
                Logger.debug("error reading DEFAULT_SIGNATURE_FILE: /config/DROID_SignatureFile_V95.xml " + e);
            }
        }
        if ((containerSignatureFileObject = ResourceUtil.getResource(DEFAULT_CONTAINER_SIGNATURE_FILE)) != null) {
            try {
                containerSignatureFile = containerSignatureFileObject.getCanonicalPath();
            }
            catch (IOException e) {
                Logger.debug("error reading DEFAULT_CONTAINER_SIGNATURE_FILE: /config/container-signature-20180920.xml " + e);
            }
        }
    }
}

