/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.launcher;

import ch.docuteam.darc.mets.Document;
import ch.docuteam.packer.gui.FileProperty;
import ch.docuteam.packer.gui.launcher.DateTableCellRenderer;
import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.packer.gui.launcher.SIPTableModel;
import ch.docuteam.tools.translations.I18N;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class SIPTable {
    private LauncherView launcherView;
    private JTable table;
    private SIPTableModel sipTableModel;
    private FileProperty selectedSip;

    public JTable getTable() {
        return this.table;
    }

    public SIPTableModel getSipTableModel() {
        return this.sipTableModel;
    }

    public SIPTable(LauncherView launcherView) {
        this.launcherView = launcherView;
        this.sipTableModel = new SIPTableModel(launcherView);
        this.table = new JTable(this.sipTableModel);
        this.table.setName("SIP_TABLE");
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SIPTable.this.listSelectionChanged(e);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SIPTable.this.listSelectionWasClicked(e);
            }
        });
        this.table.getColumnModel().getColumn(1).setMinWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(1).setMaxWidth(500);
        this.table.getColumnModel().getColumn(2).setMinWidth(80);
        this.table.getColumnModel().getColumn(2).setMaxWidth(80);
        DefaultTableCellRenderer rightAlignmentRenderer = new DefaultTableCellRenderer();
        rightAlignmentRenderer.setHorizontalAlignment(4);
        this.table.getColumnModel().getColumn(2).setCellRenderer(rightAlignmentRenderer);
        this.table.getColumnModel().getColumn(3).setMinWidth(150);
        this.table.getColumnModel().getColumn(3).setMaxWidth(150);
        this.table.getColumnModel().getColumn(3).setCellRenderer(new DateTableCellRenderer());
        this.table.getColumnModel().getColumn(4).setMinWidth(40);
        this.table.getColumnModel().getColumn(4).setMaxWidth(40);
        this.table.setAutoCreateRowSorter(true);
        String open = "open.sip.readwrite";
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.table.getInputMap(1).put(enter, open);
        this.table.getActionMap().put(open, launcherView.getOpenSIPInWorkspaceAction());
        open = "open.sip.readwrite.no.file.ops.action";
        enter = KeyStroke.getKeyStroke(10, 512);
        this.table.getInputMap(1).put(enter, open);
        this.table.getActionMap().put(open, launcherView.getOpenSIPInWorkspaceReadWriteNoFileOpsAction());
        open = "open.sip.readonly";
        enter = KeyStroke.getKeyStroke(10, 64);
        this.table.getInputMap(1).put(enter, open);
        this.table.getActionMap().put(open, launcherView.getOpenSIPInWorkspaceReadOnlyAction());
    }

    protected void listSelectionChanged(ListSelectionEvent e) {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            this.selectedSip = null;
            this.launcherView.setSelectedSIP(null);
        } else if (selectedRow < this.sipTableModel.getRowCount()) {
            this.selectedSip = this.sipTableModel.getSipAtIndex(this.table.convertRowIndexToModel(selectedRow));
            this.launcherView.setSelectedSIP(this.selectedSip);
        } else {
            this.selectedSip = null;
            this.launcherView.setSelectedSIP(null);
        }
        this.launcherView.getFooterTextField().setText(this.selectedSip == null ? "" : this.selectedSip.getFile().getPath());
        this.launcherView.enableOrDisableActions();
    }

    public void rereadSIPTable() {
        this.sipTableModel.readDirContent();
        this.sipTableModel.fireTableDataChanged();
        this.sipTableModel.updateSizeAndLockedByColumns();
        int selectedSipNewRow = this.sipTableModel.getRowIndexOfSip(this.selectedSip);
        if (selectedSipNewRow > -1) {
            try {
                this.table.getSelectionModel().setSelectionInterval(selectedSipNewRow, selectedSipNewRow);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void listSelectionWasClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if (Document.isLockedBySomebodyElse(this.selectedSip.getFile()) && JOptionPane.showConfirmDialog(this.launcherView, I18N.translate((String)"LabelIsLocked") + Document.lockedByWhom(this.selectedSip.getFile()), I18N.translate((String)"TitleOpenSIP"), 2) != 0) {
                return;
            }
            if ((e.getModifiersEx() & 0x240) == 0) {
                this.launcherView.openSelectedSIPInWorkspace(Document.Mode.ReadWrite);
            } else if ((e.getModifiersEx() & 0x240) == 512) {
                this.launcherView.openSelectedSIPInWorkspace(Document.Mode.ReadWriteNoFileOps);
            } else if ((e.getModifiersEx() & 0x240) == 64) {
                this.launcherView.openSelectedSIPInWorkspace(Document.Mode.ReadOnly);
            }
        } else if (e.getButton() == 3) {
            int rowNumber = this.table.rowAtPoint(e.getPoint());
            this.table.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
            this.launcherView.getPopupMenu().show(this.table, e.getX(), e.getY());
        }
    }
}

