/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView.actions;

import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.NodeFileDeletionNotAllowedException;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.packer.gui.sipView.actions.AbstractSIPViewAction;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JOptionPane;

public class DeleteFileContentAction
extends AbstractSIPViewAction {
    public DeleteFileContentAction(SIPView sipView) {
        super(I18N.translate((String)"DeleteFileContent"), PackerConstants.getImageIcon("Delete.png"), sipView);
        this.putValue("ShortDescription", I18N.translate((String)"ToolTipDeleteFileContent"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int selectedRowCount = this.sipView.getTreeTable().getSelectedRowCount();
        if (selectedRowCount == 0) {
            return;
        }
        int[] selectedRows = this.sipView.getTreeTable().getSelectedRows();
        if (JOptionPane.showConfirmDialog(this.sipView, I18N.translate((String)"QuestionDeleteFileContent"), I18N.translate((String)"TitleDeleteFileContent"), 0) == 0) {
            try {
                for (int selectedRow : selectedRows) {
                    ((NodeFile)this.sipView.getTreeTable().getPathForRow(selectedRow).getLastPathComponent()).deleteFileContent();
                    this.sipView.getTreeTableModel().refreshTreeStructure(this.sipView.getTreeTable().getPathForRow(selectedRow));
                    this.sipView.getTreeTableModel().refreshNode(this.sipView.getTreeTable().getPathForRow(selectedRow));
                }
            }
            catch (FileOperationNotAllowedException | FileUtilExceptionListException | IOException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NodeFileDeletionNotAllowedException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            return;
        }
    }

    @Override
    public void enableOrDisable() {
        int[] selectedRows;
        int selectedRowCount = this.sipView.getTreeTable().getSelectedRowCount();
        boolean isEnabled = this.sipView.getDocument().getMode().equals((Object)Document.Mode.ReadWrite) && selectedRowCount > 0;
        for (int selected : selectedRows = this.sipView.getTreeTable().getSelectedRows()) {
            NodeAbstract node = (NodeAbstract)this.sipView.getTreeTable().getPathForRow(selected).getLastPathComponent();
            boolean enabledForCurrentNode = node.isFile() && node.canWrite() && node.getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.Submitted);
            isEnabled &= enabledForCurrentNode;
        }
        this.setEnabled(isEnabled);
    }
}

