/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView.actions;

import ch.docuteam.darc.mets.Document;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.packer.gui.sipView.actions.AbstractSIPViewAction;
import ch.docuteam.tools.os.SystemProcess;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.awt.event.ActionEvent;
import java.io.File;

public class ExploreAction
extends AbstractSIPViewAction {
    public ExploreAction(SIPView sipView) {
        super(I18N.translate((String)"ButtonExplore"), PackerConstants.getImageIcon("Explore.png"), sipView);
        this.putValue("ShortDescription", I18N.translate((String)"ToolTipExplore"));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Document document = this.sipView.getDocument();
        if (document == null) {
            return;
        }
        try {
            String originalSIPFolder;
            if (document.isModified()) {
                document.saveWithoutBackup();
            }
            if ((originalSIPFolder = document.getOriginalSIPFolder()) != null) {
                if (originalSIPFolder.endsWith(".zip") || originalSIPFolder.endsWith(".ZIP")) {
                    SystemProcess.openExternally((String)new File(originalSIPFolder).getParent());
                } else {
                    SystemProcess.openExternally((String)originalSIPFolder);
                }
            } else {
                SystemProcess.openExternally((String)new File(document.getFilePath()).getParent());
            }
        }
        catch (Exception ex) {
            Logger.error((Object)I18N.translate((String)"MessageExploreActionException"), (Throwable)ex);
        }
    }

    @Override
    public void enableOrDisable() {
        this.setEnabled(true);
    }
}

