/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui;

import ch.docuteam.darc.mets.Document;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class FileProperty
implements Comparable<FileProperty> {
    private NumberFormat sizeFormatter = DecimalFormat.getInstance();
    private boolean isInWorkspace;
    private File file;
    private Document document;
    private String name;
    private String lockedBy;
    private Long size;
    private Long lastModified;

    public FileProperty(File file, boolean isInWorkspace) {
        this.isInWorkspace = isInWorkspace;
        this.file = file;
        Path path = Paths.get(file.getPath(), new String[0]);
        this.name = path.getFileName().toString();
        BasicFileAttributes attrs = null;
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                path = path.resolve("mets.xml");
                attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            } else {
                attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                this.size = attrs.size();
            }
            this.lastModified = attrs.lastModifiedTime().toMillis();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isInWorkspace() {
        return this.isInWorkspace;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setLockedBy(String lockedBy) {
        this.lockedBy = lockedBy;
    }

    public String getLockedBy() {
        return this.lockedBy == null ? "?" : this.lockedBy;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String getSize() {
        return this.size == null ? "?" : this.sizeFormatter.format(this.size / 1024L);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isLocked() {
        return Document.isLockedBySomebodyElse(this.file);
    }

    @Override
    public int compareTo(FileProperty other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileProperty other = (FileProperty)obj;
        return !(this.file == null ? other.file != null : !this.file.getName().equals(other.file.getName()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.getName().hashCode());
        return result;
    }
}

