/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView;

import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.packer.gui.sipView.tableModel.BadFilesTableModel;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class TestOrAssignSADialog
extends JDialog {
    protected JComboBox saComboBox;
    protected JButton setSAButton;
    protected JButton deleteAllButton;
    protected JButton markAllButton;
    protected JLabel badFilesCountLabel;
    protected JTable badFilesTable;
    protected SubmissionAgreement.Overview selectedSAOverview;
    protected boolean setSAButtonClicked = false;
    protected SIPView sipView;

    protected TestOrAssignSADialog(SIPView sipView) {
        super(sipView, I18N.translate((String)"TitleTestOrAssignSADialog"), true);
        this.sipView = sipView;
        this.setSAButtonClicked = false;
        this.setDefaultCloseOperation(2);
        this.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        this.saComboBox = new JComboBox<Object>(this.getAllFinalSAOverviews().toArray());
        this.saComboBox.setSelectedIndex(0);
        this.saComboBox.setToolTipText(I18N.translate((String)"ToolTipSelectSA"));
        this.saComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestOrAssignSADialog.this.saSelected();
            }
        });
        this.setSAButton = new JButton(PackerConstants.getImageIcon("Go.png"));
        this.setSAButton.setToolTipText(I18N.translate((String)"ToolTipSetSA"));
        this.setSAButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestOrAssignSADialog.this.setSAButtonClicked();
            }
        });
        this.deleteAllButton = new JButton(PackerConstants.getImageIcon("Delete.png"));
        this.deleteAllButton.setToolTipText(I18N.translate((String)"ToolTipDeleteAllBadFiles"));
        this.deleteAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestOrAssignSADialog.this.deleteAllButtonClicked();
            }
        });
        this.markAllButton = new JButton(PackerConstants.getImageIcon("Mark.png"));
        this.markAllButton.setToolTipText(I18N.translate((String)"ToolTipMarkAllBadFiles"));
        this.markAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestOrAssignSADialog.this.markAllButtonClicked();
            }
        });
        this.badFilesTable = new JTable(new BadFilesTableModel());
        this.badFilesTable.setSelectionMode(0);
        this.badFilesTable.getColumnModel().getColumn(1).setMaxWidth(30);
        this.badFilesCountLabel = new JLabel();
        Box buttonBox = new Box(0);
        buttonBox.add(this.setSAButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.markAllButton);
        buttonBox.add(this.deleteAllButton);
        GridBagPanel gridBag = new GridBagPanel((Border)new EmptyBorder(10, 10, 10, 10), new Insets(5, 5, 5, 5));
        gridBag.add((Component)new JLabel(I18N.translate((String)"LabelSelectSA")), 1, 1, 1, 2, 17);
        gridBag.add((Component)this.saComboBox, 2, 2, 1, 2, 17, 2, 1.0, 0.0);
        gridBag.add((Component)new JLabel(I18N.translate((String)"LabelBadFilesTable")), 3, 3, 1, 2, 17);
        gridBag.add((Component)new JScrollPane(this.badFilesTable), 4, 4, 1, 2, 10, 1, 1.0, 1.0);
        gridBag.add((Component)this.badFilesCountLabel, 5, 1, 17);
        gridBag.add((Component)buttonBox, 5, 2, 13);
        this.add((Component)gridBag);
        gridBag.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Close");
        gridBag.getActionMap().put("Close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestOrAssignSADialog.this.close();
            }
        });
        this.setPreferredSize(new Dimension(600, 400));
        this.pack();
        this.setLocationRelativeTo(sipView);
        this.saComboBox.setSelectedIndex(0);
        this.setVisible(true);
    }

    protected void saSelected() {
        this.selectedSAOverview = (SubmissionAgreement.Overview)this.saComboBox.getSelectedItem();
        if (this.selectedSAOverview == null) {
            ((BadFilesTableModel)this.badFilesTable.getModel()).getList().clear();
            this.badFilesCountLabel.setText("0");
            this.enableOrDisableButtonsAndFields();
            return;
        }
        SubmissionAgreement selectedSA = null;
        try {
            selectedSA = this.selectedSAOverview.getSubmissionAgreement();
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        if (selectedSA == null) {
            ((BadFilesTableModel)this.badFilesTable.getModel()).getList().clear();
            this.badFilesCountLabel.setText("0");
            this.enableOrDisableButtonsAndFields();
            return;
        }
        List<NodeFile> badFiles = this.sipView.getDocument().filesNotAllowedBySubmissionAgreement(selectedSA, this.selectedSAOverview.dssId);
        ((BadFilesTableModel)this.badFilesTable.getModel()).setList(badFiles);
        this.badFilesCountLabel.setText("" + badFiles.size());
        this.enableOrDisableButtonsAndFields();
    }

    protected void setSAButtonClicked() {
        if (this.selectedSAOverview == null) {
            return;
        }
        List<NodeFile> badFiles = null;
        try {
            badFiles = this.sipView.getDocument().setSubmissionAgreement(this.selectedSAOverview.saId, this.selectedSAOverview.dssId);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        if (badFiles == null) {
            ((BadFilesTableModel)this.badFilesTable.getModel()).getList().clear();
            this.badFilesCountLabel.setText("0");
            this.enableOrDisableButtonsAndFields();
            return;
        }
        ((BadFilesTableModel)this.badFilesTable.getModel()).setList(badFiles);
        this.badFilesCountLabel.setText("" + badFiles.size());
        this.setSAButtonClicked = true;
        this.enableOrDisableButtonsAndFields();
    }

    protected void deleteAllButtonClicked() {
        for (NodeFile nodeFile : ((BadFilesTableModel)this.badFilesTable.getModel()).getList()) {
            try {
                nodeFile.delete();
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        ((BadFilesTableModel)this.badFilesTable.getModel()).clearList();
        this.badFilesCountLabel.setText("0");
        this.enableOrDisableButtonsAndFields();
    }

    protected void markAllButtonClicked() {
        for (NodeFile nodeFile : ((BadFilesTableModel)this.badFilesTable.getModel()).getList()) {
            nodeFile.setIsNotAllowedBySA();
        }
        ((BadFilesTableModel)this.badFilesTable.getModel()).fireTableDataChanged();
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    protected List<SubmissionAgreement.Overview> getAllFinalSAOverviews() {
        List<SubmissionAgreement.Overview> saOverviewList = SubmissionAgreement.getAllFinalOverviews();
        saOverviewList.add(0, null);
        for (SubmissionAgreement.Overview overview : saOverviewList) {
            if (overview == null || !overview.saId.equals(this.sipView.getDocument().getSAId()) || !overview.dssId.equals(this.sipView.getDocument().getDSSId())) continue;
            saOverviewList.remove(overview);
            saOverviewList.add(0, overview);
            break;
        }
        return saOverviewList;
    }

    protected void enableOrDisableButtonsAndFields() {
        if (this.selectedSAOverview == null) {
            this.setSAButton.setEnabled(false);
            this.markAllButton.setEnabled(false);
            this.deleteAllButton.setEnabled(false);
            return;
        }
        this.setSAButton.setEnabled(true);
        if (this.setSAButtonClicked) {
            this.markAllButton.setEnabled(true);
            this.deleteAllButton.setEnabled(true);
        } else {
            this.markAllButton.setEnabled(false);
            this.deleteAllButton.setEnabled(false);
        }
    }
}

