/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView.cellRenderer;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.tools.translations.I18N;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class MyTreeCellRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        MyTreeCellRenderer component = (MyTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value == null) {
            return component;
        }
        NodeAbstract node = (NodeAbstract)value;
        component.setText(node.getLabel());
        StringBuilder toolTipBuilder = new StringBuilder("<html>");
        toolTipBuilder.append(I18N.translate((String)"HeaderName")).append(" ").append(node.getLabel()).append("<br>").append(I18N.translate((String)"LabelTitle")).append(" ").append(node.getUnitTitle()).append("<br>").append(I18N.translate((String)"LabelLevel")).append(" ").append(node.getLevel() != null ? node.getLevel().getName() : "?").append("<br>");
        try {
            if (!node.isAllowedBySA()) {
                component.setIcon(PackerConstants.ICON_NOT_ALLOWED_BY_SA);
                toolTipBuilder.append("(").append(I18N.translate((String)"ToolTipIconNotAllowedBySA")).append(")");
            } else if (!node.doesParentAllowMyLevel()) {
                if (node.isFile() && (((NodeFile)node).getMigrationDerivedNode() != null || ((NodeFile)node).getMigrationSourceNode() != null)) {
                    ImageIcon icon = node.getLevel().getIcon();
                    if (icon == null) {
                        component.setIcon(PackerConstants.ICON_LEVEL_UNKNOWN);
                        toolTipBuilder.append("(").append(I18N.translate((String)"ToolTipLevelIconCouldNotBeFound")).append(")");
                    } else {
                        component.setIcon(icon);
                    }
                } else {
                    component.setIcon(PackerConstants.ICON_LEVEL_NOT_ALLOWED);
                    toolTipBuilder.append("(").append(I18N.translate((String)"ToolTipLevelIconParentDoesntAllow", (Object[])new Object[]{((NodeFolder)node.getParent()).getLevel().getName(), node.getLevel().getName()})).append(")");
                }
            } else if (node.getLevel() == null) {
                component.setIcon(PackerConstants.ICON_LEVEL_UNKNOWN);
            } else {
                ImageIcon icon = node.getLevel().getIcon();
                if (icon == null) {
                    component.setIcon(PackerConstants.ICON_LEVEL_UNKNOWN);
                    toolTipBuilder.append("(").append(I18N.translate((String)"ToolTipLevelIconCouldNotBeFound")).append(")");
                } else {
                    component.setIcon(icon);
                }
            }
        }
        catch (Exception x) {
            component.setIcon(PackerConstants.ICON_LEVEL_UNKNOWN);
            toolTipBuilder.append("(").append(I18N.translate((String)"ToolTipLevelIconCouldNotBeLoaded")).append(")");
        }
        if (!node.fileExists()) {
            toolTipBuilder.append("<br>*****&nbsp;&nbsp;&nbsp;").append(I18N.translate((String)"ToolTipFileIsMissing"));
        } else if (!node.canRead()) {
            toolTipBuilder.append("<br>*****&nbsp;&nbsp;&nbsp;").append(I18N.translate((String)"ToolTipFileIsNotReadable"));
        } else if (!node.canWrite()) {
            toolTipBuilder.append("<br>*****&nbsp;&nbsp;&nbsp;").append(I18N.translate((String)"ToolTipFileIsReadOnly"));
        }
        component.setToolTipText(toolTipBuilder.toString());
        return component;
    }
}

