/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class AbstractProfileResource {
    private String location;
    @XmlElement(name="Size")
    private long size;
    @XmlElement(name="LastModifiedDate")
    private Date lastModifiedDate;
    @XmlElement(name="Extension")
    private String extension;
    @XmlElement(name="Name")
    private String name;
    @XmlElement(name="Uri")
    private URI uri;
    @XmlElement(name="Path")
    private String path;

    AbstractProfileResource() {
    }

    public String getLocation() {
        return this.location;
    }

    void setLocation(String location) {
        this.location = location;
        try {
            this.uri = new URI(location);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected void setUri(URI uri) {
        this.uri = uri;
        this.location = uri.toString();
        String decodedLocation = URLDecoder.decode(this.location);
        int uriPrefix = decodedLocation.indexOf(":/");
        this.path = decodedLocation.substring(uriPrefix + 2);
    }

    public abstract boolean isDirectory();

    public boolean isRecursive() {
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uri).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProfileResource other = (AbstractProfileResource)obj;
        return new EqualsBuilder().append((Object)this.uri, (Object)other.uri).isEquals();
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

