/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile.export;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.QueryBuilder;
import uk.gov.nationalarchives.droid.export.interfaces.ItemReader;
import uk.gov.nationalarchives.droid.export.interfaces.ItemReaderCallback;
import uk.gov.nationalarchives.droid.export.interfaces.JobCancellationException;
import uk.gov.nationalarchives.droid.profile.JDBCProfileDao;
import uk.gov.nationalarchives.droid.profile.NodeMetaData;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.SqlUtils;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.results.handlers.JDBCBatchResultHandlerDao;

public class JDBCSqlItemReader<T>
implements ItemReader<T> {
    private static final String PUID = "PUID";
    private static final String NODE_ID = "NODE_ID";
    private static final String NAME = "NAME";
    private static final String EMPTY_FOLTER_SUBSELECT = " CASE \n\t\t  WHEN p.RESOURCE_TYPE = 0 THEN \n\t\t  \tCASE\n\t\t  \t\twhen NOT EXISTS(SELECT NODE2.PARENT_ID FROM PROFILE_RESOURCE_NODE NODE2 WHERE NODE2.PARENT_ID = p.NODE_ID) then true\n\t\t  \t\telse false\n\t\t  \tEND\n\t\t  ELSE false\n\t\tEND as EMPTY_DIR,  ";
    private static final String SELECT_PROFILE_ALL_FIELDS = "select p.*, ";
    private ResultSet cursor;
    private PreparedStatement profileStatement;
    private int fetchSize;
    private int chunkSize;
    private DataSource datasource;
    private JDBCBatchResultHandlerDao resultHandlerDao;
    private IdentificationReader identificationReader;
    private final Log log = LogFactory.getLog(this.getClass());
    private final Class<T> typeParameterClass;
    private Filter filter;

    public JDBCSqlItemReader() {
        this.typeParameterClass = ProfileResourceNode.class;
    }

    public JDBCSqlItemReader(Class<T> typeParameterClass) {
        this.typeParameterClass = typeParameterClass;
    }

    public JDBCBatchResultHandlerDao getResultHandlerDao() {
        return this.resultHandlerDao;
    }

    public void setResultHandlerDao(JDBCBatchResultHandlerDao resultHandlerDao) {
        this.resultHandlerDao = resultHandlerDao;
        this.datasource = resultHandlerDao.getDatasource();
    }

    private ProfileResourceNode readNode() {
        try {
            if (this.cursor.next()) {
                int numberOfIdentifications;
                ProfileResourceNode profileResourceNode = this.filter != null && this.filter.isEnabled() ? (ProfileResourceNode)JDBCProfileDao.PROFILE_RESOURCE_NODE_ROW_MAPPER.mapRow(this.cursor, 0) : (ProfileResourceNode)JDBCProfileDao.PROFILE_RESOURCE_NODE_ROW_MAPPER_WITH_EMPTY_FOLDER.mapRow(this.cursor, 0);
                NodeMetaData metaData = profileResourceNode.getMetaData();
                for (int i = numberOfIdentifications = this.cursor.getInt("id_count"); i > 0; --i) {
                    String puid = this.cursor.getString(PUID);
                    if (this.cursor.getLong(NODE_ID) != profileResourceNode.getId().longValue()) {
                        throw new SQLDataException("Unexpected node ID during traversal of identification results!");
                    }
                    Format format = this.identificationReader.getFormatForPuid(puid);
                    profileResourceNode.addFormatIdentification(format);
                    if (i > 1 && !this.cursor.next()) break;
                }
                if (metaData.getResourceType() != ResourceType.FOLDER && profileResourceNode.getIdentificationCount() == null) {
                    profileResourceNode.setZeroIdentifications();
                }
                return new ProfileResourceNode(profileResourceNode);
            }
        }
        catch (SQLException ex) {
            this.log.error((Object)"SQL Exception error reading Profile resource Node in JDBCSqlItemReader class", (Throwable)ex);
        }
        return null;
    }

    public T read() {
        if (this.typeParameterClass.isAssignableFrom(ProfileResourceNode.class)) {
            ProfileResourceNode node = this.readNode();
            return (T)node;
        }
        throw new NotImplementedException("Unsupported generic type for JDBCSqlItemReader!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAll(ItemReaderCallback<T> callback, Filter itemFilter) throws JobCancellationException {
        this.open(itemFilter);
        this.identificationReader = new IdentificationReader();
        try {
            T item;
            ArrayList<T> chunk = new ArrayList<T>();
            while ((item = this.read()) != null) {
                chunk.add(item);
                if (chunk.size() != this.chunkSize) continue;
                callback.onItem(chunk);
                chunk = new ArrayList();
            }
            if (!chunk.isEmpty()) {
                callback.onItem(chunk);
                ArrayList arrayList = new ArrayList();
            }
        }
        finally {
            this.close();
        }
    }

    public void open(Filter itemFilter) {
        this.filter = itemFilter;
        this.cursor = this.getProfileCursor(itemFilter);
    }

    public void close() {
        try {
            if (this.cursor != null) {
                this.cursor.close();
            }
            if (this.profileStatement != null) {
                this.profileStatement.close();
            }
            this.identificationReader.closeResources();
        }
        catch (SQLException e) {
            this.log.error((Object)"Error cleaning up JDBSCSqlItemReader", (Throwable)e);
        }
    }

    private ResultSet getProfileCursor(Filter filter) {
        ResultSet profileResultSet = null;
        try {
            boolean filterExists;
            Connection conn = this.datasource.getConnection();
            String queryString = "";
            boolean bl = filterExists = filter != null && filter.isEnabled();
            if (filterExists) {
                QueryBuilder queryBuilder = SqlUtils.getQueryBuilder(filter);
                String ejbFragment = queryBuilder.toEjbQl();
                boolean formatCriteriaExist = ejbFragment.contains("format.");
                String sqlFilter = SqlUtils.transformEJBtoSQLFields(ejbFragment, "p", "f");
                queryString = SELECT_PROFILE_ALL_FIELDS;
                queryString = queryString + "(select count('x') from identification i1 where i1.node_id = p.node_id) AS id_count, i.PUID ";
                queryString = queryString + "from profile_resource_node p inner join identification i on p.node_id = i.node_id ";
                if (formatCriteriaExist) {
                    queryString = queryString + " inner join format f on f.puid = i.puid ";
                }
                queryString = queryString + "where p.node_id IN (SELECT p2.node_id FROM profile_resource_node p2 ";
                queryString = queryString + " INNER JOIN identification i2 ON p2.node_id = i2.node_id ";
                queryString = queryString + "INNER JOIN format f2 on i2.puid = f2.puid ";
                queryString = queryString + "WHERE " + sqlFilter.replace("f.", "f2.") + ") order by p.uri,p.node_id";
                int i = 0;
                this.profileStatement = conn.prepareStatement(queryString);
                block8: for (Object value : queryBuilder.getValues()) {
                    Object value2 = SqlUtils.transformParameterToSQLValue(value);
                    String className = value2.getClass().getSimpleName();
                    switch (ClassName.valueOf(className)) {
                        case String: {
                            this.profileStatement.setString(++i, (String)value2);
                            continue block8;
                        }
                        case Date: {
                            java.util.Date d = (java.util.Date)value2;
                            this.profileStatement.setDate(++i, new Date(d.getTime()));
                            continue block8;
                        }
                        case Long: {
                            this.profileStatement.setLong(++i, (Long)value2);
                            continue block8;
                        }
                        case Integer: {
                            this.profileStatement.setInt(++i, (Integer)value2);
                            continue block8;
                        }
                        default: {
                            this.log.error((Object)"Invalid filter parameter type in JDBCSQLItemReader");
                        }
                    }
                }
            } else {
                queryString = SELECT_PROFILE_ALL_FIELDS;
                queryString = queryString + EMPTY_FOLTER_SUBSELECT;
                queryString = queryString + "(select count('x') from identification i1 where i1.node_id = p.node_id) AS id_count, i.PUID ";
                queryString = queryString + "from profile_resource_node p  inner join identification i on p.node_id = i.node_id order by p.uri,p.node_id";
                this.profileStatement = conn.prepareStatement(queryString);
            }
            profileResultSet = this.profileStatement.executeQuery();
        }
        catch (SQLException ex) {
            this.log.error((Object)"A database exception occurred retrieving nodes ", (Throwable)ex);
        }
        return profileResultSet;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    private class IdentificationReader {
        private static final String FORMAT_QUERY = "SELECT T1.NODE_ID, T1.PUID, T2.MIME_TYPE, T2.NAME, T2.VERSION FROM IDENTIFICATION AS T1 INNER JOIN FORMAT AS T2 ON T1.PUID = T2.PUID WHERE T1.NODE_ID = ?";
        private static final String FORMAT_QUERY_RANGE = "SELECT T1.NODE_ID, T1.PUID, T2.MIME_TYPE, T2.NAME, T2.VERSION FROM IDENTIFICATION AS T1 INNER JOIN FORMAT AS T2 ON T1.PUID = T2.PUID WHERE T1.NODE_ID BETWEEN ? AND ?";
        private static final String SELECT_FORMATS = "SELECT * FROM FORMAT";
        private static final String SELECT_FORMAT_COUNT = "SELECT COUNT('x') AS total FROM FORMAT";
        private Map<String, Format> formats;
        private Connection connection;
        private PreparedStatement formatsStatement;

        IdentificationReader() {
            try {
                this.connection = JDBCSqlItemReader.this.datasource.getConnection();
                this.formatsStatement = this.connection.prepareStatement(FORMAT_QUERY);
                this.formats = this.loadAllFormats();
            }
            catch (SQLException ex) {
                JDBCSqlItemReader.this.log.error((Object)"Error retrieving SQL connection for format identifications", (Throwable)ex);
            }
        }

        List<Format> getFormatsForResourceNode(long nodeId) {
            try {
                this.formatsStatement.setLong(1, nodeId);
                ResultSet rs = this.formatsStatement.executeQuery();
                ArrayList<Format> formatsList = new ArrayList<Format>();
                while (rs.next()) {
                    Format format = new Format();
                    format.setPuid(rs.getString(JDBCSqlItemReader.PUID));
                    format.setMimeType(rs.getString("MIME_TYPE"));
                    format.setName(rs.getString(JDBCSqlItemReader.NAME));
                    format.setVersion(rs.getString("VERSION"));
                    formatsList.add(format);
                }
                rs.close();
                return formatsList;
            }
            catch (SQLException ex) {
                JDBCSqlItemReader.this.log.error((Object)"Error retrieving format identifications", (Throwable)ex);
                return Collections.EMPTY_LIST;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Format> loadAllFormats() {
            HashMap<String, Format> formatsToLoad = null;
            try (Connection conn = JDBCSqlItemReader.this.datasource.getConnection();){
                formatsToLoad = new HashMap<String, Format>();
                try (PreparedStatement loadFormat = conn.prepareStatement(SELECT_FORMATS);
                     ResultSet results = loadFormat.executeQuery();){
                    while (results.next()) {
                        String puid = results.getString(JDBCSqlItemReader.PUID);
                        formatsToLoad.put(puid, SqlUtils.buildFormat(results));
                    }
                }
            }
            catch (SQLException e) {
                JDBCSqlItemReader.this.log.error((Object)"A database exception occurred getting all formats.", (Throwable)e);
            }
            return formatsToLoad;
        }

        public Format getFormatForPuid(String puid) {
            Format format = this.formats.get(puid);
            return format;
        }

        private void closeResources() {
            try {
                if (this.formatsStatement != null) {
                    this.formatsStatement.close();
                }
            }
            catch (SQLException e) {
                JDBCSqlItemReader.this.log.error((Object)"Error cleaning up resources for IdentificationReader", (Throwable)e);
            }
        }
    }

    private static enum ClassName {
        String,
        Date,
        Long,
        Integer,
        Boolean;

    }
}

