/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import uk.gov.nationalarchives.droid.report.dao.GroupByField;
import uk.gov.nationalarchives.droid.report.dao.ReportFieldType;
import uk.gov.nationalarchives.droid.report.dao.ReportLineItem;

public class StringOrSetFieldType
implements ReportFieldType {
    private static final int COUNT_INDEX = 0;
    private static final int GROUP_INDEX = 1;
    private String field;
    private boolean isGroupByExists;
    private List<GroupByField> groupingFields;

    public StringOrSetFieldType(String field) {
        this.field = field;
    }

    @Override
    public String getSelectFieldString(List<GroupByField> groupByFields) {
        StringBuilder selectFieldQueryString = new StringBuilder();
        selectFieldQueryString.append("count(" + this.field + ") ");
        this.groupingFields = groupByFields;
        boolean bl = this.isGroupByExists = groupByFields != null && groupByFields.size() > 0;
        if (this.isGroupByExists) {
            for (GroupByField group : this.groupingFields) {
                selectFieldQueryString.append(" , ");
                String function = group.getFunction();
                if (function != null && !function.isEmpty()) {
                    selectFieldQueryString.append(function + "(");
                }
                String groupByFieldName = group.getGroupByField().getType().getField();
                selectFieldQueryString.append(groupByFieldName);
                if (function == null || function.isEmpty()) continue;
                selectFieldQueryString.append(")");
            }
        }
        return selectFieldQueryString.toString();
    }

    @Override
    public List<ReportLineItem> populateReportedData(List<?> results) {
        ArrayList<ReportLineItem> reportData = new ArrayList<ReportLineItem>();
        ReportLineItem reportLineItem = null;
        for (Object res : results) {
            reportLineItem = new ReportLineItem();
            if (this.isGroupByExists) {
                Object[] resultsArray = (Object[])res;
                Object count = resultsArray[0];
                if (count != null) {
                    Long value = new Long(((Integer)count).intValue());
                    reportLineItem.setCount(value);
                }
                ArrayList<String> values = new ArrayList<String>();
                for (int valueIndex = 0; valueIndex < this.groupingFields.size(); ++valueIndex) {
                    values.add(this.getFieldValue(resultsArray[1 + valueIndex]));
                }
                reportLineItem.setGroupByValues(values);
            } else if (res != null) {
                Long value = new Long(((Integer)res).intValue());
                reportLineItem.setCount(value);
            }
            reportData.add(reportLineItem);
        }
        return reportData;
    }

    @Override
    public List<ReportLineItem> populateReportedData(ResultSet results) throws SQLException {
        ArrayList<ReportLineItem> reportData = new ArrayList<ReportLineItem>();
        ReportLineItem reportLineItem = null;
        while (results.next()) {
            reportLineItem = new ReportLineItem();
            if (this.isGroupByExists) {
                int numberOfColumns = results.getMetaData().getColumnCount();
                Object[] resultsArray = new Object[numberOfColumns];
                for (int i = 0; i < numberOfColumns; ++i) {
                    resultsArray[i] = results.getObject(i + 1);
                }
                Object count = resultsArray[0];
                if (count != null) {
                    Long value = new Long(((Integer)count).intValue());
                    reportLineItem.setCount(value);
                }
                ArrayList<String> values = new ArrayList<String>();
                for (int valueIndex = 0; valueIndex < this.groupingFields.size(); ++valueIndex) {
                    values.add(this.getFieldValue(resultsArray[1 + valueIndex]));
                }
                reportLineItem.setGroupByValues(values);
            } else {
                Object res = results.getObject(1);
                if (res != null) {
                    Long value = new Long(((Integer)res).intValue());
                    reportLineItem.setCount(value);
                }
            }
            reportData.add(reportLineItem);
        }
        return reportData;
    }

    private String getFieldValue(Object value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public String getField() {
        return this.field;
    }
}

