/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.submitter.FileWalkerHandler;
import uk.gov.nationalarchives.droid.submitter.SubmitterUtils;

@XmlAccessorType(value=XmlAccessType.NONE)
public class FileWalker {
    private static final String FILE_SYSTEM_UNAVAILABLE = "File system appears to be unavailable for file: [%s]";
    private Log log = LogFactory.getLog(this.getClass());
    private URI root;
    @XmlAttribute(name="Recursive")
    private boolean recursive;
    @XmlElementWrapper(name="Progress")
    @XmlElement(name="ProgressEntry")
    private Deque<ProgressEntry> progress;
    private String topLevelAbsolutePath;
    private FileWalkerHandler fileHandler;
    private FileWalkerHandler directoryHandler;
    private FileWalkerHandler restrictedDirectoryHandler;
    private boolean fastForward;
    private List<ProgressEntry> recoveryRoad;

    FileWalker() {
    }

    public FileWalker(URI root, boolean recursive) {
        this.recursive = recursive;
        this.setRootUri(root);
    }

    @XmlElement(name="RootUri")
    public URI getRootUri() {
        return this.root;
    }

    public void setRootUri(URI rootUri) {
        this.root = rootUri;
        this.topLevelAbsolutePath = new File(this.root).getAbsolutePath();
    }

    public void walk() throws IOException {
        if (this.progress != null) {
            this.fastForward = true;
            this.recoveryRoad = FileWalker.reverseProgress(this.progress);
        } else {
            this.progress = new ArrayDeque<ProgressEntry>();
        }
        this.walk(new File(this.root), 0);
    }

    private static List<ProgressEntry> reverseProgress(Deque<ProgressEntry> progress) {
        ArrayList<ProgressEntry> reversed = new ArrayList<ProgressEntry>();
        Iterator<ProgressEntry> it = progress.descendingIterator();
        while (it.hasNext()) {
            ProgressEntry entry = it.next();
            reversed.add(entry);
        }
        return reversed;
    }

    private void walk(File directory, int depth) throws IOException {
        if (this.handleDirectory(directory, depth)) {
            File[] children = directory.listFiles();
            if (children != null) {
                this.handleDirectoryStart(directory, depth, children);
                if (this.recursive || depth == 0) {
                    int childDepth = depth + 1;
                    for (File child : children) {
                        if (child.isDirectory()) {
                            this.walk(child, childDepth);
                            continue;
                        }
                        this.handleFile(child, childDepth);
                    }
                }
                this.handleDirectoryEnd(directory, depth);
            } else {
                this.handleRestrictedDirectory(directory, depth);
            }
        }
    }

    protected boolean handleDirectory(File dir, int depth) throws IOException {
        boolean processDir = true;
        if (!SubmitterUtils.isFileSystemAvailable(dir, this.topLevelAbsolutePath)) {
            this.log.error((Object)String.format(FILE_SYSTEM_UNAVAILABLE, dir.getAbsolutePath()));
            throw new IOException(dir.getAbsolutePath());
        }
        if (this.fastForward && (depth >= this.recoveryRoad.size() || !this.recoveryRoad.get(depth).getFile().equals(dir))) {
            if (this.recoveryRoad.get(depth - 1).containsChild(dir)) {
                this.fastForward = false;
            } else {
                processDir = false;
            }
        }
        return processDir;
    }

    protected void handleDirectoryStart(File directory, int depth, File[] children) throws IOException {
        if (this.fastForward) {
            return;
        }
        ProgressEntry parent = this.progress.peek();
        ResourceId directoryId = this.directoryHandler.handle(directory, depth, parent);
        this.progress.push(new ProgressEntry(directory, directoryId, children));
    }

    protected void handleFile(File file, int depth) throws IOException {
        if (!SubmitterUtils.isFileSystemAvailable(file, this.topLevelAbsolutePath)) {
            this.log.error((Object)String.format(FILE_SYSTEM_UNAVAILABLE, file.getAbsolutePath()));
            throw new IOException(file.getAbsolutePath());
        }
        if (this.fastForward) {
            if (this.recoveryRoad.get(depth - 1).containsChild(file)) {
                this.fastForward = false;
            } else {
                return;
            }
        }
        ProgressEntry progressEntry = this.progress.peek();
        if (file.isFile()) {
            this.fileHandler.handle(file, depth, progressEntry);
        }
        progressEntry.removeChild(file);
    }

    protected void handleDirectoryEnd(File directory, int depth) {
        if (this.fastForward) {
            this.fastForward = false;
            while (this.progress.size() - 1 > depth) {
                this.progress.pop();
            }
        }
        this.progress.pop();
        if (!this.progress.isEmpty()) {
            this.progress.peek().removeChild(directory);
        }
    }

    private void handleRestrictedDirectory(File directory, int depth) throws IOException {
        if (this.fastForward) {
            return;
        }
        ProgressEntry parent = this.progress.peek();
        this.restrictedDirectoryHandler.handle(directory, depth, parent);
        if (!this.progress.isEmpty()) {
            this.progress.peek().removeChild(directory);
        }
    }

    public void setFileHandler(FileWalkerHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public void setDirectoryHandler(FileWalkerHandler directoryHandler) {
        this.directoryHandler = directoryHandler;
    }

    public void setRestrictedDirectoryHandler(FileWalkerHandler restrictedDirectoryHandler) {
        this.restrictedDirectoryHandler = restrictedDirectoryHandler;
    }

    Deque<ProgressEntry> progress() {
        return this.progress;
    }

    void setProgress(Deque<ProgressEntry> progress) {
        this.progress = progress;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static final class ProgressEntry {
        @XmlAttribute(name="Id")
        private long id;
        @XmlAttribute(name="Prefix")
        private String prefix;
        private File directory;
        private File[] children;

        ProgressEntry() {
        }

        ProgressEntry(File directory, long id, String prefix, File[] children) {
            this.directory = directory;
            this.id = id;
            this.prefix = prefix;
            this.children = children;
        }

        ProgressEntry(File directory, ResourceId resourceId, File[] children) {
            if (resourceId == null) {
                throw new IllegalArgumentException("Cannot construct a ProgressEntry with a null ResourceId");
            }
            this.directory = directory;
            this.id = resourceId.getId();
            this.prefix = resourceId.getPath();
            this.children = children;
        }

        @XmlElement(name="Uri")
        public URI getUri() {
            return this.directory.toURI();
        }

        public void setUri(URI theDirectory) {
            this.directory = new File(theDirectory);
        }

        @XmlElementWrapper(name="Children")
        @XmlElement(name="ChildUri")
        public List<URI> getChildUri() {
            ArrayList<URI> result = new ArrayList<URI>();
            if (this.children != null) {
                for (File child : this.children) {
                    if (child == null) continue;
                    result.add(child.toURI());
                }
            }
            return result;
        }

        public void setChildUri(List<URI> childURIs) {
            if (childURIs != null) {
                this.children = new File[childURIs.size()];
                int index = 0;
                for (URI childURI : childURIs) {
                    this.children[index++] = new File(childURI);
                }
            }
        }

        public long getId() {
            return this.id;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public ResourceId getResourceId() {
            return new ResourceId(this.id, this.prefix);
        }

        public File getFile() {
            return this.directory;
        }

        private void removeChild(File child) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (!child.equals(this.children[i])) continue;
                    this.children[i] = null;
                    break;
                }
            }
        }

        public boolean containsChild(File child) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (!child.equals(this.children[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

