/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public final class SubmitterUtils {
    private static final char FORWARD_SLASH = '/';

    private SubmitterUtils() {
    }

    static boolean isFileSystemAvailable(File file, String topLevelAbsolutePath) {
        if (SubmitterUtils.isEqualPath(file, topLevelAbsolutePath)) {
            return file.exists();
        }
        return SubmitterUtils.isFileSystemAvailable2(file, topLevelAbsolutePath);
    }

    public static URI toURI(File file, StringBuilder builder) {
        File absoluteFile = file.getAbsoluteFile();
        if (absoluteFile == null) {
            absoluteFile = new File(file.getAbsolutePath());
        }
        String path = absoluteFile.getPath();
        int length = path.length();
        char separator = File.separatorChar;
        int numStartSlashes = 0;
        if (path.charAt(0) != separator) {
            numStartSlashes = 1;
        } else if (path.charAt(1) == separator) {
            numStartSlashes = 2;
        }
        builder.setLength(0);
        for (int startSlashNum = 0; startSlashNum < numStartSlashes; ++startSlashNum) {
            builder.append('/');
        }
        if (separator == '/') {
            builder.append(path);
        } else {
            for (int charIndex = 0; charIndex < length; ++charIndex) {
                char theChar = path.charAt(charIndex);
                if (theChar == separator) {
                    builder.append('/');
                    continue;
                }
                builder.append(theChar);
            }
        }
        if (path.charAt(path.length() - 1) != separator && absoluteFile.isDirectory()) {
            builder.append('/');
        }
        URI uri = null;
        try {
            uri = new URI("file", null, builder.toString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri;
    }

    private static boolean isFileSystemAvailable2(File file, String topLevelAbsolutePath) {
        boolean available = file.exists() ? true : (SubmitterUtils.isEqualPath(file, topLevelAbsolutePath) ? false : SubmitterUtils.isFileSystemAvailable2(file.getParentFile(), topLevelAbsolutePath));
        return available;
    }

    private static boolean isEqualPath(File file1, String topLevelAbsolutePath) {
        return topLevelAbsolutePath.equals(file1.getAbsolutePath());
    }
}

