/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileWalker;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class ISOImageArchiveHandler
implements ArchiveHandler {
    private static final String PATH_SPLITTER = "!";
    private static final String UTF_8 = "UTF-8";
    private AsynchDroid droid;
    private IdentificationRequestFactory<InputStream> factory;
    private ResultHandler resultHandler;
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void handle(IdentificationRequest request) throws IOException {
        if (request.getClass().isAssignableFrom(FileSystemIdentificationRequest.class)) {
            FileSystemIdentificationRequest req = (FileSystemIdentificationRequest)request;
            Iso9660FileSystem fileSystem = new Iso9660FileSystem(req.getFile(), true);
            ISOImageArchiveWalker walker = new ISOImageArchiveWalker(this.droid, this.factory, this.resultHandler, fileSystem, request.getIdentifier());
            walker.walk(fileSystem);
        } else {
            this.log.info((Object)"Identification request for ISO image ignored due to limited support.");
        }
    }

    public void setFactory(IdentificationRequestFactory<InputStream> factory) {
        this.factory = factory;
    }

    public void setDroid(AsynchDroid droid) {
        this.droid = droid;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public static class ISOImageArchiveWalker
    extends ArchiveFileWalker<Iso9660FileEntry> {
        private final AsynchDroid droid;
        private final IdentificationRequestFactory<InputStream> factory;
        private final ResultHandler resultHandler;
        private final Iso9660FileSystem fileSystem;
        private final ResourceId rootParentId;
        private final URI isoFileUri;
        private final long originatorNodeId;
        private final Map<String, ResourceId> directories = new HashMap<String, ResourceId>();
        private final Log log = LogFactory.getLog(this.getClass());

        public ISOImageArchiveWalker(AsynchDroid droid, IdentificationRequestFactory<InputStream> factory, ResultHandler resultHandler, Iso9660FileSystem fileSystem, RequestIdentifier requestIdentifier) {
            this.droid = droid;
            this.factory = factory;
            this.resultHandler = resultHandler;
            this.fileSystem = fileSystem;
            this.rootParentId = requestIdentifier.getResourceId();
            this.isoFileUri = requestIdentifier.getUri();
            this.originatorNodeId = requestIdentifier.getNodeId();
            this.directories.put("", this.rootParentId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void submitFile(Iso9660FileEntry entry) throws IOException, URISyntaxException {
            String path = FilenameUtils.getPath((String)entry.getPath());
            String name = entry.getName();
            ResourceId correlationId = this.directories.get(path);
            if (correlationId == null) {
                correlationId = this.submitDirectory(path, entry.getLastModifiedTime());
            }
            InputStream entryInputStream = this.fileSystem.getInputStream(entry);
            try {
                RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toIsoImageUri(this.isoFileUri, path + name));
                identifier.setAncestorId(this.originatorNodeId);
                identifier.setParentResourceId(correlationId);
                RequestMetaData metaData = new RequestMetaData(entry.getSize(), entry.getLastModifiedTime(), name);
                IdentificationRequest<InputStream> request = this.factory.newRequest(metaData, identifier);
                request.open(entryInputStream);
                this.droid.submit(request);
            }
            finally {
                try {
                    if (entryInputStream != null) {
                        entryInputStream.close();
                    }
                }
                catch (IOException ex) {
                    this.log.warn((Object)"failed to close entryInputStream", (Throwable)ex);
                }
            }
        }

        private ResourceId submitDirectory(String path, long lastModifiedTime) throws URISyntaxException, UnsupportedEncodingException {
            String parentPath = FilenameUtils.getPath((String)path.substring(0, path.length() - 1));
            String name = FilenameUtils.getName((String)path.substring(0, path.length() - 1));
            this.log.debug((Object)("processing path: " + path + " name: " + name));
            ResourceId resourceId = this.directories.get(name);
            if (resourceId == null) {
                ResourceId parentID = this.directories.get(parentPath);
                if (parentID == null) {
                    parentID = this.submitDirectory(parentPath, lastModifiedTime);
                }
                RequestMetaData metaData = new RequestMetaData(null, lastModifiedTime, name);
                RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toIsoImageUri(this.isoFileUri, path));
                IdentificationResultImpl result = new IdentificationResultImpl();
                result.setRequestMetaData(metaData);
                result.setIdentifier(identifier);
                resourceId = this.resultHandler.handleDirectory(result, parentID, false);
                this.directories.put(path, resourceId);
            }
            return resourceId;
        }

        @Override
        protected void handleEntry(Iso9660FileEntry entry) throws IOException {
            try {
                if (entry.isDirectory()) {
                    if (!"".equals(entry.getPath())) {
                        this.submitDirectory(entry.getPath(), entry.getLastModifiedTime());
                    }
                } else {
                    this.submitFile(entry);
                }
            }
            catch (URISyntaxException e) {
                throw new IOException("Wrong URI syntax", e);
            }
        }
    }
}

