/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.vfs.provider.iso;

import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.vfs.provider.iso.IsoFileSystem;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class IsoFileObject
extends AbstractFileObject {
    private Iso9660FileEntry entry;
    private FileType type;
    private final Set children;

    IsoFileObject(FileName name, IsoFileSystem fs) {
        super(name, (AbstractFileSystem)fs);
        this.type = FileType.IMAGINARY;
        this.children = new HashSet();
    }

    IsoFileObject(FileName name, Iso9660FileEntry entry, IsoFileSystem fs) {
        super(name, (AbstractFileSystem)fs);
        this.setIsoEntry(entry);
        this.children = new HashSet();
    }

    void setIsoEntry(Iso9660FileEntry entry) {
        if (null != this.entry) {
            throw new RuntimeException("Cannot change the underlying entry once it has been set");
        }
        if (null == entry) {
            throw new IllegalArgumentException("'entry' cannot be null");
        }
        this.entry = entry;
        this.type = entry.isDirectory() ? FileType.FOLDER : FileType.FILE;
    }

    void attachChild(FileName childName) {
        this.children.add(childName.getBaseName());
    }

    public boolean isWriteable() {
        return false;
    }

    protected FileType doGetType() {
        return this.type;
    }

    protected String[] doListChildren() {
        return this.children.toArray(new String[this.children.size()]);
    }

    protected long doGetContentSize() {
        return this.entry.getSize();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.entry.getLastModifiedTime();
    }

    protected InputStream doGetInputStream() throws Exception {
        return ((IsoFileSystem)this.getFileSystem()).getInputStream(this.entry);
    }
}

