/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.vfs.provider.iso;

import com.github.stephenc.javaisotools.vfs.provider.iso.IsoFileSystem;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractLayeredFileProvider;
import org.apache.commons.vfs.provider.LayeredFileName;

public class IsoFileProvider
extends AbstractLayeredFileProvider {
    public static final Collection capabilities = Arrays.asList(Capability.GET_LAST_MODIFIED, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.VIRTUAL);

    public Collection getCapabilities() {
        return capabilities;
    }

    protected FileSystem doCreateFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName rootName = new LayeredFileName(scheme, file.getName(), "/", FileType.FOLDER);
        return new IsoFileSystem((FileName)rootName, file, fileSystemOptions);
    }
}

