/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.vfs.provider.iso;

import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import com.github.stephenc.javaisotools.vfs.provider.iso.IsoFileObject;
import com.github.stephenc.javaisotools.vfs.provider.iso.IsoFileProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.UriParser;

public class IsoFileSystem
extends AbstractFileSystem {
    private static final Log log = LogFactory.getLog(IsoFileSystem.class);
    private Iso9660FileSystem fileSystem;

    public IsoFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, parentLayer, fileSystemOptions);
    }

    public void init() throws FileSystemException {
        super.init();
        File file = this.getParentLayer().getFileSystem().replicateFile(this.getParentLayer(), Selectors.SELECT_SELF);
        try {
            this.fileSystem = new Iso9660FileSystem(file, true);
        }
        catch (IOException ex) {
            throw new FileSystemException("vfs.provider.iso/open-iso-file.error", (Object)file, (Throwable)ex);
        }
        ArrayList<IsoFileObject> strongRef = new ArrayList<IsoFileObject>(100);
        boolean skipRoot = false;
        for (Iso9660FileEntry entry : this.fileSystem) {
            IsoFileObject fileObj;
            String name = entry.getPath();
            if ("".equals(name)) {
                if (skipRoot) continue;
                skipRoot = true;
            }
            FileName filename = this.getFileSystemManager().resolveName(this.getRootName(), UriParser.encode((String)name));
            if (entry.isDirectory() && this.getFileFromCache(filename) != null) {
                fileObj = (IsoFileObject)this.getFileFromCache(filename);
                fileObj.setIsoEntry(entry);
                continue;
            }
            fileObj = new IsoFileObject(filename, entry, this);
            this.putFileToCache((FileObject)fileObj);
            strongRef.add(fileObj);
            fileObj.holdObject(strongRef);
            for (FileName parentName = filename.getParent(); parentName != null; parentName = parentName.getParent()) {
                IsoFileObject parent = (IsoFileObject)this.getFileFromCache(parentName);
                if (parent == null) {
                    parent = new IsoFileObject(parentName, this);
                    this.putFileToCache((FileObject)parent);
                    strongRef.add(parent);
                    parent.holdObject(strongRef);
                }
                parent.attachChild(fileObj.getName());
                fileObj = parent;
            }
        }
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(IsoFileProvider.capabilities);
    }

    protected FileObject createFile(FileName name) throws Exception {
        return new IsoFileObject(name, this);
    }

    protected void doCloseCommunicationLink() {
        if (null != this.fileSystem && !this.fileSystem.isClosed()) {
            try {
                this.fileSystem.close();
            }
            catch (IOException ex) {
                VfsLog.warn((Log)this.getLogger(), (Log)log, (String)("vfs.provider.iso/close-iso-file.error :" + this.fileSystem), (Throwable)ex);
            }
        }
    }

    public void close() {
        super.close();
        this.fileSystem = null;
    }

    InputStream getInputStream(Iso9660FileEntry entry) {
        return this.fileSystem.getInputStream(entry);
    }
}

