/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.rarfile;

import com.github.junrar.io.Raw;
import com.github.junrar.rarfile.BaseBlock;

public class EndArcHeader
extends BaseBlock {
    private static final short EARC_NEXT_VOLUME = 1;
    private static final short EARC_DATACRC = 2;
    private static final short EARC_REVSPACE = 4;
    private static final short EARC_VOLNUMBER = 8;
    private static final short endArcHeaderSize = 6;
    public static final short endArcArchiveDataCrcSize = 4;
    public static final short endArcVolumeNumberSize = 2;
    private int archiveDataCRC;
    private short volumeNumber;

    public EndArcHeader(BaseBlock bb, byte[] endArcHeader) {
        super(bb);
        int pos = 0;
        if (this.hasArchiveDataCRC()) {
            this.archiveDataCRC = Raw.readIntLittleEndian(endArcHeader, pos);
            pos += 4;
        }
        if (this.hasVolumeNumber()) {
            this.volumeNumber = Raw.readShortLittleEndian(endArcHeader, pos);
        }
    }

    public int getArchiveDataCRC() {
        return this.archiveDataCRC;
    }

    public short getVolumeNumber() {
        return this.volumeNumber;
    }
}

