/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog;

import java.sql.SQLException;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;

public class Java5SystemProcedures {
    private static final int TOOL_NAME = 0;
    private static final int TOOL_CLASS_NAME = 1;
    private static final String CUSTOM_TOOL_CLASS_NAME = "customTool";
    private static final String[][] OPTIONAL_TOOLS = new String[][]{{"databaseMetaData", "org.apache.derby.impl.tools.optional.DBMDWrapper"}, {"foreignViews", "org.apache.derby.impl.tools.optional.ForeignDBViews"}, {"optimizerTracing", "org.apache.derby.impl.tools.optional.OptimizerTracer"}};

    public static void SYSCS_REGISTER_TOOL(String string, boolean bl, String ... stringArray) throws SQLException {
        try {
            CompilerContext compilerContext = (CompilerContext)ContextService.getContext("CompilerContext");
            ClassFactory classFactory = compilerContext.getClassFactory();
            String string2 = Java5SystemProcedures.findToolClassName(string, stringArray);
            OptionalTool optionalTool = null;
            try {
                optionalTool = (OptionalTool)classFactory.loadApplicationClass(string2).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw Java5SystemProcedures.wrap(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw Java5SystemProcedures.wrap(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw Java5SystemProcedures.wrap(illegalAccessException);
            }
            if (CUSTOM_TOOL_CLASS_NAME.equals(string)) {
                stringArray = Java5SystemProcedures.stripCustomClassName(stringArray);
            }
            if (bl) {
                optionalTool.loadTool(stringArray);
            } else {
                optionalTool.unloadTool(stringArray);
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    private static String findToolClassName(String string, String ... stringArray) throws StandardException {
        if (CUSTOM_TOOL_CLASS_NAME.equals(string)) {
            if (stringArray == null || stringArray.length == 0) {
                throw Java5SystemProcedures.badTool("null");
            }
            return stringArray[0];
        }
        for (String[] stringArray2 : OPTIONAL_TOOLS) {
            if (!stringArray2[0].equals(string)) continue;
            return stringArray2[1];
        }
        throw Java5SystemProcedures.badTool(string);
    }

    private static StandardException badTool(String string) {
        return StandardException.newException("X0Y88.S", string);
    }

    private static String[] stripCustomClassName(String ... stringArray) {
        int n = stringArray.length - 1;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i + 1];
        }
        return stringArray2;
    }

    private static StandardException wrap(Throwable throwable) {
        return StandardException.plainWrapException(throwable);
    }
}

