/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2Utils;
import uk.gov.nationalarchives.droid.command.ResultPrinter;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.archive.ArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.BZipIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class Bzip2ArchiveContentIdentifier
extends ArchiveContentIdentifier {
    private static final long SIZE = 12L;
    private static final long TIME = 13L;

    public Bzip2ArchiveContentIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1, Boolean webArchives) {
        super(binarySignatureIdentifier, containerSignatureDefinitions, path, slash, slash1, webArchives);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void identify(URI uri, IdentificationRequest request) throws CommandExecutionException {
        String newPath = "bzip2:" + this.slash1 + this.path + request.getFileName() + "!" + this.slash;
        this.slash1 = "";
        URI newUri = URI.create(BZip2Utils.getUncompressedFilename((String)uri.toString()));
        RequestIdentifier identifier = new RequestIdentifier(newUri);
        RequestMetaData metaData = new RequestMetaData(Long.valueOf(12L), Long.valueOf(13L), uri.getPath());
        BZipIdentificationRequest bzRequest = new BZipIdentificationRequest(metaData, identifier, this.tmpDir);
        BZip2CompressorInputStream bzipIn = null;
        try {
            bzipIn = new BZip2CompressorInputStream(request.getSourceInputStream());
            bzRequest.open((InputStream)bzipIn);
            IdentificationResultCollection bzResults = this.binarySignatureIdentifier.matchBinarySignatures((IdentificationRequest)bzRequest);
            ResultPrinter resultPrinter = new ResultPrinter(this.binarySignatureIdentifier, this.containerSignatureDefinitions, newPath, this.slash, this.slash1, true, super.getExpandWebArchives());
            resultPrinter.print(bzResults, (IdentificationRequest)bzRequest);
        }
        catch (IOException ioe) {
            System.err.println(ioe + " (" + newPath + ")");
        }
        finally {
            if (bzipIn != null) {
                try {
                    bzipIn.close();
                }
                catch (IOException ioe) {
                    throw new CommandExecutionException(ioe.getMessage(), ioe);
                }
            }
            if (bzRequest != null) {
                try {
                    bzRequest.close();
                }
                catch (IOException ioe) {
                    throw new CommandExecutionException(ioe.getMessage(), ioe);
                }
            }
        }
    }
}

