/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.converter;

import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.out.Logger;
import ch.snb.pdfgenerator.SNBPDFGenerator;
import ch.snb.pdfgenerator.SNBPDFGeneratorSoap;
import com.kerb4j.client.SpnegoClient;
import com.kerb4j.client.SpnegoContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.util.Properties;
import javax.xml.ws.BindingProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.ietf.jgss.GSSException;

public abstract class SNBPDFConverter {
    private static final String DefaultServiceURLString = "https://bonnb3.snb.ch/SNBPDFGenerator.asmx";
    private static final String ServicePropertyKey = "snbpdfgenerator.propertiesFile";
    private static final String DefaultServicePropertyFilepath = "config/snbpdfgenerator.properties";
    private static SNBPDFGenerator Generator;
    private static SNBPDFGeneratorSoap GeneratorSoap;
    private static String ServicePropertyFilepath;
    private static String ServiceURLString;
    private static String Username;
    private static String Password;

    public static void main(String ... args) throws FileNotFoundException, MalformedURLException, IOException, PrivilegedActionException, GSSException {
        File servicePropertyFile;
        if (args.length != 2 && args.length != 5) {
            Logger.error((Object)"Wrong number of arguments.");
            Logger.error((Object)"Usage: SNBPDFGenerator [path/to/]sourceFile [path/to/]destinationFile [pdfSettings securitySettings fileTypeSettings]");
            return;
        }
        if (System.getProperty(ServicePropertyKey) != null && !"".equals(System.getProperty(ServicePropertyKey))) {
            ServicePropertyFilepath = System.getProperty(ServicePropertyKey);
        }
        if ((servicePropertyFile = new File(ServicePropertyFilepath)).exists() && servicePropertyFile.isFile() && servicePropertyFile.canRead()) {
            Logger.debug((Object)("loading configuration from: " + ServicePropertyFilepath));
            Properties serviceProperties = new Properties();
            serviceProperties.load(new FileInputStream(servicePropertyFile));
            SNBPDFConverter.initialize(serviceProperties);
        } else {
            Logger.warn((Object)("skipping value '" + ServicePropertyFilepath + "' from property '" + ServicePropertyFilepath + "' because not readable"));
        }
        if (args.length == 2) {
            SNBPDFConverter.convert2PDF(args[0], args[1], "", "", "");
        } else if (args.length == 5) {
            SNBPDFConverter.convert2PDF(args[0], args[1], args[2], args[3], args[4]);
        }
    }

    public static void initialize(Properties serviceProperties) {
        if (serviceProperties.containsKey("snbpdfgenerator.url")) {
            ServiceURLString = serviceProperties.getProperty("snbpdfgenerator.url");
            Logger.debug((Object)("Setting service URL to: " + ServiceURLString));
        }
        if (serviceProperties.containsKey("snbpdfgenerator.username")) {
            Username = serviceProperties.getProperty("snbpdfgenerator.username");
            Logger.debug((Object)("Setting service user to: " + Username));
        }
        if (serviceProperties.containsKey("snbpdfgenerator.password")) {
            Password = serviceProperties.getProperty("snbpdfgenerator.password");
        }
    }

    public static void initialize(String url) {
        ServiceURLString = url;
    }

    public static void convert2PDF(String sourceFilePath, String destinationFilePath) throws FileNotFoundException, MalformedURLException, IOException, PrivilegedActionException, GSSException {
        SNBPDFConverter.convert2PDF(sourceFilePath, destinationFilePath, "", "", "");
    }

    public static void convert2PDF(String sourceFilePath, String destinationFilePath, String pdfSettings, String securitySettings, String fileTypeSettings) throws FileNotFoundException, MalformedURLException, IOException, PrivilegedActionException, GSSException {
        SNBPDFConverter.initializeIfNecessary();
        if (Generator == null) {
            Logger.error((Object)"PDF generator can not be initialized");
            return;
        }
        Logger.info((Object)("Converting: '" + sourceFilePath + "' to: '" + destinationFilePath + "'"));
        FileInputStream fisSource = new FileInputStream(sourceFilePath);
        Logger.debug((Object)("Parameters:\tFileType = " + FileUtil.asFileNameExtension((String)sourceFilePath) + ", pdfSettings = " + pdfSettings + ", securitySettings = " + securitySettings + ", fileTypeSettings = " + fileTypeSettings));
        byte[] output = GeneratorSoap.createPdfUsingCustomSettings(IOUtils.toByteArray((InputStream)fisSource), FileUtil.asFileNameExtension((String)sourceFilePath), pdfSettings, securitySettings, fileTypeSettings);
        Logger.debug((Object)("Output length: " + output.length));
        fisSource.close();
        FileUtils.writeByteArrayToFile((File)new File(destinationFilePath), (byte[])output);
    }

    private static void initializeIfNecessary() throws MalformedURLException, PrivilegedActionException, GSSException {
        if (Generator != null) {
            return;
        }
        Logger.debug((Object)("Initializing service at: '" + ServiceURLString + "'"));
        URL serviceURL = new URL(ServiceURLString);
        Generator = new SNBPDFGenerator();
        GeneratorSoap = (SNBPDFGeneratorSoap)Generator.getPort(SNBPDFGeneratorSoap.class);
        BindingProvider bindingProvider = (BindingProvider)GeneratorSoap;
        bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", ServiceURLString);
        SpnegoClient spnegoClient = SpnegoClient.loginWithUsernamePassword((String)Username, (String)Password);
        SpnegoContext context = spnegoClient.createContext(serviceURL);
        Client client = ClientProxy.getClient((Object)bindingProvider);
        HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
        AuthorizationPolicy authorization = new AuthorizationPolicy();
        authorization.setAuthorization(context.createTokenAsAuthroizationHeader());
        httpConduit.setAuthorization(authorization);
        byte[] testPdfCreation = GeneratorSoap.testPdfCreation();
        Logger.debug((Object)("Running test pdf creation, returing " + testPdfCreation.length + " Bytes"));
    }

    static {
        ServicePropertyFilepath = DefaultServicePropertyFilepath;
        ServiceURLString = DefaultServiceURLString;
        Username = "";
        Password = "";
    }
}

