/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class QCCMarkerSegment
extends MarkerSegment {
    protected boolean process(int n) throws IOException {
        int[] nArray;
        int n2;
        int n3;
        int n4 = this.nCompBytes();
        if (n4 == 0) {
            this._repInfo.setMessage((Message)new ErrorMessage("QCC marker segment at wrong position in codestream"));
            return false;
        }
        if (n4 < 257) {
            n3 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
            n2 = 1;
        } else {
            n3 = this._module.readUnsignedShort(this._dstream);
            n2 = 2;
        }
        int n5 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        ++n2;
        int n6 = n5 & 0x1F;
        switch (n6) {
            case 0: {
                int n7;
                int n8 = n - n2;
                nArray = new int[n8];
                for (n7 = 0; n7 < n8; ++n7) {
                    nArray[n7] = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
                }
                break;
            }
            case 1: 
            case 2: {
                int n7;
                int n9 = (n - n2) / 2;
                nArray = new int[n9];
                for (n7 = 0; n7 < n9; ++n7) {
                    nArray[n7] = this._module.readUnsignedShort(this._dstream);
                }
                break;
            }
            default: {
                this._repInfo.setMessage((Message)new ErrorMessage("Unrecognized quantization type in QCC marker segment"));
                return false;
            }
        }
        MainOrTile mainOrTile = this.getMainOrTile();
        ArrayList<Property> arrayList = new ArrayList<Property>(2);
        arrayList.add(new Property("QuantizationStyle", PropertyType.INTEGER, (Object)new Integer(n5)));
        arrayList.add(new Property("StepValue", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)nArray));
        mainOrTile.setCompProperty(n3, new Property("QuantizationComponent", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }
}

