/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfIndirectObj;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import java.io.IOException;

public abstract class DocNode {
    protected PdfModule _module;
    protected PageTreeNode _parent;
    protected PdfDictionary _dict;
    protected boolean _pageObjectFlag;
    protected boolean _walkFinished;

    public DocNode(PdfModule pdfModule, PageTreeNode pageTreeNode, PdfDictionary pdfDictionary) {
        this._module = pdfModule;
        this._parent = pageTreeNode;
        this._dict = pdfDictionary;
        PdfIndirectObj pdfIndirectObj = (PdfIndirectObj)this._dict.get("Parent");
    }

    public boolean isPageObject() {
        return this._pageObjectFlag;
    }

    public abstract void startWalk();

    public abstract PageObject nextPageObject();

    public abstract DocNode nextDocNode();

    public DocNode getParent() {
        return this._parent;
    }

    public PdfDictionary getDict() {
        return this._dict;
    }

    public PdfDictionary getResources() throws PdfException {
        String string = "Invalid Resources Entry in document";
        if (this._dict == null) {
            throw new PdfMalformedException("Missing dictionary in document node");
        }
        try {
            PdfObject pdfObject = this._dict.get("Resources");
            pdfObject = this._module.resolveIndirectObject(pdfObject);
            return (PdfDictionary)pdfObject;
        }
        catch (ClassCastException classCastException) {
            throw new PdfInvalidException(string);
        }
        catch (IOException iOException) {
            throw new PdfInvalidException(string);
        }
    }

    public PdfDictionary getFontResources() throws PdfException {
        PdfDictionary pdfDictionary = this.getResources();
        if (pdfDictionary != null) {
            try {
                PdfObject pdfObject = pdfDictionary.get("Font");
                pdfObject = this._module.resolveIndirectObject(pdfObject);
                return (PdfDictionary)pdfObject;
            }
            catch (Exception exception) {
                throw new PdfMalformedException("Invalid Font entry in Resources");
            }
        }
        return null;
    }

    public PdfArray getMediaBox() throws PdfInvalidException {
        try {
            PdfArray pdfArray = (PdfArray)this.get("MediaBox", true);
            if (pdfArray.toRectangle() != null) {
                return pdfArray;
            }
            throw new PdfInvalidException("Malformed MediaBox in page tree");
        }
        catch (Exception exception) {
            throw new PdfInvalidException("Malformed MediaBox in page tree");
        }
    }

    public PdfObject get(String string, boolean bl) {
        PdfObject pdfObject = this._dict.get(string);
        if (pdfObject == null) {
            if (this._parent == null || !bl) {
                return null;
            }
            return this._parent.get(string, bl);
        }
        return pdfObject;
    }
}

