/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.gzip;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.ISO8859_1;
import org.jwat.gzip.GzipConstants;
import org.jwat.gzip.GzipEntry;
import org.jwat.gzip.GzipExtraData;

public class GzipWriter
implements Closeable {
    public static final int DEFAULT_INPUT_BUFFER_SIZE = 8192;
    protected OutputStream out;
    protected Deflater def = new Deflater(-1, true);
    protected CRC32 crc = new CRC32();
    protected byte[] inputBytes;
    protected int compressionLevel = -1;
    protected final ISO8859_1 iso8859_1 = new ISO8859_1();
    protected boolean bIsCompliant = true;
    protected GzipEntry gzipEntry;
    byte[] headerBytes = new byte[10];
    byte[] xlenBytes = new byte[2];
    byte[] fnameBytes = null;
    byte[] fcommentBytes = null;
    byte[] crc16Bytes = new byte[2];
    byte[] trailerBytes = new byte[8];

    public GzipWriter(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("out is null!");
        }
        this.out = new BufferedOutputStream(out, 8192);
        this.inputBytes = new byte[8192];
    }

    public GzipWriter(OutputStream out, int buffer_size) {
        if (out == null) {
            throw new IllegalArgumentException("out is null!");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("buffer_size is less or equals to zero!");
        }
        this.out = new BufferedOutputStream(out, buffer_size);
        this.inputBytes = new byte[buffer_size];
    }

    @Override
    public void close() throws IOException {
        if (this.gzipEntry != null) {
            this.gzipEntry.close();
            this.gzipEntry = null;
        }
        if (this.out != null) {
            this.out.flush();
            this.out = null;
        }
        if (this.def != null) {
            this.def.end();
            this.def = null;
        }
    }

    public boolean isCompliant() {
        return this.bIsCompliant;
    }

    public void setCompressionLevel(int compressionLevel) {
        if (compressionLevel != -1 && compressionLevel != 0 && (compressionLevel < 1 || compressionLevel > 9)) {
            throw new IllegalArgumentException("Invalid compression level: " + compressionLevel);
        }
        this.compressionLevel = compressionLevel;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void writeEntryHeader(GzipEntry entry) throws IOException {
        if (this.gzipEntry != null) {
            this.gzipEntry.close();
            this.gzipEntry = null;
        }
        if (entry == null) {
            throw new IllegalArgumentException("entry is null!");
        }
        this.crc.reset();
        this.def.reset();
        this.def.setLevel(this.compressionLevel);
        this.gzipEntry = entry;
        entry.magic = 35615;
        if (entry.date != null) {
            entry.mtime = entry.date.getTime() / 1000L;
        } else if (entry.mtime != 0L) {
            entry.date = new Date(entry.mtime * 1000L);
        }
        entry.xfl = 0;
        if (this.compressionLevel == 1) {
            entry.xfl = (short)(entry.xfl | 4);
        } else if (this.compressionLevel == 9) {
            entry.xfl = (short)(entry.xfl | 2);
        }
        entry.flg = 0;
        if (!GzipConstants.osIdxStr.containsKey(entry.os)) {
            entry.diagnostics.addWarning((Object)new Diagnosis(DiagnosisType.UNKNOWN, "Operating System", new String[]{Integer.toString(entry.os)}));
        }
        if (entry.bFText) {
            entry.flg = (short)(entry.flg | 1);
        }
        if (entry.extraBytes == null) {
            if (entry.extraData.size() > 0) {
                int xlen = 0;
                for (int i = 0; i < entry.extraData.size(); ++i) {
                    xlen += 4 + entry.extraData.get((int)i).data.length;
                }
                entry.extraBytes = new byte[xlen];
                int idx = 0;
                for (int i = 0; i < entry.extraData.size(); ++i) {
                    GzipExtraData extraData = entry.extraData.get(i);
                    entry.extraBytes[idx++] = extraData.si1;
                    entry.extraBytes[idx++] = extraData.si2;
                    entry.extraBytes[idx++] = (byte)(extraData.data.length & 0xFF);
                    entry.extraBytes[idx++] = (byte)(extraData.data.length >> 8 & 0xFF);
                    System.arraycopy(extraData.data, 0, entry.extraBytes, idx, extraData.data.length);
                    idx += extraData.data.length;
                }
            }
        } else {
            int idx = 0;
            boolean b = true;
            while (b) {
                if (idx <= entry.extraBytes.length - 4) {
                    int len;
                    idx += 2;
                    if ((idx += 2) + (len = (entry.extraBytes[idx + 1] & 0xFF) << 8 | entry.extraBytes[idx] & 0xFF) <= entry.extraBytes.length) {
                        idx += len;
                        continue;
                    }
                    b = false;
                    continue;
                }
                b = false;
            }
            if (idx != this.gzipEntry.extraBytes.length) {
                this.gzipEntry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_DATA, "FEXTRA", new String[]{"Invalid structure", "Data truncated"}));
            }
        }
        if (entry.extraBytes != null) {
            entry.flg = (short)(entry.flg | 4);
            entry.xlen = entry.extraBytes.length;
            this.xlenBytes[0] = (byte)(entry.xlen & 0xFF);
            this.xlenBytes[1] = (byte)(entry.xlen >> 8 & 0xFF);
        }
        if (entry.fname != null) {
            entry.flg = (short)(entry.flg | 8);
            if (!this.iso8859_1.encode(entry.fname, "")) {
                entry.diagnostics.addWarning((Object)new Diagnosis(DiagnosisType.INVALID_ENCODING, "FName", new String[]{entry.fname, "ISO-8859-1"}));
            }
            entry.fname = this.iso8859_1.decoded;
            this.fnameBytes = this.iso8859_1.encoded;
        }
        if (entry.fcomment != null) {
            entry.flg = (short)(entry.flg | 0x10);
            if (!this.iso8859_1.encode(entry.fcomment, "\n")) {
                entry.diagnostics.addWarning((Object)new Diagnosis(DiagnosisType.INVALID_ENCODING, "FComment", new String[]{entry.fcomment, "ISO-8859-1"}));
            }
            entry.fcomment = this.iso8859_1.decoded;
            this.fcommentBytes = this.iso8859_1.encoded;
        }
        if (entry.bFhCrc) {
            entry.flg = (short)(entry.flg | 2);
        }
        this.headerBytes[0] = (byte)(entry.magic & 0xFF);
        this.headerBytes[1] = (byte)(entry.magic >> 8 & 0xFF);
        this.headerBytes[2] = (byte)entry.cm;
        this.headerBytes[3] = (byte)entry.flg;
        this.headerBytes[4] = (byte)(entry.mtime & 0xFFL);
        this.headerBytes[5] = (byte)(entry.mtime >> 8 & 0xFFL);
        this.headerBytes[6] = (byte)(entry.mtime >> 16 & 0xFFL);
        this.headerBytes[7] = (byte)(entry.mtime >> 24 & 0xFFL);
        this.headerBytes[8] = (byte)entry.xfl;
        this.headerBytes[9] = (byte)entry.os;
        this.out.write(this.headerBytes);
        this.crc.update(this.headerBytes);
        if ((entry.flg & 4) == 4) {
            this.out.write(this.xlenBytes);
            this.out.write(entry.extraBytes);
            this.crc.update(this.xlenBytes);
            this.crc.update(entry.extraBytes);
        }
        if ((entry.flg & 8) == 8) {
            this.out.write(this.fnameBytes);
            this.out.write(0);
            this.crc.update(this.fnameBytes);
            this.crc.update(0);
        }
        if ((entry.flg & 0x10) == 16) {
            this.out.write(this.fcommentBytes);
            this.out.write(0);
            this.crc.update(this.fcommentBytes);
            this.crc.update(0);
        }
        if ((entry.flg & 2) == 2) {
            entry.comp_crc16 = (int)this.crc.getValue() & 0xFFFF;
            entry.crc16 = entry.comp_crc16;
            this.crc16Bytes[0] = (byte)(entry.crc16 & 0xFF);
            this.crc16Bytes[1] = (byte)(entry.crc16 >> 8 & 0xFF);
            this.out.write(this.crc16Bytes);
        }
        this.crc.reset();
        entry.isize = 0;
        entry.writer = this;
        entry.bEof = false;
        entry.out = new GzipEntryOutputStream(this, this.gzipEntry);
        entry.bIsCompliant = !entry.diagnostics.hasErrors() && !entry.diagnostics.hasWarnings();
        this.bIsCompliant &= entry.bIsCompliant;
    }

    protected void writeTrailer(GzipEntry entry) throws IOException {
        entry.bIsCompliant = !entry.diagnostics.hasErrors() && !entry.diagnostics.hasWarnings();
        this.bIsCompliant &= this.gzipEntry.bIsCompliant;
        entry.uncompressed_size = this.def.getBytesRead();
        entry.compressed_size = this.def.getBytesWritten();
        entry.crc32 = entry.comp_crc32 = (int)(this.crc.getValue() & 0xFFFFFFFFFFFFFFFFL);
        entry.isize = entry.comp_isize = (int)(this.def.getBytesRead() & 0xFFFFFFFFFFFFFFFFL);
        this.trailerBytes[0] = (byte)(entry.crc32 & 0xFF);
        this.trailerBytes[1] = (byte)(entry.crc32 >> 8 & 0xFF);
        this.trailerBytes[2] = (byte)(entry.crc32 >> 16 & 0xFF);
        this.trailerBytes[3] = (byte)(entry.crc32 >> 24 & 0xFF);
        this.trailerBytes[4] = (byte)(entry.isize & 0xFF);
        this.trailerBytes[5] = (byte)(entry.isize >> 8 & 0xFF);
        this.trailerBytes[6] = (byte)(entry.isize >> 16 & 0xFF);
        this.trailerBytes[7] = (byte)(entry.isize >> 24 & 0xFF);
        this.out.write(this.trailerBytes);
        this.out.flush();
    }

    protected int readCompressed(InputStream in, byte[] b, int off, int len) throws DataFormatException, IOException {
        int deflated = 0;
        while ((deflated = this.def.deflate(b, off, len)) == 0) {
            if (this.def.finished()) {
                return -1;
            }
            if (this.def.needsInput()) {
                int read = in.read(this.inputBytes, 0, this.inputBytes.length);
                if (read != -1) {
                    this.def.setInput(this.inputBytes, 0, read);
                    this.crc.update(this.inputBytes, 0, read);
                    continue;
                }
                this.def.finish();
                continue;
            }
            throw new DataFormatException("Deflater malfunction!");
        }
        return deflated;
    }

    protected int readCompressed(ByteBuffer bb, byte[] b, int off, int len, boolean bFinish) throws DataFormatException, IOException {
        int deflated = 0;
        while ((deflated = this.def.deflate(b, off, len)) == 0) {
            if (this.def.finished()) {
                return -1;
            }
            if (this.def.needsInput()) {
                int write = bb.remaining();
                if (write > 0) {
                    if (write > this.inputBytes.length) {
                        write = this.inputBytes.length;
                    }
                    bb.get(this.inputBytes, 0, write);
                    this.def.setInput(this.inputBytes, 0, write);
                    this.crc.update(this.inputBytes, 0, write);
                    continue;
                }
                if (bFinish) {
                    this.def.finish();
                    continue;
                }
                return 0;
            }
            throw new DataFormatException("Deflater malfunction!");
        }
        return deflated;
    }

    protected static class GzipEntryOutputStream
    extends OutputStream {
        GzipWriter writer;
        GzipEntry gzipEntry;
        boolean bEof = false;
        byte[] singleByteArray = new byte[1];
        ByteBuffer bb = ByteBuffer.allocate(8192);
        byte[] compressedBytes = new byte[8192];

        public GzipEntryOutputStream(GzipWriter writer, GzipEntry gzipEntry) {
            this.writer = writer;
            this.gzipEntry = gzipEntry;
        }

        @Override
        public void close() throws IOException {
            if (!this.bEof) {
                this.bEof = true;
                try {
                    int deflated = 0;
                    while (deflated != -1) {
                        this.bb.flip();
                        deflated = this.writer.readCompressed(this.bb, this.compressedBytes, 0, this.compressedBytes.length, true);
                        this.bb.compact();
                        if (deflated <= 0) continue;
                        this.writer.out.write(this.compressedBytes, 0, deflated);
                    }
                    this.writer.writeTrailer(this.gzipEntry);
                }
                catch (DataFormatException e) {
                    throw new IOException("Deflater malfunction!", e);
                }
                finally {
                    this.writer = null;
                    this.gzipEntry = null;
                    this.singleByteArray = null;
                }
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
            this.singleByteArray[0] = (byte)b;
            this.write(this.singleByteArray, 0, 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                while (len > 0) {
                    if (this.bb.remaining() > 0) {
                        int pLen = Math.min(this.bb.remaining(), len);
                        this.bb.put(b, off, pLen);
                        off += pLen;
                        len -= pLen;
                        continue;
                    }
                    this.bb.flip();
                    int compressed = this.writer.readCompressed(this.bb, this.compressedBytes, 0, this.compressedBytes.length, false);
                    this.bb.compact();
                    if (compressed <= 0) continue;
                    this.writer.out.write(this.compressedBytes, 0, compressed);
                }
            }
            catch (DataFormatException e) {
                throw new IOException("Deflater malfunction!", e);
            }
        }
    }
}

