/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import bsh.EvalError;
import ch.docuteam.darc.exceptions.MetadataElementAllowedValuesException;
import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionClassNotFoundException;
import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.exceptions.MetadataElementValidatorClassNotFoundException;
import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.CSVMetadataValue;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mdconfig.MetadataElementSetterPostAction;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mdconfig.RDFMetadataValue;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.util.KeyAndValue;
import ch.docuteam.darc.util.RDF_SKOS_Reader;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.StringUtil;
import ch.docuteam.tools.string.ToolTipText;
import ch.docuteam.tools.translations.I18N;
import ch.docuteam.tools.util.JavaInterpreter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MetadataElement
implements ToolTipText {
    private static Map<String, MetadataElement> ALL = new LinkedHashMap<String, MetadataElement>(71);
    public static final int NUMBER_OF_METADATA_ELEMENTS = 139;
    private String accessorName;
    private Method setterMethod;
    private Method getterMethod;
    private List<ValidatorInstance> validatorInstances = new ArrayList<ValidatorInstance>();
    private List<PostActionInstance> postActionInstances = new ArrayList<PostActionInstance>();
    private String defaultExpression;
    private String toolTipText;
    private String allowedValuesType = VALUE_TYPE.stringList.name();
    private List<KeyAndValue> allowedValues;
    private List<RDFMetadataValue> rdfAllowedValues;
    private List<CSVMetadataValue> csvAllowedValues;

    MetadataElement(Class<?> targetClass, String accessorName, String validatorAttribute, String postActionAttribute, String defaultExpression, String allowedValues, String allowedValuesType) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        this.accessorName = accessorName;
        String accessorNameCapitalized = StringUtil.first((String)accessorName, (Integer)1).toUpperCase() + accessorName.substring(1);
        this.getterMethod = targetClass.getMethod("get" + accessorNameCapitalized, new Class[0]);
        this.setterMethod = targetClass.getMethod("set" + accessorNameCapitalized, List.class);
        if (validatorAttribute != null) {
            String[] validatorClassNames;
            for (String validatorClassName : validatorClassNames = validatorAttribute.trim().split(LevelOfDescription.getAllowedValuesSeparator())) {
                try {
                    this.validatorInstances.add(new ValidatorInstance(validatorClassName));
                }
                catch (ClassNotFoundException ex) {
                    ch.docuteam.tools.exception.Exception.remember((Throwable)new MetadataElementValidatorClassNotFoundException(this.accessorName, ex));
                }
            }
        }
        if (postActionAttribute != null) {
            String[] postActionClassNames;
            for (String postActionClassName : postActionClassNames = postActionAttribute.trim().split(LevelOfDescription.getAllowedValuesSeparator())) {
                try {
                    this.postActionInstances.add(new PostActionInstance(postActionClassName));
                }
                catch (ClassNotFoundException ex) {
                    ch.docuteam.tools.exception.Exception.remember((Throwable)new MetadataElementSetterPostActionClassNotFoundException(this.accessorName, ex));
                }
            }
        }
        this.defaultExpression = defaultExpression;
        if (allowedValuesType != null) {
            this.allowedValuesType = allowedValuesType;
        }
        this.initializeAllowedValues(allowedValues);
        try {
            this.toolTipText = I18N.translate((String)(this.accessorName + "ToolTip"));
            if (this.toolTipText.isEmpty()) {
                this.toolTipText = I18N.translate((String)this.accessorName);
            }
        }
        catch (Exception ex) {
            this.toolTipText = this.accessorName;
        }
        ALL.put(accessorName, this);
        Logger.debug((Object)("Created: " + this));
    }

    private void initializeAllowedValues(String value) {
        if (value == null) {
            this.allowedValues = new ArrayList<KeyAndValue>();
        } else if (this.isValueTypeRDFAndNotNull(value)) {
            this.rdfAllowedValues = this.getRDFAllowedValues(value);
        } else if (this.isValueTypeCSVAndNotNull(value)) {
            this.csvAllowedValues = this.getCSVAllowedValues(value);
        } else {
            this.allowedValues = new ArrayList<KeyAndValue>(StringUtil.occurrencesOf((String)LevelOfDescription.getAllowedValuesSeparator(), (String)value) + 1);
            for (String s : value.split(LevelOfDescription.getAllowedValuesSeparator())) {
                this.allowedValues.add(new KeyAndValue(s.trim()));
            }
        }
    }

    boolean isValueTypeRDFAndNotNull(String value) {
        return value != null && VALUE_TYPE.skosFile.equals((Object)this.getValueType());
    }

    boolean isValueTypeCSVAndNotNull(String value) {
        return value != null && VALUE_TYPE.csvFile.equals((Object)this.getValueType());
    }

    public VALUE_TYPE getValueType() {
        try {
            return VALUE_TYPE.valueOf(this.allowedValuesType);
        }
        catch (IllegalArgumentException e) {
            Logger.warn((Object)("allowedValuesType cannot be parsed into a VALUE_TYPE: " + this.allowedValuesType));
            return VALUE_TYPE.stringList;
        }
    }

    private List<RDFMetadataValue> getRDFAllowedValues(String allowedValuesDocumentURL) {
        return RDF_SKOS_Reader.getRDFReader().getAllowedValuesList(allowedValuesDocumentURL);
    }

    private List<CSVMetadataValue> getCSVAllowedValues(String allowedValuesDocumentURL) {
        return CSVMetadataValue.getAllowedValuesList(allowedValuesDocumentURL);
    }

    String getCSVLabel(String valueKey) {
        if (this.csvAllowedValues != null) {
            for (CSVMetadataValue csvValue : this.csvAllowedValues) {
                if (!csvValue.getKey().equals(valueKey)) continue;
                return csvValue.getLabel(Locale.getDefault().getLanguage());
            }
        }
        return "";
    }

    public static void clear() {
        ALL.clear();
    }

    public static MetadataElement get(String accessorName) {
        MetadataElement.initializeIfNecessary();
        return ALL.get(accessorName);
    }

    public static Map<String, MetadataElement> getAll() {
        MetadataElement.initializeIfNecessary();
        return ALL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeIfNecessary() {
        Map<String, MetadataElement> map = ALL;
        synchronized (map) {
            if (ALL.isEmpty()) {
                LevelOfDescription.initializeIfNecessary();
            }
        }
    }

    public String getId() {
        return this.accessorName;
    }

    public String getAccessorName() {
        return this.accessorName;
    }

    public List<KeyAndValue> getAllowedValues() {
        return this.allowedValues;
    }

    public List<RDFMetadataValue> getRdfAllowedValues() {
        return this.rdfAllowedValues;
    }

    public List<CSVMetadataValue> getCsvAllowedValues() {
        return this.csvAllowedValues;
    }

    public boolean isPostActionDefined() {
        return this.postActionInstances.size() > 0;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public List<String> getValueFromNode(NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        List value = (List)this.getterMethod.invoke((Object)node.getMyDMDSectionWithEAD().getC(), new Object[0]);
        return value;
    }

    public void setValueInNode(List<String> value, NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Logger.debug((Object)("Setting in:" + node + " metadata element:<" + this.accessorName + "> to:'" + value + "'"));
        this.setterMethod.invoke((Object)node.getMyDMDSectionWithEAD().getC(), value);
    }

    public void validateValueAgainstNode(String value, NodeAbstract node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementAllowedValuesException {
        Logger.debug((Object)("Validating in:" + node + " metadata element:<" + this.accessorName + "> value:'" + value + "'"));
        this.validateValueAgainstRDFAllowedValues(value);
        if (this.allowedValues != null && !this.allowedValues.isEmpty() && !this.allowedValues.get(0).getOriginalString().equals("*")) {
            boolean found = false;
            for (KeyAndValue knv : this.allowedValues) {
                if (!knv.getOriginalString().equals(value == null ? "" : value)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new MetadataElementAllowedValuesException(value, this);
            }
        }
        if (value == null) {
            return;
        }
        if (value.isEmpty()) {
            return;
        }
        if (this.validatorInstances.size() == 0) {
            return;
        }
        try {
            for (ValidatorInstance validatorInstance : this.validatorInstances) {
                validatorInstance.check(value, node, this);
            }
        }
        catch (InvocationTargetException ex) {
            if (MetadataElementValidatorException.class == ex.getTargetException().getClass()) {
                throw (MetadataElementValidatorException)ex.getTargetException();
            }
            throw ex;
        }
    }

    private void validateValueAgainstRDFAllowedValues(String value) throws MetadataElementAllowedValuesException {
        if (this.rdfAllowedValues != null && !this.rdfAllowedValues.isEmpty() && !this.isRDFValueAllowed(value)) {
            throw new MetadataElementAllowedValuesException(value, this);
        }
    }

    private boolean isRDFValueAllowed(String value) {
        if (value.isEmpty()) {
            return true;
        }
        for (RDFMetadataValue rdfValue : this.rdfAllowedValues) {
            if (!rdfValue.getSubjectURI().equals(value)) continue;
            return true;
        }
        return false;
    }

    String getRDFLabel(String subjectURI) {
        if (this.rdfAllowedValues != null) {
            for (RDFMetadataValue rdfValue : this.rdfAllowedValues) {
                if (!rdfValue.getSubjectURI().equals(subjectURI)) continue;
                return rdfValue.getLabel();
            }
        }
        return "";
    }

    public void executePostActionInNode(String oldValue, String newValue, NodeAbstract node, int index) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementSetterPostActionException {
        if (this.postActionInstances.size() == 0) {
            return;
        }
        Logger.debug((Object)("Executing post-action in:" + node + " metadata element:<" + this.accessorName + "> old value:'" + oldValue + "' newValue: '" + newValue + "'"));
        try {
            for (PostActionInstance postActionInstance : this.postActionInstances) {
                postActionInstance.execute(oldValue, newValue, node, this, index);
            }
        }
        catch (InvocationTargetException ex) {
            if (MetadataElementSetterPostActionException.class == ex.getTargetException().getClass()) {
                throw (MetadataElementSetterPostActionException)ex.getTargetException();
            }
            throw ex;
        }
    }

    public String getDefaultValueFromNode(NodeAbstract node) throws EvalError, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementAllowedValuesException {
        if (this.defaultExpression == null) {
            return null;
        }
        Logger.debug((Object)("Getting default value in:" + node + " metadata element:<" + this.accessorName + "> expression:'" + this.defaultExpression + "'"));
        Object result = JavaInterpreter.execute((String)this.defaultExpression, (Object[])new Object[]{node, this});
        if (result != null) {
            this.validateValueAgainstNode(result.toString(), node);
        }
        return result == null ? null : result.toString();
    }

    public String toString() {
        return "[MetadataElement:" + this.accessorName + "]";
    }

    private class PostActionInstance {
        private MetadataElementSetterPostAction postActionInstance;
        private Method method;

        public PostActionInstance(String postActionClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException {
            Class<?> postActionClass = Class.forName(postActionClassName);
            this.postActionInstance = (MetadataElementSetterPostAction)postActionClass.newInstance();
            this.method = postActionClass.getMethod("execute", String.class, String.class, NodeAbstract.class, MetadataElement.class, Integer.TYPE);
        }

        public void execute(String oldValue, String newValue, NodeAbstract node, MetadataElement element, int index) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.method.invoke((Object)this.postActionInstance, oldValue, newValue, node, element, index);
        }
    }

    private class ValidatorInstance {
        private MetadataElementValidator validatorInstance;
        private Method method;

        public ValidatorInstance(String validatorClassName) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException {
            Class<?> validatorClass = Class.forName(validatorClassName.trim());
            this.validatorInstance = (MetadataElementValidator)validatorClass.newInstance();
            this.method = validatorClass.getMethod("check", String.class, NodeAbstract.class, MetadataElement.class);
        }

        public void check(String value, NodeAbstract node, MetadataElement element) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.method.invoke((Object)this.validatorInstance, value, node, element);
        }
    }

    public static enum VALUE_TYPE {
        stringList,
        skosFile,
        csvFile;

    }
}

