/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.dmdsec;

import ch.docuteam.darc.common.DocumentAbstract;
import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.dmdsec.DMDSectionGeneric;
import ch.docuteam.darc.mets.dmdsec.DMDSectionWithEAD;
import ch.docuteam.darc.mets.dmdsec.DMDSectionWithOAI_DC;
import ch.docuteam.tools.id.UniqueID;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class DMDSectionAbstract
extends NodeAbstract {
    public DMDSectionAbstract(DocumentAbstract document) {
        this.document = document;
        this.element = DocumentHelper.createElement((String)"METS:dmdSec");
        int amdSectionIndex = this.document.getRootElement().content().indexOf(((Document)this.document).getAMDSection().getElement());
        this.document.getRootElement().content().add(amdSectionIndex, this.element);
        this.setId(UniqueID.getXML());
        ((Document)this.document).addDMDSection(this);
    }

    protected DMDSectionAbstract(Document document, Element element) {
        this.document = document;
        this.element = element;
        this.id = this.element.attributeValue("ID");
    }

    public static Map<String, DMDSectionAbstract> parse(Document document) {
        HashMap<String, DMDSectionAbstract> dmdSecs = new HashMap<String, DMDSectionAbstract>();
        List dmdSecNodes = document.selectNodes("./METS:mets/METS:dmdSec");
        if (dmdSecNodes.size() == 0) {
            return dmdSecs;
        }
        for (Object o : dmdSecNodes) {
            DMDSectionAbstract dmdSection;
            Element element = (Element)o;
            if (element.selectSingleNode("./METS:mdWrap[@MDTYPE = 'EAD']") != null) {
                dmdSection = new DMDSectionWithEAD(document, element);
                dmdSecs.put(dmdSection.id, dmdSection);
                continue;
            }
            if (element.selectSingleNode("./METS:mdWrap[@MDTYPE = 'DC']") != null) {
                dmdSection = new DMDSectionWithOAI_DC(document, (Element)o);
                dmdSecs.put(((DMDSectionWithOAI_DC)dmdSection).id, dmdSection);
                continue;
            }
            dmdSection = new DMDSectionGeneric(document, (Element)o);
            dmdSecs.put(((DMDSectionGeneric)dmdSection).id, dmdSection);
        }
        return dmdSecs;
    }

    public void delete() {
        ((Document)this.document).deleteDMDSection(this);
        this.document.setIsModified();
        this.element.detach();
    }

    public String toString() {
        return "\n[DMDSection:" + this.id + "\n]";
    }
}

