/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.sa.archive;

import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.darc.sa.common.Contact;
import ch.docuteam.darc.sa.common.NodeAbstract;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class Archive
extends NodeAbstract {
    private String isil;
    private List<Contact> contacts;

    private Archive(SubmissionAgreement sa, Element element) {
        this.sa = sa;
        this.element = element;
        this.isil = this.element.attributeValue("isil");
        this.contacts = Contact.parse(this.sa, this.element);
    }

    public static Archive parse(SubmissionAgreement sa, Element parent) {
        return new Archive(sa, (Element)parent.selectSingleNode("./SA:archive"));
    }

    public String getIsil() {
        return this.isil;
    }

    public void setIsil(String isilValue) {
        this.isil = isilValue;
        Attribute attribute = this.element.attribute("isil");
        if (attribute != null) {
            this.element.remove(attribute);
            this.element.addAttribute("isil", isilValue);
        }
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[Archive:").append(this.isil);
        for (Contact c : this.contacts) {
            stringBuilder.append(c);
        }
        return stringBuilder.append("]").toString();
    }
}

