/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.sa.common;

import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.darc.sa.common.NodeAbstract;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class Contact
extends NodeAbstract {
    private String contactID;
    private String organisation;
    private String departement;
    private String shortName;
    private String person;
    private String phone;
    private String mail;

    private Contact(SubmissionAgreement sa, Element element) {
        this.sa = sa;
        this.element = element;
        this.contactID = element.attributeValue("contactID");
        this.organisation = this.getElementText("SA:organisation", true);
        this.departement = this.getElementText("SA:departement", true);
        this.shortName = this.getElementText("SA:shortname", true);
        this.person = this.getElementText("SA:person", false);
        this.phone = this.getElementText("SA:phone", false);
        this.mail = this.getElementText("SA:mail", false);
    }

    public static List<Contact> parse(SubmissionAgreement sa, Element parent) {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        for (Object o : parent.selectNodes("./SA:contact")) {
            contacts.add(new Contact(sa, (Element)o));
        }
        return contacts;
    }

    public String getContactID() {
        return this.contactID;
    }

    public String getPerson() {
        return this.person;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public String getDepartement() {
        return this.departement;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getMail() {
        return this.mail;
    }

    public String toString() {
        return "[Contact:" + (this.organisation + "/") + (this.departement + "/") + (this.shortName + "/") + (this.person + "/") + (this.phone + "/") + (this.mail + "]");
    }
}

