/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.sa.dss;

import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.darc.sa.common.NodeAbstract;
import ch.docuteam.tools.file.MetadataProviderDROID;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;

public class FileFormats
extends NodeAbstract {
    private boolean isStrict = true;
    private List<String> names = new ArrayList<String>();
    private List<String> puids = new ArrayList<String>();
    private List<String> mimeTypes = new ArrayList<String>();
    private List<String> extensions = new ArrayList<String>();

    private FileFormats(SubmissionAgreement sa, Element element) {
        this.sa = sa;
        this.element = element;
        String strict = element.attributeValue("strict");
        this.isStrict = strict == null || strict.isEmpty() ? true : new Boolean(strict);
        for (Object o : element.selectNodes("./SA:name")) {
            this.names.add(((Element)o).getText());
        }
        for (Object o : element.selectNodes("./SA:puid")) {
            this.puids.add(((Element)o).getText().toLowerCase());
        }
        for (Object o : element.selectNodes("./SA:mimetype")) {
            this.mimeTypes.add(((Element)o).getText().toLowerCase());
        }
        for (Object o : element.selectNodes("./SA:extension")) {
            this.extensions.add(((Element)o).getText().toLowerCase());
        }
    }

    static FileFormats parse(SubmissionAgreement sa, Element parent) {
        Element fileFormatsElement = (Element)parent.selectSingleNode("./SA:fileFormats");
        if (fileFormatsElement == null) {
            return null;
        }
        return new FileFormats(sa, fileFormatsElement);
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<String> getPuids() {
        return this.puids;
    }

    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public boolean allowsFile(String dssId, String filePath) throws FileNotFoundException {
        if (!new File(filePath).exists()) {
            throw new FileNotFoundException(filePath);
        }
        String puid = null;
        String mimeType = null;
        IdentificationResult identificationResult = null;
        try {
            identificationResult = MetadataProviderDROID.getIdentificationResult((String)filePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (identificationResult != null) {
            puid = identificationResult.getPuid();
            mimeType = identificationResult.getMimeType();
        }
        return this.allowsFileType(dssId, filePath, puid, mimeType);
    }

    public boolean allowsFileType(String dssID, String filePath, String puid, String mimeType) {
        String extension = filePath.substring(filePath.lastIndexOf(".") + 1);
        if (puid != null && !puid.isEmpty() && this.puids.contains(puid.toLowerCase()) || mimeType != null && !mimeType.isEmpty() && this.mimeTypes.contains(mimeType.toLowerCase()) || extension != null && !extension.isEmpty() && this.extensions.contains(extension.toLowerCase())) {
            return true;
        }
        if (this.isStrict) {
            Logger.debug((Object)("Submission Agreement '" + this.sa.getSaId() + "' Data Submission Session '" + dssID + "' doesn't allow file '" + filePath + "(" + puid + ":" + mimeType + ")'"));
            return false;
        }
        Logger.debug((Object)("Submission Agreement '" + this.sa.getSaId() + "' Data Submission Session '" + dssID + "' doesn't allow file '" + filePath + "(" + puid + ":" + mimeType + ")', but since it is not strict, let it pass."));
        return true;
    }

    public String toString() {
        return "[FileFormat:" + (this.isStrict + "/") + (this.names + "/") + (this.puids + "/") + (this.mimeTypes + "/") + (this.extensions + "]");
    }
}

