/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RAFInputStream
extends InputStream {
    private RandomAccessFile _raf;
    private int fileBufSize;
    private byte[] fileBuf;
    private int fileBufPos;
    private int fileBufBytes;
    private long fileOffset;
    boolean eof;

    public RAFInputStream(RandomAccessFile randomAccessFile) {
        this._raf = randomAccessFile;
        this.fileBufSize = 65536;
        this.init();
    }

    public RAFInputStream(RandomAccessFile randomAccessFile, int n) {
        this._raf = randomAccessFile;
        this.fileBufSize = n <= 0 ? 65536 : n;
        this.init();
    }

    private void init() {
        this.fileBufBytes = 0;
        this.fileBufPos = 0;
        this.fileBuf = new byte[this.fileBufSize];
        try {
            this.fileOffset = this._raf.getFilePointer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.eof = false;
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.fileBufPos >= this.fileBufBytes) {
            this._raf.seek(this.fileOffset);
            this.fileBufBytes = this._raf.read(this.fileBuf);
            this.fileBufPos = 0;
            if (this.fileBufBytes <= 0) {
                this.eof = true;
                return -1;
            }
            this.fileOffset += (long)this.fileBufBytes;
        }
        return this.fileBuf[this.fileBufPos++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        int n = byArray.length;
        int n2 = 0;
        do {
            int n3;
            if ((n3 = this.fileBufBytes - this.fileBufPos) <= 0) {
                this._raf.seek(this.fileOffset);
                this.fileBufBytes = this._raf.read(this.fileBuf);
                this.fileBufPos = 0;
                if (this.fileBufBytes <= 0) {
                    this.eof = true;
                    return n2;
                }
                n3 = this.fileBufBytes;
                this.fileOffset += (long)this.fileBufBytes;
            }
            if (n3 > n) {
                n3 = n;
            }
            for (int i = 0; i < n3; ++i) {
                byArray[n2++] = this.fileBuf[this.fileBufPos++];
                --n;
            }
        } while (n != 0);
        return n2;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        int n4 = 0;
        do {
            int n5;
            if ((n5 = this.fileBufBytes - this.fileBufPos) <= 0) {
                this._raf.seek(this.fileOffset);
                this.fileBufBytes = this._raf.read(this.fileBuf);
                this.fileBufPos = 0;
                if (this.fileBufBytes <= 0) {
                    this.eof = true;
                    return n4;
                }
                n5 = this.fileBufBytes;
                this.fileOffset += (long)this.fileBufBytes;
            }
            if (n5 > n3) {
                n5 = n3;
            }
            for (int i = 0; i < n5; ++i) {
                byArray[n + n4++] = this.fileBuf[this.fileBufPos++];
                --n3;
            }
        } while (n3 != 0);
        return n4;
    }

    public long skip(long l) throws IOException {
        int n = this.fileBufBytes - this.fileBufPos;
        if ((long)n > l) {
            this.fileBufPos += (int)l;
        } else {
            this.fileOffset = this.fileOffset + l - (long)n > this._raf.length() ? this._raf.length() : (this.fileOffset += l - (long)n);
            this.fileBufBytes = 0;
        }
        return l;
    }

    public RandomAccessFile getRAF() {
        return this._raf;
    }

    public void seek(long l) throws IOException {
        this._raf.seek(l);
        this.fileBufBytes = 0;
        this.fileBufPos = 0;
        this.eof = false;
    }

    public long getFilePos() throws IOException {
        return this._raf.getFilePointer() - (long)(this.fileBufBytes - this.fileBufPos);
    }
}

