/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.byteseek.io.reader.ReaderInputStream;
import net.byteseek.io.reader.WindowReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;

public class ISOImageIdentificationRequest
implements IdentificationRequest<InputStream> {
    private static final int TOP_TAIL_CAPACITY = 0x200000;
    private final Log log = LogFactory.getLog(this.getClass());
    private final String extension;
    private final String fileName;
    private final RequestMetaData requestMetaData;
    private final RequestIdentifier identifier;
    private final File tempDir;
    private final long size;
    private WindowReader reader;

    public ISOImageIdentificationRequest(RequestMetaData requestMetaData, RequestIdentifier identifier, File tempDir) {
        this.fileName = requestMetaData.getName();
        this.extension = ResourceUtils.getExtension(this.fileName);
        this.requestMetaData = requestMetaData;
        this.identifier = identifier;
        this.requestMetaData.getSize();
        this.tempDir = tempDir;
        this.size = requestMetaData.getSize();
        if (this.size < 0L) {
            throw new IllegalArgumentException("Size can't be bellow zero.");
        }
    }

    @Override
    public void open(InputStream in) throws IOException {
        this.reader = ResourceUtils.getStreamReader(in, this.tempDir, 0x200000, true);
        long readSize = this.reader.length();
        if (this.size != readSize) {
            this.log.warn((Object)("Rar element metadata size is not same as read size : " + readSize));
        }
    }

    @Override
    public byte getByte(long position) throws IOException {
        int result = this.reader.readByte(position);
        if (result < 0) {
            throw new IOException("No byte at position " + position);
        }
        return (byte)result;
    }

    @Override
    public WindowReader getWindowReader() {
        return this.reader;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        return new ReaderInputStream(this.reader, false);
    }

    @Override
    public RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    @Override
    public RequestIdentifier getIdentifier() {
        return this.identifier;
    }
}

