/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.dc;

import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.dc.OAI_DC;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class DC
extends NodeAbstract {
    private static final String DCNamespacePrefix = "DC";
    private static final String DCNamespaceURI = "http://purl.org/dc/elements/1.1/";
    private final String language;
    private final String text;

    private DC(OAI_DC parent, Element element, boolean move) {
        if (move) {
            element.detach();
            parent.getElement().add(element);
        }
        this.document = parent.getDocument();
        this.parent = parent;
        this.element = element;
        this.language = this.element.attributeValue("lang");
        this.text = this.element.getText();
        if (!this.element.getNamespacePrefix().equals(DCNamespacePrefix)) {
            this.element.setQName(new QName(this.element.getName(), new Namespace(DCNamespacePrefix, DCNamespaceURI)));
        }
    }

    static String getNamespacePrefix() {
        return DCNamespacePrefix;
    }

    static void parse(OAI_DC parent, Element element, boolean move) {
        for (Object o : element.selectNodes(".//DC:contributor")) {
            parent.getContributors().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:coverage")) {
            parent.getCoverages().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:creator")) {
            parent.getCreators().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:date")) {
            parent.getDates().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:description")) {
            parent.getDescriptions().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:format")) {
            parent.getFormats().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:identifier")) {
            parent.getIdentifiers().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:language")) {
            parent.getLanguages().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:publisher")) {
            parent.getPublishers().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:relation")) {
            parent.getRelations().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:rights")) {
            parent.getRights().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:source")) {
            parent.getSources().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:subject")) {
            parent.getSubjects().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:title")) {
            parent.getTitles().add(new DC(parent, (Element)o, move));
        }
        for (Object o : element.selectNodes(".//DC:type")) {
            parent.getTypes().add(new DC(parent, (Element)o, move));
        }
    }

    static void create(OAI_DC parent, Document oaiDcDocument) {
        String dcNamespacePrefixUsedInFile = oaiDcDocument.getRootElement().getNamespaceForURI(DCNamespaceURI).getPrefix();
        if (dcNamespacePrefixUsedInFile == null || dcNamespacePrefixUsedInFile.isEmpty()) {
            return;
        }
        if (oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":*").size() == 0) {
            return;
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":contributor")) {
            parent.getContributors().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":coverage")) {
            parent.getCoverages().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":creator")) {
            parent.getCreators().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":date")) {
            parent.getDates().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":description")) {
            parent.getDescriptions().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":format")) {
            parent.getFormats().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":identifier")) {
            parent.getIdentifiers().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":language")) {
            parent.getLanguages().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":publisher")) {
            parent.getPublishers().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":relation")) {
            parent.getRelations().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":rights")) {
            parent.getRights().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":source")) {
            parent.getSources().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":subject")) {
            parent.getSubjects().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":title")) {
            parent.getTitles().add(new DC(parent, (Element)o, true));
        }
        for (Object o : oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":type")) {
            parent.getTypes().add(new DC(parent, (Element)o, true));
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return "[DC:" + (this.language == null ? "" : this.language + "/") + this.text + "]";
    }
}

