/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.dmdsec;

import ch.docuteam.darc.ead.C;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.dmdsec.DMDSectionAbstract;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.exception.Exception;
import ch.docuteam.tools.file.FileUtil;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;

public class DMDSectionWithEAD
extends DMDSectionAbstract {
    private static final String EADNamespacePrefix = "EAD";
    private static final String EADNamespaceURI = "urn:isbn:1-931666-22-9";
    private C c;

    public DMDSectionWithEAD(NodeAbstract node) {
        super(node.getDocument());
        Element mdWrap = this.element.addElement("METS:mdWrap").addAttribute("MDTYPE", EADNamespacePrefix);
        Element xmlData = mdWrap.addElement("METS:xmlData");
        this.document.getRootElement().add(new Namespace(EADNamespacePrefix, EADNamespaceURI));
        Element dscElement = this.createIntermediaryArchdescElement(xmlData);
        this.c = new C(this, dscElement, node.isFile() ? FileUtil.asFileNameWithoutExtension((String)node.getLabel()) : node.getLabel());
    }

    protected DMDSectionWithEAD(Document document, Element element) {
        super(document, element);
        Element parentOfCElement;
        Element xmlDataElement = (Element)this.element.selectSingleNode("./METS:mdWrap/METS:xmlData");
        if (xmlDataElement.selectSingleNode("./EAD:ead") == null) {
            Element cElement = (Element)xmlDataElement.selectSingleNode("./EAD:c");
            if (cElement == null) {
                Exception.remember((String)("Mandatory EAD:c element missing in dmdSec in path: '" + xmlDataElement.getPath() + "'"));
                return;
            }
            Element dscElement = this.createIntermediaryArchdescElement((Element)this.element.selectSingleNode("./METS:mdWrap/METS:xmlData"));
            cElement.detach();
            dscElement.add(cElement);
        }
        if ((parentOfCElement = (Element)this.element.selectSingleNode("./METS:mdWrap/METS:xmlData/EAD:ead/EAD:archdesc/EAD:dsc")).selectSingleNode("./EAD:c") == null) {
            Exception.remember((String)("Mandatory EAD:c element missing in dmdSec in path: '" + parentOfCElement.getPath() + "'"));
            return;
        }
        this.c = C.parse(this, parentOfCElement, 0).get(0);
    }

    public C getC() {
        return this.c;
    }

    public Node getEADElement() {
        return this.getElement().selectSingleNode("METS:mdWrap/METS:xmlData/EAD:ead");
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("\n[DMDSection:" + this.id);
        buf.append("\n\t" + this.c);
        buf.append("\n]");
        return buf.toString();
    }

    private Element createIntermediaryArchdescElement(Element xmlDataElement) {
        Element eadElement = xmlDataElement.addElement("EAD:ead");
        Element eadHeader = eadElement.addElement("EAD:eadheader");
        eadHeader.addElement("EAD:eadid");
        eadHeader.addElement("EAD:filedesc").addElement("EAD:titlestmt").addElement("EAD:titleproper");
        Element archdescElement = eadElement.addElement("EAD:archdesc").addAttribute("level", "otherlevel");
        archdescElement.addElement("EAD:did").addElement("EAD:unittitle");
        return archdescElement.addElement("EAD:dsc");
    }
}

