/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.metshdr;

import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.amdsec.DigiprovWithPremis;
import ch.docuteam.darc.mets.metshdr.Agent;
import ch.docuteam.tools.id.UniqueID;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.DateFormatter;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Header
extends NodeAbstract {
    protected String createdDate;
    protected String recordStatus;
    protected String lastModificationDate;
    protected List<Agent> agents = new ArrayList<Agent>();
    protected String admId;

    protected Header() {
    }

    private Header(Document document) {
        this.document = document;
        this.element = (Element)this.document.selectSingleNode("./METS:mets/METS:metsHdr");
        if (this.element == null) {
            this.element = DocumentHelper.createElement((String)"METS:metsHdr");
            this.element.addAttribute("CREATEDATE", DateFormatter.getCurrentDateTimeString());
            this.element.addAttribute("LASTMODDATE", DateFormatter.getCurrentDateTimeString());
            this.element.addAttribute("RECORDSTATUS", "New");
            Element agent = DocumentHelper.createElement((String)"METS:agent");
            agent.addAttribute("ROLE", "CREATOR");
            agent.addAttribute("TYPE", "INDIVIDUAL");
            Element agentName = DocumentHelper.createElement((String)"METS:name");
            agentName.setText(OperatingSystem.userName());
            agent.add(agentName);
            this.element.add(agent);
            this.document.getRootElement().content().add(0, this.element);
        }
        this.createdDate = this.element.attributeValue("CREATEDATE");
        this.lastModificationDate = this.element.attributeValue("LASTMODDATE");
        this.recordStatus = this.element.attributeValue("RECORDSTATUS");
        this.admId = this.element.attributeValue("ADMID");
        this.agents.addAll(Agent.parse(this));
        this.getMyDigiprov();
    }

    public static Header parse(Document document) {
        return new Header(document);
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public String getRecordStatus() {
        return this.recordStatus;
    }

    public void setRecordStatus(String string) {
        this.recordStatus = string;
        this.element.addAttribute("RECORDSTATUS", string);
        this.document.setIsModified();
    }

    public String getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDateToNow() {
        this.setLastModificationDate(DateFormatter.getCurrentDateTimeString());
    }

    public void setLastModificationDate(String currentDateTimeString) {
        this.lastModificationDate = currentDateTimeString;
        this.element.addAttribute("LASTMODDATE", currentDateTimeString);
        this.document.setIsModified();
    }

    public List<Agent> getAgents() {
        return this.agents;
    }

    public String getAdmId() {
        return this.admId;
    }

    public void setAdmId(String admId) {
        this.admId = admId;
        this.element.addAttribute("ADMID", this.admId);
    }

    public String getSwName() {
        return this.getMyDigiprov().getLastObject().getSwName();
    }

    public String getSwType() {
        return this.getMyDigiprov().getLastObject().getSwType();
    }

    public void setSwNameAndType() {
        this.getMyDigiprov().getLastObject().setSwNameAndType();
    }

    private DigiprovWithPremis getMyDigiprov() {
        if (this.admId == null) {
            this.setAdmId(UniqueID.getXML());
            new DigiprovWithPremis(this);
            Logger.debug((Object)("Creating DigiprovWithPremis with admId: " + this.admId));
        }
        return ((Document)this.document).getAMDSection().getDigiprov(this.admId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("\n[Header:").append(this.createdDate).append("/").append(this.lastModificationDate).append("/").append(this.recordStatus).append("/").append(this.getSwName()).append(" ").append(this.getSwType()).append(" (agents:").append(this.agents.size()).append(")");
        for (Agent agent : this.agents) {
            buf.append("\n\t" + agent.toString());
        }
        buf.append("\n]");
        return buf.toString();
    }
}

