/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.util;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;

public class ReflectionUtil {
    public static ExLogger logger = ExLogger.getExLogger(ReflectionUtil.class);

    public static String property2value(Object obj, String[] propArray) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        String prop = null;
        for (int i = 0; i < propArray.length; ++i) {
            PropertyDescriptor descriptor;
            Method method;
            prop = propArray[i];
            String[] condition = prop.split("\\[|\\]|=");
            if (condition.length == 3 || condition.length == 2) {
                prop = condition[0];
            }
            if ((obj = (method = (descriptor = new PropertyDescriptor(prop, obj.getClass())).getReadMethod()).invoke(obj, (Object[])null)) == null) {
                return null;
            }
            if (condition.length == 2) {
                List<Object> objectsList = ReflectionUtil.evaluateCondition(obj, condition[1]);
                StringBuilder stringBuilder = new StringBuilder();
                if (objectsList == null || objectsList.size() == 0) {
                    return null;
                }
                for (Object object : objectsList) {
                    int newLength = propArray.length - (i + 1);
                    String[] newPropArray = new String[newLength];
                    System.arraycopy(propArray, i + 1, newPropArray, 0, newLength);
                    String value = ReflectionUtil.property2value(object, newPropArray);
                    stringBuilder.append(" ").append(value);
                }
                return stringBuilder.toString();
            }
            if (condition.length != 3) continue;
            try {
                List<Object> objectsList = ReflectionUtil.evaluateCondition(obj, condition[1], condition[2]);
                StringBuilder stringBuilder = new StringBuilder();
                if (objectsList == null || objectsList.size() == 0) {
                    return null;
                }
                for (Object object : objectsList) {
                    int newLength = propArray.length - (i + 1);
                    String[] newPropArray = new String[newLength];
                    System.arraycopy(propArray, i + 1, newPropArray, 0, newLength);
                    String value = ReflectionUtil.property2value(object, newPropArray);
                    stringBuilder.append(" ").append(value);
                }
                return stringBuilder.toString();
            }
            catch (Exception exception) {
                if (obj != null) continue;
                return null;
            }
        }
        return obj.toString();
    }

    public static String property2value(Object obj, String propertyName) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        String[] propArray = null;
        int beginIndex = propertyName.indexOf("].");
        if (beginIndex > 0) {
            String leftPart = propertyName.substring(0, beginIndex + 1);
            String rightPart = propertyName.substring(beginIndex + 2);
            String[] split = rightPart.split("\\.");
            int size = split.length;
            split = Arrays.copyOf(split, size + 1);
            System.arraycopy(split, 0, split, 1, size);
            split[0] = leftPart;
            propArray = split;
        } else {
            propArray = propertyName.split("\\.");
        }
        return ReflectionUtil.property2value(obj, propArray);
    }

    private static List<Object> evaluateCondition(Object obj, String string) {
        if (string == null) {
            return null;
        }
        if (!(obj instanceof List)) {
            return null;
        }
        List list = (List)obj;
        ArrayList<Object> objects = new ArrayList<Object>();
        if (string.equals("*")) {
            return list;
        }
        int index = 0;
        try {
            index = Integer.parseInt(string);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (list.size() > index) {
            objects.add(list.get(index));
        }
        return objects;
    }

    private static List<Object> evaluateCondition(Object obj, String propertyName, String propertyValue) throws Exception {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue.startsWith("\"") && propertyValue.endsWith("\"")) {
            propertyValue = propertyValue.substring(1, propertyValue.length() - 1);
        }
        if (!(obj instanceof List)) {
            return null;
        }
        List list = (List)obj;
        for (Object object : list) {
            String value = ReflectionUtil.property2value(object, propertyName);
            if (value == null || !value.equals(propertyValue)) continue;
            objects.add(object);
        }
        return objects;
    }

    public static Vector<String> getXPathValues(Object xmlDoc, String xPath) {
        Vector<String> v = new Vector<String>();
        try {
            List nodes = ((Document)xmlDoc).selectNodes(xPath);
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                String val = ((Node)iter.next()).getText();
                v.add(val);
            }
            return v;
        }
        catch (ClassCastException e) {
            logger.error("Skipping, Got ClassCastException xmlDoc=" + xmlDoc.getClass().getName() + " xpath=" + xPath, new String[0]);
            return v;
        }
        catch (Exception e) {
            if (xPath.contains("|")) {
                for (String aPath : xPath.split("\\|")) {
                    try {
                        List nodes = ((Document)xmlDoc).selectNodes(aPath);
                        Iterator iter = nodes.iterator();
                        while (iter.hasNext()) {
                            String val = ((Node)iter.next()).getText();
                            v.add(val);
                        }
                    }
                    catch (Exception e1) {
                        logger.error("xmlDoc=" + xmlDoc.getClass().getName() + " xpath=" + aPath + " Exception - " + e.getMessage(), new String[0]);
                    }
                }
            } else {
                logger.error("xmlDoc=" + xmlDoc.getClass().getName() + " xpath=" + xPath + " Exception - " + e.getMessage(), new String[0]);
            }
            return v;
        }
    }

    public static String getTargetFormatValue(String targetDnx) {
        String fmt = "";
        if (targetDnx.indexOf("<key id=\"formatName\">") != -1) {
            fmt = StringUtils.substringBetween((String)targetDnx, (String)"<key id=\"formatName\">", (String)"</key>");
        }
        return fmt;
    }
}

