/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.string;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class StringUtil {
    public static boolean isNumeric(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isDecimal(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        try {
            new BigDecimal(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isLetterOrDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isLetter(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String onlyDigits(String s) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isDigit(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static String onlyAlphasDigitsWhitespaces(String s) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isLetterOrDigit(c) && !Character.isWhitespace(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static int indexOf(String string, String search, int occurrence) {
        int i;
        if (occurrence == 0) {
            return -1;
        }
        if (search.isEmpty()) {
            return -1;
        }
        if (string.isEmpty()) {
            return -1;
        }
        if (string.length() < search.length()) {
            return -1;
        }
        if (string.equals(search)) {
            return 0;
        }
        int count = 0;
        if (occurrence > 0) {
            i = -1;
            do {
                ++i;
                if ((i = string.indexOf(search, i)) == -1) continue;
                ++count;
            } while (i != -1 && count < occurrence);
        } else {
            i = string.length() + 1;
            do {
                --i;
                if ((i = string.lastIndexOf(search, i)) == -1) continue;
                ++count;
            } while (i != -1 && count < -occurrence);
        }
        return i;
    }

    public static String substring(String string, int from) {
        return from >= 0 ? string.substring(from) : string.substring(string.length() + from);
    }

    public static String substring(String string, int from, int to) {
        if (from >= 0 && to >= 0) {
            return string.substring(from, to);
        }
        int length = string.length();
        if (from < 0) {
            from = length + from;
        }
        if (to < 0) {
            to = length + to;
        }
        return string.substring(from, to);
    }

    public static int occurrencesOf(String string, String search) {
        if (search.isEmpty()) {
            return 0;
        }
        if (string.isEmpty()) {
            return 0;
        }
        if (string.length() < search.length()) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i <= string.length() - search.length(); ++i) {
            if (!string.substring(i, i + search.length()).equals(search)) continue;
            ++count;
        }
        return count;
    }

    public static String concatSeparatedBy(Iterable<String> elements, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirst = true;
        for (String s : elements) {
            if (isFirst) {
                isFirst = false;
            } else {
                stringBuilder.append(separator);
            }
            stringBuilder.append(s);
        }
        return stringBuilder.toString();
    }

    public static String concatSeparatedBy(String[] elements, String separator) {
        return StringUtil.concatSeparatedBy(Arrays.asList(elements), separator);
    }

    public static List<String> split(String string) {
        return StringUtil.split(string, " ");
    }

    public static List<String> split(String string, String delimiter) {
        return StringUtil.split(string, delimiter, true);
    }

    public static List<String> split(String string, String delimiter, boolean ignoreEmptyTokens) {
        String token;
        ArrayList<String> tokens = new ArrayList<String>();
        if (delimiter.isEmpty()) {
            return tokens;
        }
        if (string.isEmpty() && ignoreEmptyTokens) {
            return tokens;
        }
        int beginIndex = 0;
        int endIndex = 0;
        do {
            if ((endIndex = string.indexOf(delimiter, beginIndex)) == -1) continue;
            token = string.substring(beginIndex, endIndex);
            if (!token.isEmpty() || !ignoreEmptyTokens) {
                tokens.add(token);
            }
            beginIndex = endIndex + delimiter.length();
        } while (endIndex != -1);
        token = string.substring(beginIndex, string.length());
        if (!token.isEmpty() || !ignoreEmptyTokens) {
            tokens.add(token);
        }
        return tokens;
    }

    public static List<String> splitQuoted(String string) {
        return StringUtil.splitQuoted(string, "\"");
    }

    public static List<String> splitQuoted(String string, String quote) {
        return StringUtil.splitQuoted(string, quote, " ");
    }

    public static List<String> splitQuoted(String string, String quote, String delimiter) {
        if (!string.contains(quote)) {
            return StringUtil.split(string, delimiter, true);
        }
        if (StringUtil.occurrencesOf(string, quote) % 2 == 1) {
            return StringUtil.split(string.replace(quote, ""), delimiter, true);
        }
        ArrayList<String> tokens = new ArrayList<String>();
        List<String> quokens = StringUtil.split(string, quote, false);
        for (int i = 0; i < quokens.size(); ++i) {
            if (i % 2 == 0) {
                tokens.addAll(StringUtil.split(quokens.get(i).trim(), delimiter, true));
                continue;
            }
            tokens.add(quokens.get(i));
        }
        return tokens;
    }

    public static boolean containsAll(String string, String ... searchStrings) {
        return StringUtil.containsAll(string, Arrays.asList(searchStrings));
    }

    public static boolean containsAll(String string, List<String> searchStrings) {
        for (String searchString : searchStrings) {
            if (string.contains(searchString)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAny(String string, String ... searchStrings) {
        return StringUtil.containsAny(string, Arrays.asList(searchStrings));
    }

    public static boolean containsAny(String string, List<String> searchStrings) {
        for (String searchString : searchStrings) {
            if (!string.contains(searchString)) continue;
            return true;
        }
        return false;
    }

    public static String first(String string, Integer i) {
        if (i >= string.length()) {
            return string;
        }
        return string.substring(0, i);
    }

    public static String last(String string, Integer i) {
        if (i >= string.length()) {
            return string;
        }
        return string.substring(string.length() - i);
    }

    public static String padUpRightWith(String s, Character c, int size) {
        StringBuilder stringBuilder = new StringBuilder(s);
        for (int i = 0; i < size; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.substring(0, size);
    }

    public static String padUpLeftWith(String s, Character c, int size) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(s);
        return stringBuilder.substring(stringBuilder.length() - size);
    }

    public static List<String> wrap(String string, int wrapWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        int stringLength = string.length();
        for (int i = 0; i < stringLength; i += wrapWidth) {
            lines.add(string.substring(i, Math.min(i + wrapWidth, stringLength)));
        }
        return lines;
    }

    public static List<String> wordWrap(String string, int wrapWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        int stringLength = string.length();
        int startPos = 0;
        boolean done = false;
        do {
            int endPos;
            if ((endPos = Math.min(startPos + wrapWidth, stringLength)) == stringLength) {
                done = true;
            } else {
                int lastSpacePos = string.lastIndexOf(" ", endPos);
                if (lastSpacePos != -1) {
                    endPos = lastSpacePos;
                }
            }
            lines.add(string.substring(startPos, endPos).trim());
            startPos = endPos + 1;
        } while (!done);
        return lines;
    }

    public static String trimLeft(String string) {
        return string.replaceAll("^\\s+", "");
    }

    public static String trimRight(String string) {
        return string.replaceAll("\\s+$", "");
    }

    public static String trimLeftAndRight(String string) {
        return StringUtil.trimLeft(StringUtil.trimRight(string));
    }

    public static String trimMid(String string) {
        return string.replaceAll("\\b\\s{2,}\\b", " ");
    }

    public static String trimAll(String string) {
        return StringUtil.trimLeftAndRight(StringUtil.trimMid(string));
    }

    public static String increment(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!Character.isLetterOrDigit(s.charAt(i))) continue;
            char c = s.charAt(i);
            if (c == '9') {
                char digit;
                int j;
                String numberString = "9";
                for (j = i - 1; j >= 0 && Character.isDigit(digit = s.charAt(j)); --j) {
                    numberString = digit + numberString;
                }
                long number = new Long(numberString);
                return s.substring(0, j + 1) + new Long(++number) + s.substring(i + 1);
            }
            if (c == 'z') {
                return s.substring(0, i) + "za" + s.substring(i + 1);
            }
            if (c == 'Z') {
                return s.substring(0, i) + "ZA" + s.substring(i + 1);
            }
            c = (char)(c + '\u0001');
            return s.substring(0, i) + new Character(c).toString() + s.substring(i + 1);
        }
        return s + "1";
    }
}

