/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ITemplateCall;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallTemplate
extends Instruction
implements ITemplateCall {
    private Template template = null;
    private WithParam[] actualParams = WithParam.EMPTY_ARRAY;
    private WithParam[] tunnelParams = WithParam.EMPTY_ARRAY;
    private boolean useTailRecursion = false;
    private Expression calledTemplateExpression;
    private NamespaceResolver nsContext;

    public CallTemplate(Template template, boolean useTailRecursion, Expression calledTemplateExpression, NamespaceResolver nsContext) {
        this.template = template;
        this.useTailRecursion = useTailRecursion;
        this.calledTemplateExpression = calledTemplateExpression;
        this.nsContext = nsContext;
        this.adoptChildExpression(calledTemplateExpression);
    }

    public Expression getCalledTemplateExpression() {
        return this.calledTemplateExpression;
    }

    public NamespaceResolver getNsContext() {
        return this.nsContext;
    }

    public void setActualParameters(WithParam[] actualParams, WithParam[] tunnelParams) {
        this.actualParams = actualParams;
        this.tunnelParams = tunnelParams;
        for (WithParam actualParam : actualParams) {
            this.adoptChildExpression(actualParam.getSelectExpression());
        }
        for (WithParam tunnelParam : tunnelParams) {
            this.adoptChildExpression(tunnelParam.getSelectExpression());
        }
    }

    @Override
    public WithParam[] getActualParams() {
        return this.actualParams;
    }

    @Override
    public WithParam[] getTunnelParams() {
        return this.tunnelParams;
    }

    public Template getTargetTemplate() {
        return this.template;
    }

    public boolean usesTailRecursion() {
        return this.useTailRecursion;
    }

    @Override
    public int getInstructionNameCode() {
        return 137;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        WithParam.simplify(this.actualParams, visitor);
        WithParam.simplify(this.tunnelParams, visitor);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = visitor.simplify(this.calledTemplateExpression);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        WithParam.typeCheck(this.actualParams, visitor, contextItemType);
        WithParam.typeCheck(this.tunnelParams, visitor, contextItemType);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = visitor.typeCheck(this.calledTemplateExpression, contextItemType);
            this.adoptChildExpression(this.calledTemplateExpression);
        } else if (this.template.getBody() != null) {
            boolean backwards = visitor.getStaticContext().isInBackwardsCompatibleMode();
            for (int p = 0; p < this.actualParams.length; ++p) {
                WithParam wp = this.actualParams[p];
                int id = wp.getParameterId();
                LocalParam lp = this.template.getLocalParam(id);
                if (lp == null) continue;
                SequenceType req = lp.getRequiredType();
                RoleLocator role = new RoleLocator(8, wp.getVariableQName().getDisplayName(), p);
                Expression select = TypeChecker.staticTypeCheck(wp.getSelectExpression(), req, backwards, role, visitor);
                wp.setSelectExpression(select);
                wp.setTypeChecked(true);
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        WithParam.optimize(visitor, this.actualParams, contextItemType);
        WithParam.optimize(visitor, this.tunnelParams, contextItemType);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = visitor.optimize(this.calledTemplateExpression, contextItemType);
            this.adoptChildExpression(this.calledTemplateExpression);
        }
        return this;
    }

    @Override
    public int computeCardinality() {
        if (this.template == null) {
            return 57344;
        }
        return this.template.getRequiredType().getCardinality();
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.template == null) {
            return AnyItemType.getInstance();
        }
        return this.template.getRequiredType().getPrimaryType();
    }

    @Override
    public Expression copy() {
        CallTemplate ct = new CallTemplate(this.template, this.useTailRecursion, this.calledTemplateExpression == null ? null : this.calledTemplateExpression.copy(), this.nsContext);
        ct.actualParams = WithParam.copy(this.actualParams);
        ct.tunnelParams = WithParam.copy(this.tunnelParams);
        return ct;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 639;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(10);
        if (this.calledTemplateExpression != null) {
            list.add(this.calledTemplateExpression);
        }
        WithParam.gatherXPathExpressions(this.actualParams, list);
        WithParam.gatherXPathExpressions(this.tunnelParams, list);
        return list.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (WithParam.replaceXPathExpression(this.actualParams, original, replacement)) {
            found = true;
        }
        if (WithParam.replaceXPathExpression(this.tunnelParams, original, replacement)) {
            found = true;
        }
        if (this.calledTemplateExpression == original) {
            this.calledTemplateExpression = replacement;
        }
        return found;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = this.doPromotion(this.calledTemplateExpression, offer);
        }
        WithParam.promoteParams(this, this.actualParams, offer);
        WithParam.promoteParams(this, this.tunnelParams, offer);
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        Template t = this.getTargetTemplate(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.openStackFrame(t.getStackFrameMap());
        c2.setLocalParameters(CallTemplate.assembleParams(context, this.actualParams));
        c2.setTunnelParameters(CallTemplate.assembleTunnelParams(context, this.tunnelParams));
        try {
            for (TailCall tc = t.expand(c2); tc != null; tc = tc.processLeavingTail()) {
            }
        }
        catch (StackOverflowError e) {
            XPathException err = new XPathException("Too many nested template or function calls. The stylesheet may be looping.");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        if (this.useTailRecursion) {
            Template target = this.getTargetTemplate(context);
            ParameterSet params = CallTemplate.assembleParams(context, this.actualParams);
            ParameterSet tunnels = CallTemplate.assembleTunnelParams(context, this.tunnelParams);
            if (params == null) {
                params = ParameterSet.EMPTY_PARAMETER_SET;
            }
            Arrays.fill(context.getStackFrame().getStackFrameValues(), null);
            return new CallTemplatePackage(target, params, tunnels, this, context);
        }
        this.process(context);
        return null;
    }

    public Template getTargetTemplate(XPathContext context) throws XPathException {
        if (this.calledTemplateExpression != null) {
            String localName;
            String prefix;
            Controller controller = context.getController();
            assert (controller != null);
            CharSequence qname = this.calledTemplateExpression.evaluateAsString(context);
            try {
                String[] parts = controller.getConfiguration().getNameChecker().getQNameParts(qname);
                prefix = parts[0];
                localName = parts[1];
            }
            catch (QNameException err) {
                this.dynamicError("Invalid template name. " + err.getMessage(), "XTSE0650", context);
                return null;
            }
            String uri = this.nsContext.getURIForPrefix(prefix, false);
            if (uri == null) {
                this.dynamicError("Namespace prefix " + prefix + " has not been declared", "XTSE0650", context);
            }
            StructuredQName qName = new StructuredQName("", uri, localName);
            Template target = ((PreparedStylesheet)controller.getExecutable()).getNamedTemplate(qName);
            if (target == null) {
                this.dynamicError("Template " + qname + " has not been defined", "XTSE0650", context);
            }
            return target;
        }
        return this.template;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.template == null ? null : this.template.getTemplateName();
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("callTemplate");
        if (this.template != null && this.template.getTemplateName() != null) {
            out.emitAttribute("name", this.template.getTemplateName().getDisplayName());
        } else {
            out.startSubsidiaryElement("name");
            this.calledTemplateExpression.explain(out);
            out.endSubsidiaryElement();
        }
        if (this.actualParams.length > 0) {
            out.startSubsidiaryElement("withParams");
            WithParam.explainParameters(this.actualParams, out);
            out.endSubsidiaryElement();
        }
        if (this.tunnelParams.length > 0) {
            out.startSubsidiaryElement("tunnelParams");
            WithParam.explainParameters(this.tunnelParams, out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    public static class CallTemplatePackage
    implements TailCall {
        private Template target;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private Instruction instruction;
        private XPathContext evaluationContext;

        public CallTemplatePackage(Template template, ParameterSet params, ParameterSet tunnelParams, Instruction instruction, XPathContext evaluationContext) {
            this.target = template;
            this.params = params;
            this.tunnelParams = tunnelParams;
            this.instruction = instruction;
            this.evaluationContext = evaluationContext;
        }

        public TailCall processLeavingTail() throws XPathException {
            XPathContextMajor c2 = this.evaluationContext.newContext();
            c2.setOrigin(this.instruction);
            c2.setLocalParameters(this.params);
            c2.setTunnelParameters(this.tunnelParams);
            c2.openStackFrame(this.target.getStackFrameMap());
            return this.target.expand(c2);
        }
    }
}

