/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.sequence.horspool;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.AnyByteMatcher;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.searcher.sequence.AbstractSequenceSearcher;
import net.byteseek.utils.factory.ObjectFactory;
import net.byteseek.utils.lazy.DoubleCheckImmutableLazyObject;
import net.byteseek.utils.lazy.LazyObject;

public final class HorspoolFinalFlagSearcher
extends AbstractSequenceSearcher {
    private final LazyObject<SearchInfo> forwardInfo = new DoubleCheckImmutableLazyObject<SearchInfo>(new ForwardInfoFactory());
    private final LazyObject<SearchInfo> backwardInfo = new DoubleCheckImmutableLazyObject<SearchInfo>(new BackwardInfoFactory());

    public HorspoolFinalFlagSearcher(SequenceMatcher sequence) {
        super(sequence);
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchForwards(byte[] bytes, int fromPosition, int toPosition) {
        int shift;
        int finalPosition;
        SearchInfo info = this.forwardInfo.get();
        int[] safeShifts = info.shifts;
        SequenceMatcher verifier = info.verifier;
        int lastMatcherPosition = this.getMatcher().length() - 1;
        int lastPossiblePosition = bytes.length - 1;
        int lastPossibleSearchPosition = toPosition + lastMatcherPosition;
        int n = finalPosition = lastPossibleSearchPosition < lastPossiblePosition ? lastPossibleSearchPosition : lastPossiblePosition;
        for (int searchPosition = fromPosition > 0 ? fromPosition + lastMatcherPosition : lastMatcherPosition; searchPosition <= finalPosition; searchPosition -= shift) {
            shift = safeShifts[bytes[searchPosition] & 0xFF];
            while (shift > 0) {
                if ((searchPosition += shift) > finalPosition) {
                    return SearchUtils.noResults();
                }
                shift = safeShifts[bytes[searchPosition] & 0xFF];
            }
            int startMatchPosition = searchPosition - lastMatcherPosition;
            if (!verifier.matchesNoBoundsCheck(bytes, startMatchPosition)) continue;
            return SearchUtils.singleResult(startMatchPosition, this.matcher);
        }
        return SearchUtils.noResults();
    }

    @Override
    protected List<SearchResult<SequenceMatcher>> doSearchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int arrayStartPosition;
        int arraySearchPosition;
        SearchInfo info = this.forwardInfo.get();
        int[] safeShifts = info.shifts;
        SequenceMatcher verifier = info.verifier;
        long endSequencePosition = this.matcher.length() - 1;
        long finalPosition = toPosition + endSequencePosition;
        block0: for (long searchPosition = fromPosition + endSequencePosition; searchPosition <= finalPosition && (window = reader.getWindow(searchPosition)) != null; searchPosition += (long)(arraySearchPosition - arrayStartPosition)) {
            int shift;
            byte[] array = window.getArray();
            arrayStartPosition = reader.getWindowOffset(searchPosition);
            int arrayEndPosition = window.length() - 1;
            int lastMatcherPosition = this.matcher.length() - 1;
            long distanceToEnd = finalPosition - window.getWindowPosition() + (long)lastMatcherPosition;
            int lastSearchPosition = distanceToEnd < (long)arrayEndPosition ? (int)distanceToEnd : arrayEndPosition;
            for (arraySearchPosition = arrayStartPosition; arraySearchPosition <= lastSearchPosition; arraySearchPosition -= shift) {
                shift = safeShifts[array[arraySearchPosition] & 0xFF];
                while (shift > 0) {
                    if ((arraySearchPosition += shift) > lastSearchPosition) continue block0;
                    shift = safeShifts[array[arraySearchPosition] & 0xFF];
                }
                long totalShift = arraySearchPosition - arrayStartPosition;
                long matchPosition = searchPosition + totalShift - endSequencePosition;
                if (!verifier.matches(reader, matchPosition)) continue;
                return SearchUtils.singleResult(matchPosition, this.matcher);
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchBackwards(byte[] bytes, int fromPosition, int toPosition) {
        int shift;
        int lastPosition;
        SearchInfo info = this.backwardInfo.get();
        int[] safeShifts = info.shifts;
        SequenceMatcher verifier = info.verifier;
        int n = lastPosition = toPosition > 0 ? toPosition : 0;
        for (int searchPosition = fromPosition < (firstPossiblePosition = bytes.length - this.getMatcher().length()) ? fromPosition : firstPossiblePosition; searchPosition >= lastPosition; searchPosition += shift) {
            shift = safeShifts[bytes[searchPosition] & 0xFF];
            while (shift > 0) {
                if ((searchPosition -= shift) < lastPosition) {
                    return SearchUtils.noResults();
                }
                shift = safeShifts[bytes[searchPosition] & 0xFF];
            }
            if (verifier != null && !verifier.matchesNoBoundsCheck(bytes, searchPosition + 1)) continue;
            return SearchUtils.singleResult(searchPosition, this.matcher);
        }
        return SearchUtils.noResults();
    }

    @Override
    protected List<SearchResult<SequenceMatcher>> doSearchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int arraySearchPosition;
        int arrayStartPosition;
        SearchInfo info = this.backwardInfo.get();
        int[] safeShifts = info.shifts;
        SequenceMatcher verifier = info.verifier;
        block0: for (long searchPosition = fromPosition; searchPosition >= toPosition && (window = reader.getWindow(searchPosition)) != null; searchPosition -= (long)(arrayStartPosition - arraySearchPosition)) {
            int shift;
            byte[] array = window.getArray();
            arrayStartPosition = reader.getWindowOffset(searchPosition);
            long distanceToEnd = toPosition - window.getWindowPosition();
            int lastSearchPosition = distanceToEnd > 0L ? (int)distanceToEnd : 0;
            for (arraySearchPosition = arrayStartPosition; arraySearchPosition >= lastSearchPosition; arraySearchPosition += shift) {
                shift = safeShifts[array[arraySearchPosition] & 0xFF];
                while (shift > 0) {
                    if ((arraySearchPosition -= shift) < lastSearchPosition) continue block0;
                    shift = safeShifts[array[arraySearchPosition] & 0xFF];
                }
                int totalShift = arrayStartPosition - arraySearchPosition;
                long startMatchPosition = searchPosition - (long)totalShift;
                if (verifier != null && !verifier.matches(reader, startMatchPosition + 1L)) continue;
                return SearchUtils.singleResult(startMatchPosition, this.matcher);
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public void prepareForwards() {
        this.forwardInfo.get();
    }

    @Override
    public void prepareBackwards() {
        this.backwardInfo.get();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[sequence:" + this.matcher + ']';
    }

    private final class BackwardInfoFactory
    implements ObjectFactory<SearchInfo> {
        private BackwardInfoFactory() {
        }

        @Override
        public SearchInfo create() {
            byte[] matchingBytes;
            SequenceMatcher sequence = HorspoolFinalFlagSearcher.this.getMatcher();
            int sequenceLength = sequence.length();
            int lastPosition = sequenceLength - 1;
            SequenceMatcher verifier = lastPosition == 0 ? null : sequence.subsequence(1, sequenceLength);
            int maxShift = sequenceLength;
            for (int position = 0; position < sequenceLength; ++position) {
                ByteMatcher matcher = sequence.getMatcherForPosition(position);
                if (matcher.getNumberOfMatchingBytes() != 256) continue;
                maxShift = position + 1;
                break;
            }
            int[] shifts = new int[256];
            Arrays.fill(shifts, maxShift);
            if (maxShift > 1) {
                int processShiftsFromPos;
                for (int sequencePos = processShiftsFromPos = maxShift - 1; sequencePos > 0; --sequencePos) {
                    byte[] matchingBytes2;
                    ByteMatcher aMatcher = sequence.getMatcherForPosition(sequencePos);
                    for (byte b : matchingBytes2 = aMatcher.getMatchingBytes()) {
                        shifts[b & 0xFF] = sequencePos;
                    }
                }
            }
            ByteMatcher firstMatcher = sequence.getMatcherForPosition(0);
            for (byte b : matchingBytes = firstMatcher.getMatchingBytes()) {
                shifts[b & 0xFF] = -shifts[b & 0xFF];
            }
            return new SearchInfo(shifts, verifier);
        }
    }

    private final class ForwardInfoFactory
    implements ObjectFactory<SearchInfo> {
        private ForwardInfoFactory() {
        }

        @Override
        public SearchInfo create() {
            byte[] matchingBytes;
            SequenceMatcher sequence = HorspoolFinalFlagSearcher.this.getMatcher();
            int sequenceLength = sequence.length();
            int lastPosition = sequenceLength - 1;
            AnyByteMatcher verifier = lastPosition == 0 ? AnyByteMatcher.ANY_BYTE_MATCHER : sequence.subsequence(0, lastPosition);
            int maxShift = sequenceLength;
            for (int position = sequenceLength - 1; position >= 0; --position) {
                ByteMatcher matcher = sequence.getMatcherForPosition(position);
                if (matcher.getNumberOfMatchingBytes() != 256) continue;
                maxShift = sequenceLength - position;
                break;
            }
            int[] shifts = new int[256];
            Arrays.fill(shifts, maxShift);
            if (maxShift > 1) {
                int processShiftsFromPos;
                for (int sequencePos = processShiftsFromPos = sequenceLength - maxShift; sequencePos < lastPosition; ++sequencePos) {
                    ByteMatcher aMatcher = sequence.getMatcherForPosition(sequencePos);
                    byte[] matchingBytes2 = aMatcher.getMatchingBytes();
                    int distanceFromEnd = sequenceLength - sequencePos - 1;
                    for (byte b : matchingBytes2) {
                        shifts[b & 0xFF] = distanceFromEnd;
                    }
                }
            }
            ByteMatcher lastMatcher = sequence.getMatcherForPosition(lastPosition);
            for (byte b : matchingBytes = lastMatcher.getMatchingBytes()) {
                shifts[b & 0xFF] = -shifts[b & 0xFF];
            }
            return new SearchInfo(shifts, verifier);
        }
    }

    private static final class SearchInfo {
        private final int[] shifts;
        private final SequenceMatcher verifier;

        private SearchInfo(int[] shifts, SequenceMatcher verifier) {
            this.shifts = shifts;
            this.verifier = verifier;
        }
    }
}

