/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

public class GeoTiffStrings {
    public static final int[] MODELTYPE_INDEX = new int[]{0, 1, 2, 3, Short.MAX_VALUE};
    public static final String[] MODELTYPE = new String[]{"Undefined", "Projection coordinate system", "Geographic latitude-longitude system (FGDC geographic)", "Geocentric (X,Y,Z) coordinate system (FGDC planar-projected)", "User-defined"};
    public static final int[] RASTERTYPE_INDEX = new int[]{0, 1, 2, Short.MAX_VALUE};
    public static final String[] RASTERTYPE = new String[]{"Undefined", "Pixel is area", "Pixel is point", "User-defined"};
    public static final int[] LINEARUNITS_INDEX = new int[]{0, 9001, 9002, 9003, 9004, 9005, 9006, 9007, 9008, 9009, 9010, 9011, 9012, 9013, 9014, 9015, Short.MAX_VALUE};
    public static final String[] LINEARUNITS = new String[]{"Undefined", "Meter", "Foot", "Foot (US survey)", "Foot (modified American)", "Foot (Clarke)", "Foot (Indian)", "Link", "Link (Benoit)", "Link (Sears)", "Chain (Benoit)", "Chain (Sears)", "Yard (Sears)", "Yard (Indian)", "Fathom", "Mile (International nautical)", "User-defined"};
    public static final int[] ANGULARUNITS_INDEX = new int[]{0, 9101, 9102, 9103, 9104, 9105, 9106, 9107, 9108, Short.MAX_VALUE};
    public static final String[] ANGULARUNITS = new String[]{"Undefined", "Radian", "Degree", "Arc minute", "Second", "Grad", "Gon", "DMS", "DMS hemisphere", "User-defined"};
    public static final int[] GEOGRAPHICS_INDEX = new int[]{0, 4001, 4002, 4003, 4004, 4005, 4006, 4007, 4008, 4009, 4010, 4011, 4012, 4013, 4014, 4015, 4016, 4017, 4018, 4019, 4020, 4021, 4022, 4023, 4024, 4025, 4026, 4027, 4028, 4029, 4030, 4031, 4032, 4033, 4034, 4035, 4201, 4202, 4203, 4204, 4205, 4206, 4207, 4208, 4209, 4210, 4211, 4212, 4213, 4214, 4215, 4216, 4217, 4218, 4219, 4220, 4221, 4222, 4223, 4224, 4225, 4226, 4227, 4228, 4229, 4230, 4231, 4232, 4233, 4234, 4235, 4236, 4237, 4238, 4239, 4240, 4241, 4242, 4243, 4244, 4245, 4246, 4247, 4248, 4249, 4250, 4251, 4252, 4253, 4254, 4255, 4256, 4257, 4258, 4259, 4260, 4261, 4262, 4263, 4264, 4265, 4266, 4267, 4268, 4269, 4270, 4271, 4272, 4273, 4274, 4275, 4276, 4277, 4278, 4279, 4280, 4281, 4282, 4283, 4284, 4285, 4286, 4287, 4288, 4289, 4290, 4291, 4292, 4293, 4294, 4295, 4296, 4297, 4298, 4299, 4300, 4301, 4302, 4303, 4304, 4305, 4306, 4307, 4308, 4309, 4310, 4311, 4312, 4313, 4314, 4315, 4801, 4802, 4803, 4804, 4805, 4806, 4807, 4808, 4809, 4810, 4811, 4812, 4813, 4901, 4902, Short.MAX_VALUE};
    public static final String[] GEOGRAPHICS = new String[]{"Undefined", "Ellipsoid Airy 1830", "Ellipsoid Airy Modified 1849", "Ellipsoid Australian National Spheroid", "Ellipsoid Bessel 1841", "Ellipsoid Bessel modified", "Ellipsoid Bessel Namibia", "Ellipsoid Clarke 1858", "Ellipsoid Clarke 1866", "Ellipsoid Clarke 1866 Michigan", "Ellipsoid Clarke 1880 Benoit", "Ellipsoid Clarke 1880 IGN", "Ellipsoid Clarke 1880 RGS", "Ellipsoid Clarke 1880 arc", "Ellipsoid Clarke 1880 SGA 1922", "Ellipsoid Everest 1830-1937 adjustment", "Ellipsoid Everest 1830-1967 definition", "Ellipsoid Everest 1830-1975 definition", "Ellipsoid Everest 1830 modified", "Ellipsoid GRS 1980", "Ellipsoid Helmert 1906", "Ellipsoid Indonesian national spheroid", "Ellipsoid international 1924", "Ellipsoid international 1967", "Ellipsoid Krassowsky 1940", "Ellipsoid NWL9D", "Ellipsoid NWL10D", "Ellipsoid Plessis 1817", "Ellipsoid Struve 1860", "Ellipsoid war office", "Ellipsoid WGS84", "Ellipsoid GEM10C", "Ellipsoid OSU86F", "Ellipsoid OSU91A", "Ellipsoid Clarke 1880", "Ellipsoid sphere", "Adindan", "AGD66", "AGD84", "Ain el Abd", "Afgooye", "Agadez", "Lisbon", "Aratu", "Arc 1950", "Arc 1960", "Batavia", "Barbados", "Beduaram", "Beijing 1954", "Belge 1950", "Bermuda 1957", "Bern 1898", "Bogota", "Bukit Rimpah", "Camacupa", "Campo Inchauspe", "Cape", "Carthage", "Chua", "Corrego Alegre", "Cote d Ivoire", "Deir ez Zor", "Douala", "Egypt 1907", "ED50", "ED87", "Fahud", "Gandajika 1970", "Garoua", "Guyane Francaise", "Hu Tzu Shan", "HD72", "ID74", "Indian 1954", "Indian 1975", "Jamaica 1875", "JAD69", "Kalianpur", "Kandawala", "Kertau", "KOC", "La Canoa", "PSAD56", "Lake", "Leigon", "Liberia 1964", "Lome", "Luzon 1911", "Hito XVIII 1963", "Herat north", "Mahe 1971", "Makassar", "EUREF89", "Malongo 1987", "Manoca", "Merchich", "Massawa", "Minna", "Mhast", "Monte Mario", "M poraloko", "NAD27", "NAD Michigan", "NAD83", "Nahrwan 1967", "Naparima 1972", "GD49", "NGO 1948", "Datum 73", "NTF", "NSWC 9Z 2", "OSGB 1936", "OSGB70", "OS SN80", "Padang", "Palestine 1923", "Pointe Noire", "GDA94", "Pulkovo 1942", "Qatar", "Qatar 1948", "Qornoq", "Loma Quintana", "Amersfoort", "RT38", "SAD69", "Sapper Hill 1943", "Schwarzeck", "Segora", "Serindung", "Sudan", "Tananarive", "Timbalai 1948", "TM65", "TM75", "Tokyo", "Trinidad 1903", "TC 1948", "Voirol 1875", "Voirol Unifie", "Bern 1938", "Nord Sahara 1959", "Stockholm 1938", "Yacare", "Yoff", "Zanderij", "MGI", "Belge 1972", "DHDN", "Conakry 1905", "WGS 72", "WGS 72BE", "WGS 84", "Bern 1898 Bern", "Bogota Bogota", "Lisbon Lisbon", "Makassar Jakarta", "MGI Ferro", "Monte Mario Rome", "NTF Paris", "Padang Jakarta", "Belge 1950 Brussels", "Tananarive Paris", "Voirol 1875 Paris", "Voirol Unifie Paris", "Batavia Jakarta", "ATF Paris", "NDG Paris", "User-defined"};
    public static final int[] GEODETICDATUM_INDEX = new int[]{6001, 6002, 6003, 6004, 6005, 6006, 6007, 6008, 6009, 6010, 6011, 6012, 6013, 6014, 6015, 6016, 6017, 6018, 6019, 6020, 6021, 6022, 6023, 6024, 6025, 6026, 6027, 6028, 6029, 6030, 6031, 6032, 6033, 6034, 6035, 6201, 6202, 6203, 6204, 6205, 6206, 6207, 6208, 6209, 6210, 6211, 6212, 6213, 6214, 6215, 6216, 6217, 6218, 6219, 6220, 6221, 6222, 6223, 6224, 6225, 6226, 6227, 6228, 6229, 6230, 6231, 6232, 6233, 6234, 6235, 6236, 6237, 6238, 6239, 6240, 6241, 6242, 6243, 6244, 6245, 6246, 6247, 6248, 6249, 6250, 6251, 6252, 6253, 6254, 6255, 6256, 6257, 6258, 6259, 6260, 6261, 6262, 6263, 6264, 6265, 6266, 6267, 6268, 6269, 6270, 6271, 6272, 6273, 6274, 6275, 6276, 6277, 6278, 6279, 6280, 6281, 6282, 6283, 6284, 6285, 6286, 6287, 6288, 6289, 6290, 6291, 6292, 6293, 6294, 6295, 6296, 6297, 6298, 6299, 6300, 6301, 6302, 6303, 6304, 6305, 6306, 6307, 6308, 6309, 6310, 6311, 6312, 6313, 6314, 6315, 6322, 6324, 6326, 6901, 6902, Short.MAX_VALUE};
    public static final String[] GEODETICDATUM = new String[]{"Undefined", "Ellipsoid Airy 1830", "Ellipsoid Airy modified 1849", "Ellipsoid Australian national spheroid", "Ellipsoid Bessel 1841", "Ellipsoid Bessel modified", "Ellipsoid Bessel Namibia", "Ellipsoid Clarke 1858", "Ellipsoid Clarke 1866", "Ellipsoid Clarke 1866 Michigan", "Ellipsoid Clarke 1880 Benoit", "Ellipsoid Clarke 1880 IGN", "Ellipsoid Clarke 1880 RGS", "Ellipsoid Clarke 1880 arc", "Ellipsoid Clarke 1880 SGA1922", "Ellipsoid Everest 1830-1937 adjustment", "Ellipsoid Everest 1830-1967 definition", "Ellipsoid Everest 1830-1975 definition", "Ellipsoid Everest 1830 modified", "Ellipsoid GRS1980", "Ellipsoid Helmert1906", "Ellipsoid Indonesian national spheroid", "Ellipsoid international 1924", "Ellipsoid international 1967", "Ellipsoid Krassowsky 1960", "Ellipsoid NWL9D", "Ellipsoid NWL10D", "Ellipsoid Plessis 1817", "Ellipsoid Struve 1860", "Ellipsoid war office", "Ellipsoid WGS84", "Ellipsoid GEM10C", "Ellipsoid OSU86F", "Ellipsoid OSU91A", "Ellipsoid Clarke 1880", "Ellipsoid sphere", "Adindan", "Australian geodetic 1966", "Australian geodetic 1984", "Ain el Abd 1970", "Afgooye", "Agadez", "Lisbon", "Aratu", "Arc 1950", "Arc 1960", "Batavia", "Barbados", "Beduaram", "Beijing 1954", "Reseau National Belge 1950", "Bermuda 1957", "Bern 1898", "Bogota", "Bukit Rimpah", "Camacupa", "Campo Inchauspe", "Cape", "Carthage", "Chua", "Corrego Alegre", "Cote d'Ivoire", "Deir ez Zor", "Douala", "Egypt 1907", "European 1950", "European 1987", "Fahud", "Gandajika 1970", "Garoua", "Guyane Francaise", "Hu Tzu Shan", "Hungarian 1972", "Indonesian 1974", "Indian 1954", "Indian 1975", "Jamaica 1875", "Jamaica 1969", "Kalianpur", "Kandawala", "Kertau", "Kuwait Oil Company", "La Canoa", "Provisional S American 1956", "Lake", "Leigon", "Liberia 1964", "Lome", "Luzon 1911", "Hito XVIII 1963", "Herat north", "Mahe 1971", "Makassar", "European reference system 1989", "Malongo 1987", "Manoca", "Merchich", "Massawa", "Minna", "Mhast", "Monte Mario", "M poraloko", "North American 1927", "NAD Michigan", "north American 1983", "Nahrwan 1967", "Naparima 1972", "New Zealand geodetic 1949", "NGO 1948", "73", "Nouvelle triangulation Francaise", "NSWC 9Z 2", "OSGB 1936", "OSGB 1970 SN", "OS SN 1980", "Padang 1884", "Palestine 1923", "Pointe Noire", "Geocentric of Australia 1994", "Pulkovo 1942", "Qatar", "Qatar 1948", "Qornoq", "Loma Quintana", "Amersfoort", "RT38", "south American 1969", "Sapper Hill 1943", "Schwarzeck", "Segora", "Serindung", "Sudan", "Tananarive 1925", "Timbalai 1948", "TM65", "TM75", "Tokyo", "Trinidad 1903", "Trucial Coast 1948", "Voirol 1875", "Voirol Unifie 1960", "Bern 1938", "Nord Sahara 1959", "Stockholm 1938", "Yacare", "Yoff", "Zanderij", "Militar Geographische Institut", "Reseau National Belge 1972", "Deutsche Hauptdreiecksnetz", "Conakry 1905", "WGS72", "WGS72 transit broadcast ephemeris", "WGS84", "Ancienne triangulation Francaise", "Nord de Guerre", "User-defined"};
    public static final int[] ELLIPSOID_INDEX = new int[]{0, 7001, 7002, 7003, 7004, 7005, 7006, 7007, 7008, 7009, 7010, 7011, 7012, 7013, 7014, 7015, 7016, 7017, 7018, 7019, 7020, 7021, 7022, 7023, 7024, 7025, 7026, 7027, 7028, 7029, 7030, 7031, 7032, 7033, 7034, 7035, Short.MAX_VALUE};
    public static final String[] ELLIPSOID = new String[]{"Undefined", "Airy 1830", "Airy modified 1849", "Australian national spheroid", "Bessel 1841", "Bessel modified", "Bessel Namibia", "Clarke 1858", "Clarke 1866", "Clarke 1866 Michigan", "Clarke 1880 Benoit", "Clarke 1880 IGN", "Clarke 1880 RGS", "Clarke 1880 arc", "Clarke 1880 SGA 1922", "Everest 1830-1937 adjustment", "Everest 1830-1967 definition", "Everest 1830-1975 definition", "Everest 1830 modified", "GRS 1980", "Helmert 1906", "Indonesian national spheroid", "International 1924", "International 1967", "Krassowsky 1940", "NWL 9D", "NWL 10D", "Plessis 1817", "Struve 1860", "War Office", "WGS 84", "GEM 10C", "OSU86F", "OSU91A", "Clarke 1880", "Sphere", "User-defined"};
    public static final int[] PRIMEMERIDIAN_INDEX = new int[]{0, 8901, 8902, 8903, 8904, 8905, 8906, 8907, 8908, 8909, 8910, 8911, Short.MAX_VALUE};
    public static final String[] PRIMEMERIDIAN = new String[]{"Undefined", "Greenwich", "Lisbon", "Paris", "Bogota", "Madrid", "Rome", "Bern", "Jakarta", "Ferro", "Brussels", "Stockholm", "User-defined"};
    public static final int[] PROJECTEDCSTYPE_INDEX = new int[]{0, 20137, 20138, 20248, 20249, 20250, 20251, 20252, 20253, 20254, 20255, 20256, 20257, 20258, 20348, 20349, 20350, 20351, 20352, 20353, 20354, 20355, 20356, 20357, 20358, 20437, 20438, 20439, 20499, 20538, 20539, 20700, 20822, 20823, 20824, 20973, 20975, 20977, 20979, 20981, 20983, 20985, 20987, 20989, 20991, 20993, 20995, 21100, 21148, 21149, 21150, 21413, 21414, 21415, 21416, 21417, 21418, 21419, 21420, 21421, 21422, 21423, 21473, 21474, 21475, 21476, 21477, 21478, 21479, 21480, 21481, 21482, 21483, 21500, 21790, 21817, 21818, 21891, 21892, 21893, 21894, 22032, 22033, 22191, 22192, 22193, 22194, 22195, 22196, 22197, 22332, 22391, 22392, 22523, 22524, 22832, 22992, 22993, 22994, 23028, 23029, 23030, 23031, 23032, 23033, 23034, 23035, 23036, 23037, 23038, 23239, 23240, 23433, 23846, 23847, 23848, 23849, 23850, 23851, 23852, 23853, 23886, 23887, 23888, 23889, 23890, 23891, 23892, 23893, 23894, 23947, 23948, 24047, 24048, 24100, 24200, 24370, 24371, 24372, 24373, 24374, 24382, 24383, 24384, 24500, 24547, 24548, 24720, 24721, 24818, 24819, 24820, 24821, 24877, 24878, 24879, 24880, 24891, 24892, 24893, 25000, 25231, 25391, 25392, 25393, 25394, 25395, 25700, 25932, 26191, 26192, 26193, 26237, 26331, 26332, 26391, 26392, 26393, 26432, 26591, 26592, 26632, 26692, 26703, 26704, 26705, 26706, 26707, 26708, 26709, 26710, 26711, 26712, 26713, 26714, 26715, 26716, 26717, 26718, 26719, 26720, 26721, 26722, 26729, 26730, 26731, 26732, 26733, 26734, 26735, 26736, 26737, 26738, 26739, 26740, 26741, 26742, 26743, 26744, 26745, 26746, 26747, 26748, 26749, 26750, 26751, 26752, 26753, 26754, 26755, 26756, 26757, 26758, 26759, 26760, 26761, 26762, 26763, 26764, 26765, 26766, 26767, 26768, 26769, 26770, 26771, 26772, 26773, 26774, 26774, 26775, 26775, 26776, 26776, 26777, 26777, 26778, 26779, 26780, 26781, 26782, 26783, 26784, 26785, 26786, 26787, 26788, 26789, 26790, 26791, 26792, 26793, 26794, 26795, 26796, 26797, 26798, 26801, 26802, 26803, 26903, 26904, 26905, 26906, 26907, 26908, 26909, 26910, 26911, 26912, 26913, 26914, 26915, 26916, 26917, 26918, 26919, 26920, 26921, 26922, 26923, 26929, 26930, 26931, 26932, 26933, 26934, 26935, 26936, 26937, 26938, 26939, 26940, 26941, 26942, 26943, 26944, 26945, 26946, 26948, 26949, 26950, 26951, 26952, 26953, 26954, 26955, 26956, 26957, 26958, 26959, 26960, 26961, 26962, 26963, 26964, 26965, 26966, 26967, 26968, 26969, 26970, 26971, 26972, 26973, 26974, 26975, 26976, 26977, 26978, 26979, 26980, 26981, 26982, 26983, 26984, 26985, 26986, 26987, 26988, 26989, 26990, 26991, 26992, 26993, 26994, 26995, 26996, 26997, 26998, 27038, 27039, 27040, 27120, 27200, 27291, 27292, 27429, 27500, 27581, 27582, 27583, 27591, 27592, 27593, 27700, 28232, 28348, 28349, 28350, 28351, 28352, 28353, 28354, 28355, 28356, 28357, 28358, 28404, 28405, 28406, 28407, 28408, 28409, 28410, 28411, 28412, 28413, 28414, 28415, 28416, 28417, 28418, 28419, 28420, 28421, 28422, 28423, 28424, 28425, 28426, 28427, 28428, 28429, 28430, 28431, 28432, 28464, 28465, 28466, 28467, 28468, 28469, 28470, 28471, 28472, 28473, 28474, 28475, 28476, 28477, 28478, 28479, 28480, 28481, 28482, 28483, 28484, 28485, 28486, 28487, 28488, 28489, 28490, 28491, 28492, 28600, 28991, 28992, 29118, 29119, 29120, 29121, 29122, 29177, 29178, 29179, 29180, 29181, 29182, 29183, 29184, 29185, 29220, 29221, 29333, 29635, 29636, 29700, 29738, 29739, 29800, 29849, 29850, 29900, 30200, 30339, 30340, 30491, 30492, 30591, 30592, 30600, 30729, 30730, 30731, 30732, 31028, 31121, 31291, 31292, 31293, 31300, 31491, 31492, 31493, 31494, 31495, 32001, 32002, 32003, 32005, 32006, 32007, 32008, 32009, 32010, 32011, 32012, 32013, 32014, 32015, 32016, 32017, 32018, 32019, 32020, 32021, 32022, 32023, 32024, 32025, 32026, 32027, 32028, 32029, 32030, 32031, 32033, 32034, 32035, 32036, 32037, 32038, 32039, 32040, 32041, 32042, 32043, 32044, 32045, 32046, 32047, 32048, 32049, 32050, 32051, 32052, 32053, 32054, 32055, 32056, 32057, 32058, 32059, 32060, 32100, 32104, 32107, 32108, 32109, 32110, 32111, 32112, 32113, 32114, 32115, 32116, 32117, 32118, 32119, 32120, 32121, 32122, 32123, 32124, 32125, 32126, 32127, 32128, 32129, 32130, 32133, 32134, 32135, 32136, 32137, 32138, 32139, 32140, 32141, 32142, 32143, 32144, 32145, 32146, 32147, 32148, 32149, 32150, 32151, 32152, 32153, 32154, 32155, 32156, 32157, 32158, 32161, 32201, 32202, 32203, 32204, 32205, 32206, 32207, 32208, 32209, 32210, 32211, 32212, 32213, 32214, 32215, 32216, 32217, 32218, 32219, 32220, 32221, 32222, 32223, 32224, 32225, 32226, 32227, 32228, 32229, 32230, 32231, 32232, 32233, 32234, 32235, 32236, 32237, 32238, 32239, 32240, 32241, 32242, 32243, 32244, 32245, 32246, 32247, 32248, 32249, 32250, 32251, 32252, 32253, 32254, 32255, 32256, 32257, 32258, 32259, 32260, 32301, 32302, 32303, 32304, 32305, 32306, 32307, 32308, 32309, 32310, 32311, 32312, 32313, 32314, 32315, 32316, 32317, 32318, 32319, 32320, 32321, 32322, 32323, 32324, 32325, 32326, 32327, 32328, 32329, 32330, 32331, 32332, 32333, 32334, 32335, 32336, 32337, 32338, 32339, 32340, 32341, 32342, 32343, 32344, 32345, 32346, 32347, 32348, 32349, 32350, 32351, 32352, 32353, 32354, 32355, 32356, 32357, 32358, 32359, 32360, 32401, 32402, 32403, 32404, 32405, 32406, 32407, 32408, 32409, 32410, 32411, 32412, 32413, 32414, 32415, 32416, 32417, 32418, 32419, 32420, 32421, 32422, 32423, 32424, 32425, 32426, 32427, 32428, 32429, 32430, 32431, 32432, 32433, 32434, 32435, 32436, 32437, 32438, 32439, 32440, 32441, 32442, 32443, 32444, 32445, 32446, 32447, 32448, 32449, 32450, 32451, 32452, 32453, 32454, 32455, 32456, 32457, 32458, 32459, 32460, 32501, 32502, 32503, 32504, 32505, 32506, 32507, 32508, 32509, 32510, 32511, 32512, 32513, 32514, 32515, 32516, 32517, 32518, 32519, 32520, 32521, 32522, 32523, 32524, 32525, 32526, 32527, 32528, 32529, 32530, 32531, 32532, 32533, 32534, 32535, 32536, 32537, 32538, 32539, 32540, 32541, 32542, 32543, 32544, 32545, 32546, 32547, 32548, 32549, 32550, 32551, 32552, 32553, 32554, 32555, 32556, 32557, 32558, 32559, 32560, 32601, 32602, 32603, 32604, 32605, 32606, 32607, 32608, 32609, 32610, 32611, 32612, 32613, 32614, 32615, 32616, 32617, 32618, 32619, 32620, 32621, 32622, 32623, 32624, 32625, 32626, 32627, 32628, 32629, 32630, 32631, 32632, 32633, 32634, 32635, 32636, 32637, 32638, 32639, 32640, 32641, 32642, 32643, 32644, 32645, 32646, 32647, 32648, 32649, 32650, 32651, 32652, 32653, 32654, 32655, 32656, 32657, 32658, 32659, 32660, 32701, 32702, 32703, 32704, 32705, 32706, 32707, 32708, 32709, 32710, 32711, 32712, 32713, 32714, 32715, 32716, 32717, 32718, 32719, 32720, 32721, 32722, 32723, 32724, 32725, 32726, 32727, 32728, 32729, 32730, 32731, 32732, 32733, 32734, 32735, 32736, 32737, 32738, 32739, 32740, 32741, 32742, 32743, 32744, 32745, 32746, 32747, 32748, 32749, 32750, 32751, 32752, 32753, 32754, 32755, 32756, 32757, 32758, 32759, 32760, Short.MAX_VALUE};
    public static final String[] PROJECTEDCSTYPE = new String[]{"Undefined", "Adindan UTM zone 37N", "Adindan UTM zone 38N", "AGD66 AMG zone 48", "AGD66 AMG zone 49", "AGD66 AMG zone 50", "AGD66 AMG zone 51", "AGD66 AMG zone 52", "AGD66 AMG zone 53", "AGD66 AMG zone 54", "AGD66 AMG zone 55", "AGD66 AMG zone 56", "AGD66 AMG zone 57", "AGD66 AMG zone 58", "AGD84 AMG zone 48", "AGD84 AMG zone 49", "AGD84 AMG zone 50", "AGD84 AMG zone 51", "AGD84 AMG zone 52", "AGD84 AMG zone 53", "AGD84 AMG zone 54", "AGD84 AMG zone 55", "AGD84 AMG zone 56", "AGD84 AMG zone 57", "AGD84 AMG zone 58", "Ain el Abd UTM zone 37N", "Ain el Abd UTM zone 38N", "Ain el Abd UTM zone 39N", "Ain el Abd Bahrain Grid", "Afgooye UTM zone 38N", "Afgooye UTM zone 39N", "Lisbon Portugese Grid", "Aratu UTM zone 22S", "Aratu UTM zone 23S", "Aratu UTM zone 24S", "Arc 1950 Lo13", "Arc 1950 Lo15", "Arc 1950 Lo17", "Arc 1950 Lo19", "Arc 1950 Lo21", "Arc 1950 Lo23", "Arc 1950 Lo25", "Arc 1950 Lo27", "Arc 1950 Lo29", "Arc 1950 Lo31", "Arc 1950 Lo33", "Arc 1950 Lo35", "Batavia NEIEZ", "Batavia UTM zone 48S", "Batavia UTM zone 49S", "Batavia UTM zone 50S", "Beijing Gauss zone 13", "Beijing Gauss zone 14", "Beijing Gauss zone 15", "Beijing Gauss zone 16", "Beijing Gauss zone 17", "Beijing Gauss zone 18", "Beijing Gauss zone 19", "Beijing Gauss zone 20", "Beijing Gauss zone 21", "Beijing Gauss zone 22", "Beijing Gauss zone 23", "Beijing Gauss 13N", "Beijing Gauss 14N", "Beijing Gauss 15N", "Beijing Gauss 16N", "Beijing Gauss 17N", "Beijing Gauss 18N", "Beijing Gauss 19N", "Beijing Gauss 20N", "Beijing Gauss 21N", "Beijing Gauss 22N", "Beijing Gauss 23N", "Belge Lambert 50", "Bern 1898 Swiss Old", "Bogota UTM zone 17N", "Bogota UTM zone 18N", "Bogota Colombia 3W", "Bogota Colombia Bogota", "Bogota Colombia 3E", "Bogota Colombia 6E", "Camacupa UTM 32S", "Camacupa UTM 33S", "C Inchauspe Argentina 1", "C Inchauspe Argentina 2", "C Inchauspe Argentina 3", "C Inchauspe Argentina 4", "C Inchauspe Argentina 5", "C Inchauspe Argentina 6", "C Inchauspe Argentina 7", "Carthage UTM zone 32N", "Carthage Nord Tunisie", "Carthage Sud Tunisie", "Corrego Alegre UTM 23S", "Corrego Alegre UTM 24S", "Douala UTM zone 32N", "Egypt 1907 red belt", "Egypt 1907 purple belt", "Egypt 1907 ext purple", "ED50 UTM zone 28N", "ED50 UTM zone 29N", "ED50 UTM zone 30N", "ED50 UTM zone 31N", "ED50 UTM zone 32N", "ED50 UTM zone 33N", "ED50 UTM zone 34N", "ED50 UTM zone 35N", "ED50 UTM zone 36N", "ED50 UTM zone 37N", "ED50 UTM zone 38N", "Fahud UTM zone 39N", "Fahud UTM zone 40N", "Garoua UTM zone 33N", "ID74 UTM zone 46N", "ID74 UTM zone 47N", "ID74 UTM zone 48N", "ID74 UTM zone 49N", "ID74 UTM zone 50N", "ID74 UTM zone 51N", "ID74 UTM zone 52N", "ID74 UTM zone 53N", "ID74 UTM zone 46S", "ID74 UTM zone 47S", "ID74 UTM zone 48S", "ID74 UTM zone 49S", "ID74 UTM zone 50S", "ID74 UTM zone 51S", "ID74 UTM zone 52S", "ID74 UTM zone 53S", "ID74 UTM zone 54S", "Indian 1954 UTM 47N", "Indian 1954 UTM 48N", "Indian 1975 UTM 47N", "Indian 1975 UTM 48N", "Jamaica 1875 old grid", "JAD69 Jamaica grid", "Kalianpur India 0", "Kalianpur India I", "Kalianpur India IIa", "Kalianpur India IIIa", "Kalianpur India IVa", "Kalianpur India IIb", "Kalianpur India IIIb", "Kalianpur India IVb", "Kertau Singapore grid", "Kertau UTM zone 47N", "Kertau UTM zone 48N", "La Canoa UTM zone 20N", "La Canoa UTM zone 21N", "PSAD56 UTM zone 18N", "PSAD56 UTM zone 19N", "PSAD56 UTM zone 20N", "PSAD56 UTM zone 21N", "PSAD56 UTM zone 17S", "PSAD56 UTM zone 18S", "PSAD56 UTM zone 19S", "PSAD56 UTM zone 20S", "PSAD56 Peru west zone", "PSAD56 Peru central", "PSAD56 Peru east zone", "Leigon Ghana grid", "Lome UTM zone 31N", "Luzon Philippines I", "Luzon Philippines II", "Luzon Philippines III", "Luzon Philippines IV", "Luzon Philippines V", "Makassar NEIEZ", "Malongo 1987 UTM 32S", "Merchich Nord Maroc", "Merchich Sud Maroc", "Merchich Sahara", "Massawa UTM zone 37N", "Minna UTM zone 31N", "Minna UTM zone 32N", "Minna Nigeria west", "Minna Nigeria mid belt", "Minna Nigeria east", "Mhast UTM zone 32S", "Monte Mario Italy 1", "Monte Mario Italy 2", "M poraloko UTM 32N", "M poraloko UTM 32S", "NAD27 UTM zone 3N", "NAD27 UTM zone 4N", "NAD27 UTM zone 5N", "NAD27 UTM zone 6N", "NAD27 UTM zone 7N", "NAD27 UTM zone 8N", "NAD27 UTM zone 9N", "NAD27 UTM zone 10N", "NAD27 UTM zone 11N", "NAD27 UTM zone 12N", "NAD27 UTM zone 13N", "NAD27 UTM zone 14N", "NAD27 UTM zone 15N", "NAD27 UTM zone 16N", "NAD27 UTM zone 17N", "NAD27 UTM zone 18N", "NAD27 UTM zone 19N", "NAD27 UTM zone 20N", "NAD27 UTM zone 21N", "NAD27 UTM zone 22N", "NAD27 Alabama east", "NAD27 Alabama west", "NAD27 Alaska zone 1", "NAD27 Alaska zone 2", "NAD27 Alaska zone 3", "NAD27 Alaska zone 4", "NAD27 Alaska zone 5", "NAD27 Alaska zone 6", "NAD27 Alaska zone 7", "NAD27 Alaska zone 8", "NAD27 Alaska zone 9", "NAD27 Alaska zone 10", "NAD27 California I", "NAD27 California II", "NAD27 California III", "NAD27 California IV", "NAD27 California V", "NAD27 California VI", "NAD27 California VII", "NAD27 Arizona east", "NAD27 Arizona central", "NAD27 Arizona west", "NAD27 Arkansas north", "NAD27 Arkansas south", "NAD27 Colorado north", "NAD27 Colorado central", "NAD27 Colorado south", "NAD27 Connecticut", "NAD27 Delaware", "NAD27 Florida east", "NAD27 Florida west", "NAD27 Florida north", "NAD27 Hawaii zone 1", "NAD27 Hawaii zone 2", "NAD27 Hawaii zone 3", "NAD27 Hawaii zone 4", "NAD27 Hawaii zone 5", "NAD27 Georgia east", "NAD27 Georgia west", "NAD27 Idaho east", "NAD27 Idaho central", "NAD27 Idaho west", "NAD27 Illinois east", "NAD27 Illinois west", "NAD27 Indiana east", "NAD27 BLM 14N feet", "NAD27 Indiana west", "NAD27 BLM 15N feet", "NAD27 Iowa north", "NAD27 BLM 16N feet", "NAD27 Iowa south", "NAD27 BLM 17N feet", "NAD27 Kansas north", "NAD27 Kansas south", "NAD27 Kentucky north", "NAD27 Kentucky south", "NAD27 Louisiana north", "NAD27 Louisiana south", "NAD27 Maine east", "NAD27 Maine west", "NAD27 Maryland", "NAD27 Massachusetts", "NAD27 Massachusetts Is", "NAD27 Michigan north", "NAD27 Michigan central", "NAD27 Michigan south", "NAD27 Minnesota north", "NAD27 Minnesota Cent", "NAD27 Minnesota south", "NAD27 Mississippi east", "NAD27 Mississippi west", "NAD27 Missouri east", "NAD27 Missouri central", "NAD27 Missouri west", "NAD Michigan Michigan east", "NAD Michigan Michigan old central", "NAD Michigan Michigan west", "NAD83 UTM zone 3N", "NAD83 UTM zone 4N", "NAD83 UTM zone 5N", "NAD83 UTM zone 6N", "NAD83 UTM zone 7N", "NAD83 UTM zone 8N", "NAD83 UTM zone 9N", "NAD83 UTM zone 10N", "NAD83 UTM zone 11N", "NAD83 UTM zone 12N", "NAD83 UTM zone 13N", "NAD83 UTM zone 14N", "NAD83 UTM zone 15N", "NAD83 UTM zone 16N", "NAD83 UTM zone 17N", "NAD83 UTM zone 18N", "NAD83 UTM zone 19N", "NAD83 UTM zone 20N", "NAD83 UTM zone 21N", "NAD83 UTM zone 22N", "NAD83 UTM zone 23N", "NAD83 Alabama east", "NAD83 Alabama west", "NAD83 Alaska zone 1", "NAD83 Alaska zone 2", "NAD83 Alaska zone 3", "NAD83 Alaska zone 4", "NAD83 Alaska zone 5", "NAD83 Alaska zone 6", "NAD83 Alaska zone 7", "NAD83 Alaska zone 8", "NAD83 Alaska zone 9", "NAD83 Alaska zone 10", "NAD83 California 1", "NAD83 California 2", "NAD83 California 3", "NAD83 California 4", "NAD83 California 5", "NAD83 California 6", "NAD83 Arizona east", "NAD83 Arizona central", "NAD83 Arizona west", "NAD83 Arkansas north", "NAD83 Arkansas south", "NAD83 Colorado north", "NAD83 Colorado central", "NAD83 Colorado south", "NAD83 Connecticut", "NAD83 Delaware", "NAD83 Florida east", "NAD83 Florida west", "NAD83 Florida north", "NAD83 Hawaii zone 1", "NAD83 Hawaii zone 2", "NAD83 Hawaii zone 3", "NAD83 Hawaii zone 4", "NAD83 Hawaii zone 5", "NAD83 Georgia east", "NAD83 Georgia west", "NAD83 Idaho east", "NAD83 Idaho central", "NAD83 Idaho west", "NAD83 Illinois east", "NAD83 Illinois west", "NAD83 Indiana east", "NAD83 Indiana west", "NAD83 Iowa north", "NAD83 Iowa south", "NAD83 Kansas north", "NAD83 Kansas south", "NAD83 Kentucky north", "NAD83 Kentucky south", "NAD83 Louisiana north", "NAD83 Louisiana south", "NAD83 Maine east", "NAD83 Maine west", "NAD83 Maryland", "NAD83 Massachusetts", "NAD83 Massachusetts Is", "NAD83 Michigan north", "NAD83 Michigan central", "NAD83 Michigan south", "NAD83 Minnesota north", "NAD83 Minnesota central", "NAD83 Minnesota south", "NAD83 Mississippi east", "NAD83 Mississippi west", "NAD83 Missouri east", "NAD83 Missouri central", "NAD83 Missouri west", "Nahrwan 1967 UTM 38N", "Nahrwan 1967 UTM 39N", "Nahrwan 1967 UTM 40N", "Naparima UTM 20N", "GD49 NZ Map Grid", "GD49 north Island Grid", "GD49 south Island Grid", "Datum 73 UTM zone 29N", "ATF Nord de Guerre", "NTF France I", "NTF France II", "NTF France III", "NTF Nord France", "NTF Centre France", "NTF Sud France", "British National Grid", "Point Noire UTM 32S", "GDA94 MGA zone 48", "GDA94 MGA zone 49", "GDA94 MGA zone 50", "GDA94 MGA zone 51", "GDA94 MGA zone 52", "GDA94 MGA zone 53", "GDA94 MGA zone 54", "GDA94 MGA zone 55", "GDA94 MGA zone 56", "GDA94 MGA zone 57", "GDA94 MGA zone 58", "Pulkovo Gauss zone 4", "Pulkovo Gauss zone 5", "Pulkovo Gauss zone 6", "Pulkovo Gauss zone 7", "Pulkovo Gauss zone 8", "Pulkovo Gauss zone 9", "Pulkovo Gauss zone 10", "Pulkovo Gauss zone 11", "Pulkovo Gauss zone 12", "Pulkovo Gauss zone 13", "Pulkovo Gauss zone 14", "Pulkovo Gauss zone 15", "Pulkovo Gauss zone 16", "Pulkovo Gauss zone 17", "Pulkovo Gauss zone 18", "Pulkovo Gauss zone 19", "Pulkovo Gauss zone 20", "Pulkovo Gauss zone 21", "Pulkovo Gauss zone 22", "Pulkovo Gauss zone 23", "Pulkovo Gauss zone 24", "Pulkovo Gauss zone 25", "Pulkovo Gauss zone 26", "Pulkovo Gauss zone 27", "Pulkovo Gauss zone 28", "Pulkovo Gauss zone 29", "Pulkovo Gauss zone 30", "Pulkovo Gauss zone 31", "Pulkovo Gauss zone 32", "Pulkovo Gauss 4N", "Pulkovo Gauss 5N", "Pulkovo Gauss 6N", "Pulkovo Gauss 7N", "Pulkovo Gauss 8N", "Pulkovo Gauss 9N", "Pulkovo Gauss 10N", "Pulkovo Gauss 11N", "Pulkovo Gauss 12N", "Pulkovo Gauss 13N", "Pulkovo Gauss 14N", "Pulkovo Gauss 15N", "Pulkovo Gauss 16N", "Pulkovo Gauss 17N", "Pulkovo Gauss 18N", "Pulkovo Gauss 19N", "Pulkovo Gauss 20N", "Pulkovo Gauss 21N", "Pulkovo Gauss 22N", "Pulkovo Gauss 23N", "Pulkovo Gauss 24N", "Pulkovo Gauss 25N", "Pulkovo Gauss 26N", "Pulkovo Gauss 27N", "Pulkovo Gauss 28N", "Pulkovo Gauss 29N", "Pulkovo Gauss 30N", "Pulkovo Gauss 31N", "Pulkovo Gauss 32N", "Qatar National Grid", "RD Netherlands Old", "RD Netherlands New", "SAD69 UTM zone 18N", "SAD69 UTM zone 19N", "SAD69 UTM zone 20N", "SAD69 UTM zone 21N", "SAD69 UTM zone 22N", "SAD69 UTM zone 17S", "SAD69 UTM zone 18S", "SAD69 UTM zone 19S", "SAD69 UTM zone 20S", "SAD69 UTM zone 21S", "SAD69 UTM zone 22S", "SAD69 UTM zone 23S", "SAD69 UTM zone 24S", "SAD69 UTM zone 25S", "Sapper Hill UTM 20S", "Sapper Hill UTM 21S", "Schwarzeck UTM 33S", "Sudan UTM zone 35N", "Sudan UTM zone 36N", "Tananarive Laborde", "Tananarive UTM 38S", "Tananarive UTM 39S", "Timbalai 1948 Borneo", "Timbalai 1948 UTM 49N", "Timbalai 1948 UTM 50N", "TM65 Irish Nat Grid", "Trinidad 1903 Trinidad", "TC 1948 UTM zone 39N", "TC 1948 UTM zone 40N", "Voirol N Algerie ancien", "Voirol S Algerie ancien", "Voirol Unifie N Algerie", "Voirol Unifie S Algerie", "Bern 1938 Swiss New", "Nord Sahara UTM 29N", "Nord Sahara UTM 30N", "Nord Sahara UTM 31N", "Nord Sahara UTM 32N", "Yoff UTM zone 28N", "Zanderij UTM zone 21N", "MGI Austria west", "MGI Austria central", "MGI Austria east", "Belge Lambert 72", "DHDN Germany zone 1", "DHDN Germany zone 2", "DHDN Germany zone 3", "DHDN Germany zone 4", "DHDN Germany zone 5", "NAD27 Montana north", "NAD27 Montana central", "NAD27 Montana south", "NAD27 Nebraska north", "NAD27 Nebraska south", "NAD27 Nevada east", "NAD27 Nevada central", "NAD27 Nevada west", "NAD27 New Hampshire", "NAD27 New Jersey", "NAD27 New Mexico east", "NAD27 New Mexico Cent", "NAD27 New Mexico west", "NAD27 New York east", "NAD27 New York central", "NAD27 New York west", "NAD27 New York Long Is", "NAD27 north Carolina", "NAD27 north Dakota N", "NAD27 north Dakota S", "NAD27 Ohio north", "NAD27 Ohio south", "NAD27 Oklahoma north", "NAD27 Oklahoma south", "NAD27 Oregon north", "NAD27 Oregon south", "NAD27 Pennsylvania N", "NAD27 Pennsylvania S", "NAD27 Rhode Island", "NAD27 south Carolina N", "NAD27 south Carolina S", "NAD27 south Dakota N", "NAD27 south Dakota S", "NAD27 Tennessee", "NAD27 Texas north", "NAD27 Texas north Cen", "NAD27 Texas central", "NAD27 Texas south Cen", "NAD27 Texas south", "NAD27 Utah north", "NAD27 Utah central", "NAD27 Utah south", "NAD27 Vermont", "NAD27 Virginia north", "NAD27 Virginia south", "NAD27 Washington north", "NAD27 Washington south", "NAD27 west Virginia N", "NAD27 west Virginia S", "NAD27 Wisconsin north", "NAD27 Wisconsin central", "NAD27 Wisconsin south", "NAD27 Wyoming east", "NAD27 Wyoming E central", "NAD27 Wyoming W central", "NAD27 Wyoming west", "NAD27 Puerto Rico", "NAD27 St Croix", "NAD83 Montana", "NAD83 Nebraska", "NAD83 Nevada east", "NAD83 Nevada central", "NAD83 Nevada west", "NAD83 New Hampshire", "NAD83 New Jersey", "NAD83 New Mexico east", "NAD83 New Mexico central", "NAD83 New Mexico west", "NAD83 New York east", "NAD83 New York central", "NAD83 New York west", "NAD83 New York Long Is", "NAD83 north Carolina", "NAD83 north Dakota N", "NAD83 north Dakota S", "NAD83 Ohio north", "NAD83 Ohio south", "NAD83 Oklahoma north", "NAD83 Oklahoma south", "NAD83 Oregon north", "NAD83 Oregon south", "NAD83 Pennsylvania N", "NAD83 Pennsylvania S", "NAD83 Rhode Island", "NAD83 south Carolina", "NAD83 south Dakota N", "NAD83 south Dakota S", "NAD83 Tennessee", "NAD83 Texas north", "NAD83 Texas north Cen", "NAD83 Texas central", "NAD83 Texas south Cen", "NAD83 Texas south", "NAD83 Utah north", "NAD83 Utah central", "NAD83 Utah south", "NAD83 Vermont", "NAD83 Virginia north", "NAD83 Virginia south", "NAD83 Washington north", "NAD83 Washington south", "NAD83 west Virginia N", "NAD83 west Virginia S", "NAD83 Wisconsin north", "NAD83 Wisconsin Cen", "NAD83 Wisconsin south", "NAD83 Wyoming east", "NAD83 Wyoming E Cen", "NAD83 Wyoming W Cen", "NAD83 Wyoming west", "NAD83 Puerto Rico Virgin Is", "WGS72 UTM zone 1N", "WGS72 UTM zone 2N", "WGS72 UTM zone 3N", "WGS72 UTM zone 4N", "WGS72 UTM zone 5N", "WGS72 UTM zone 6N", "WGS72 UTM zone 7N", "WGS72 UTM zone 8N", "WGS72 UTM zone 9N", "WGS72 UTM zone 10N", "WGS72 UTM zone 11N", "WGS72 UTM zone 12N", "WGS72 UTM zone 13N", "WGS72 UTM zone 14N", "WGS72 UTM zone 15N", "WGS72 UTM zone 16N", "WGS72 UTM zone 17N", "WGS72 UTM zone 18N", "WGS72 UTM zone 19N", "WGS72 UTM zone 20N", "WGS72 UTM zone 21N", "WGS72 UTM zone 22N", "WGS72 UTM zone 23N", "WGS72 UTM zone 24N", "WGS72 UTM zone 25N", "WGS72 UTM zone 26N", "WGS72 UTM zone 27N", "WGS72 UTM zone 28N", "WGS72 UTM zone 29N", "WGS72 UTM zone 30N", "WGS72 UTM zone 31N", "WGS72 UTM zone 32N", "WGS72 UTM zone 33N", "WGS72 UTM zone 34N", "WGS72 UTM zone 35N", "WGS72 UTM zone 36N", "WGS72 UTM zone 37N", "WGS72 UTM zone 38N", "WGS72 UTM zone 39N", "WGS72 UTM zone 40N", "WGS72 UTM zone 41N", "WGS72 UTM zone 42N", "WGS72 UTM zone 43N", "WGS72 UTM zone 44N", "WGS72 UTM zone 45N", "WGS72 UTM zone 46N", "WGS72 UTM zone 47N", "WGS72 UTM zone 48N", "WGS72 UTM zone 49N", "WGS72 UTM zone 50N", "WGS72 UTM zone 51N", "WGS72 UTM zone 52N", "WGS72 UTM zone 53N", "WGS72 UTM zone 54N", "WGS72 UTM zone 55N", "WGS72 UTM zone 56N", "WGS72 UTM zone 57N", "WGS72 UTM zone 58N", "WGS72 UTM zone 59N", "WGS72 UTM zone 60N", "WGS72 UTM zone 1S", "WGS72 UTM zone 2S", "WGS72 UTM zone 3S", "WGS72 UTM zone 4S", "WGS72 UTM zone 5S", "WGS72 UTM zone 6S", "WGS72 UTM zone 7S", "WGS72 UTM zone 8S", "WGS72 UTM zone 9S", "WGS72 UTM zone 10S", "WGS72 UTM zone 11S", "WGS72 UTM zone 12S", "WGS72 UTM zone 13S", "WGS72 UTM zone 14S", "WGS72 UTM zone 15S", "WGS72 UTM zone 16S", "WGS72 UTM zone 17S", "WGS72 UTM zone 18S", "WGS72 UTM zone 19S", "WGS72 UTM zone 20S", "WGS72 UTM zone 21S", "WGS72 UTM zone 22S", "WGS72 UTM zone 23S", "WGS72 UTM zone 24S", "WGS72 UTM zone 25S", "WGS72 UTM zone 26S", "WGS72 UTM zone 27S", "WGS72 UTM zone 28S", "WGS72 UTM zone 29S", "WGS72 UTM zone 30S", "WGS72 UTM zone 31S", "WGS72 UTM zone 32S", "WGS72 UTM zone 33S", "WGS72 UTM zone 34S", "WGS72 UTM zone 35S", "WGS72 UTM zone 36S", "WGS72 UTM zone 37S", "WGS72 UTM zone 38S", "WGS72 UTM zone 39S", "WGS72 UTM zone 40S", "WGS72 UTM zone 41S", "WGS72 UTM zone 42S", "WGS72 UTM zone 43S", "WGS72 UTM zone 44S", "WGS72 UTM zone 45S", "WGS72 UTM zone 46S", "WGS72 UTM zone 47S", "WGS72 UTM zone 48S", "WGS72 UTM zone 49S", "WGS72 UTM zone 50S", "WGS72 UTM zone 51S", "WGS72 UTM zone 52S", "WGS72 UTM zone 53S", "WGS72 UTM zone 54S", "WGS72 UTM zone 55S", "WGS72 UTM zone 56S", "WGS72 UTM zone 57S", "WGS72 UTM zone 58S", "WGS72 UTM zone 59S", "WGS72 UTM zone 60S", "WGS72BE UTM zone 1N", "WGS72BE UTM zone 2N", "WGS72BE UTM zone 3N", "WGS72BE UTM zone 4N", "WGS72BE UTM zone 5N", "WGS72BE UTM zone 6N", "WGS72BE UTM zone 7N", "WGS72BE UTM zone 8N", "WGS72BE UTM zone 9N", "WGS72BE UTM zone 10N", "WGS72BE UTM zone 11N", "WGS72BE UTM zone 12N", "WGS72BE UTM zone 13N", "WGS72BE UTM zone 14N", "WGS72BE UTM zone 15N", "WGS72BE UTM zone 16N", "WGS72BE UTM zone 17N", "WGS72BE UTM zone 18N", "WGS72BE UTM zone 19N", "WGS72BE UTM zone 20N", "WGS72BE UTM zone 21N", "WGS72BE UTM zone 22N", "WGS72BE UTM zone 23N", "WGS72BE UTM zone 24N", "WGS72BE UTM zone 25N", "WGS72BE UTM zone 26N", "WGS72BE UTM zone 27N", "WGS72BE UTM zone 28N", "WGS72BE UTM zone 29N", "WGS72BE UTM zone 30N", "WGS72BE UTM zone 31N", "WGS72BE UTM zone 32N", "WGS72BE UTM zone 33N", "WGS72BE UTM zone 34N", "WGS72BE UTM zone 35N", "WGS72BE UTM zone 36N", "WGS72BE UTM zone 37N", "WGS72BE UTM zone 38N", "WGS72BE UTM zone 39N", "WGS72BE UTM zone 40N", "WGS72BE UTM zone 41N", "WGS72BE UTM zone 42N", "WGS72BE UTM zone 43N", "WGS72BE UTM zone 44N", "WGS72BE UTM zone 45N", "WGS72BE UTM zone 46N", "WGS72BE UTM zone 47N", "WGS72BE UTM zone 48N", "WGS72BE UTM zone 49N", "WGS72BE UTM zone 50N", "WGS72BE UTM zone 51N", "WGS72BE UTM zone 52N", "WGS72BE UTM zone 53N", "WGS72BE UTM zone 54N", "WGS72BE UTM zone 55N", "WGS72BE UTM zone 56N", "WGS72BE UTM zone 57N", "WGS72BE UTM zone 58N", "WGS72BE UTM zone 59N", "WGS72BE UTM zone 60N", "WGS72BE UTM zone 1S", "WGS72BE UTM zone 2S", "WGS72BE UTM zone 3S", "WGS72BE UTM zone 4S", "WGS72BE UTM zone 5S", "WGS72BE UTM zone 6S", "WGS72BE UTM zone 7S", "WGS72BE UTM zone 8S", "WGS72BE UTM zone 9S", "WGS72BE UTM zone 10S", "WGS72BE UTM zone 11S", "WGS72BE UTM zone 12S", "WGS72BE UTM zone 13S", "WGS72BE UTM zone 14S", "WGS72BE UTM zone 15S", "WGS72BE UTM zone 16S", "WGS72BE UTM zone 17S", "WGS72BE UTM zone 18S", "WGS72BE UTM zone 19S", "WGS72BE UTM zone 20S", "WGS72BE UTM zone 21S", "WGS72BE UTM zone 22S", "WGS72BE UTM zone 23S", "WGS72BE UTM zone 24S", "WGS72BE UTM zone 25S", "WGS72BE UTM zone 26S", "WGS72BE UTM zone 27S", "WGS72BE UTM zone 28S", "WGS72BE UTM zone 29S", "WGS72BE UTM zone 30S", "WGS72BE UTM zone 31S", "WGS72BE UTM zone 32S", "WGS72BE UTM zone 33S", "WGS72BE UTM zone 34S", "WGS72BE UTM zone 35S", "WGS72BE UTM zone 36S", "WGS72BE UTM zone 37S", "WGS72BE UTM zone 38S", "WGS72BE UTM zone 39S", "WGS72BE UTM zone 40S", "WGS72BE UTM zone 41S", "WGS72BE UTM zone 42S", "WGS72BE UTM zone 43S", "WGS72BE UTM zone 44S", "WGS72BE UTM zone 45S", "WGS72BE UTM zone 46S", "WGS72BE UTM zone 47S", "WGS72BE UTM zone 48S", "WGS72BE UTM zone 49S", "WGS72BE UTM zone 50S", "WGS72BE UTM zone 51S", "WGS72BE UTM zone 52S", "WGS72BE UTM zone 53S", "WGS72BE UTM zone 54S", "WGS72BE UTM zone 55S", "WGS72BE UTM zone 56S", "WGS72BE UTM zone 57S", "WGS72BE UTM zone 58S", "WGS72BE UTM zone 59S", "WGS72BE UTM zone 60S", "WGS84 UTM zone 1N", "WGS84 UTM zone 2N", "WGS84 UTM zone 3N", "WGS84 UTM zone 4N", "WGS84 UTM zone 5N", "WGS84 UTM zone 6N", "WGS84 UTM zone 7N", "WGS84 UTM zone 8N", "WGS84 UTM zone 9N", "WGS84 UTM zone 10N", "WGS84 UTM zone 11N", "WGS84 UTM zone 12N", "WGS84 UTM zone 13N", "WGS84 UTM zone 14N", "WGS84 UTM zone 15N", "WGS84 UTM zone 16N", "WGS84 UTM zone 17N", "WGS84 UTM zone 18N", "WGS84 UTM zone 19N", "WGS84 UTM zone 20N", "WGS84 UTM zone 21N", "WGS84 UTM zone 22N", "WGS84 UTM zone 23N", "WGS84 UTM zone 24N", "WGS84 UTM zone 25N", "WGS84 UTM zone 26N", "WGS84 UTM zone 27N", "WGS84 UTM zone 28N", "WGS84 UTM zone 29N", "WGS84 UTM zone 30N", "WGS84 UTM zone 31N", "WGS84 UTM zone 32N", "WGS84 UTM zone 33N", "WGS84 UTM zone 34N", "WGS84 UTM zone 35N", "WGS84 UTM zone 36N", "WGS84 UTM zone 37N", "WGS84 UTM zone 38N", "WGS84 UTM zone 39N", "WGS84 UTM zone 40N", "WGS84 UTM zone 41N", "WGS84 UTM zone 42N", "WGS84 UTM zone 43N", "WGS84 UTM zone 44N", "WGS84 UTM zone 45N", "WGS84 UTM zone 46N", "WGS84 UTM zone 47N", "WGS84 UTM zone 48N", "WGS84 UTM zone 49N", "WGS84 UTM zone 50N", "WGS84 UTM zone 51N", "WGS84 UTM zone 52N", "WGS84 UTM zone 53N", "WGS84 UTM zone 54N", "WGS84 UTM zone 55N", "WGS84 UTM zone 56N", "WGS84 UTM zone 57N", "WGS84 UTM zone 58N", "WGS84 UTM zone 59N", "WGS84 UTM zone 60N", "WGS84 UTM zone 1S", "WGS84 UTM zone 2S", "WGS84 UTM zone 3S", "WGS84 UTM zone 4S", "WGS84 UTM zone 5S", "WGS84 UTM zone 6S", "WGS84 UTM zone 7S", "WGS84 UTM zone 8S", "WGS84 UTM zone 9S", "WGS84 UTM zone 10S", "WGS84 UTM zone 11S", "WGS84 UTM zone 12S", "WGS84 UTM zone 13S", "WGS84 UTM zone 14S", "WGS84 UTM zone 15S", "WGS84 UTM zone 16S", "WGS84 UTM zone 17S", "WGS84 UTM zone 18S", "WGS84 UTM zone 19S", "WGS84 UTM zone 20S", "WGS84 UTM zone 21S", "WGS84 UTM zone 22S", "WGS84 UTM zone 23S", "WGS84 UTM zone 24S", "WGS84 UTM zone 25S", "WGS84 UTM zone 26S", "WGS84 UTM zone 27S", "WGS84 UTM zone 28S", "WGS84 UTM zone 29S", "WGS84 UTM zone 30S", "WGS84 UTM zone 31S", "WGS84 UTM zone 32S", "WGS84 UTM zone 33S", "WGS84 UTM zone 34S", "WGS84 UTM zone 35S", "WGS84 UTM zone 36S", "WGS84 UTM zone 37S", "WGS84 UTM zone 38S", "WGS84 UTM zone 39S", "WGS84 UTM zone 40S", "WGS84 UTM zone 41S", "WGS84 UTM zone 42S", "WGS84 UTM zone 43S", "WGS84 UTM zone 44S", "WGS84 UTM zone 45S", "WGS84 UTM zone 46S", "WGS84 UTM zone 47S", "WGS84 UTM zone 48S", "WGS84 UTM zone 49S", "WGS84 UTM zone 50S", "WGS84 UTM zone 51S", "WGS84 UTM zone 52S", "WGS84 UTM zone 53S", "WGS84 UTM zone 54S", "WGS84 UTM zone 55S", "WGS84 UTM zone 56S", "WGS84 UTM zone 57S", "WGS84 UTM zone 58S", "WGS84 UTM zone 59S", "WGS84 UTM zone 60S", "User-defined"};
    public static final int[] PROJECTION_INDEX = new int[]{0, 10101, 10102, 10131, 10132, 10201, 10202, 10203, 10231, 10232, 10233, 10301, 10302, 10331, 10332, 10401, 10402, 10403, 10404, 10405, 10406, 10407, 10431, 10432, 10433, 10434, 10435, 10436, 10501, 10502, 10503, 10531, 10532, 10533, 10600, 10630, 10700, 10730, 10901, 10902, 10903, 10931, 10932, 10933, 11001, 11002, 11031, 11032, 11101, 11102, 11103, 11131, 11132, 11133, 11201, 11202, 11231, 11232, 11301, 11302, 11331, 11332, 11401, 11402, 11431, 11432, 11501, 11502, 11531, 11532, 11601, 11602, 11631, 11632, 11701, 11702, 11731, 11732, 11801, 11802, 11831, 11832, 11900, 11930, 12001, 12002, 12031, 12032, 12101, 12102, 12103, 12111, 12112, 12113, 12141, 12142, 12143, 12201, 12202, 12203, 12231, 12232, 12233, 12301, 12302, 12331, 12332, 12401, 12402, 12403, 12431, 12432, 12433, 12501, 12502, 12503, 12530, 12601, 12602, 12630, 12701, 12702, 12703, 12731, 12732, 12733, 12800, 12830, 12900, 12930, 13001, 13002, 13003, 13031, 13032, 13033, 13101, 13102, 13103, 13104, 13131, 13132, 13133, 13134, 13200, 13230, 13301, 13302, 13331, 13332, 13401, 13402, 13431, 13432, 13501, 13502, 13531, 13532, 13601, 13602, 13631, 13632, 13701, 13702, 13731, 13732, 13800, 13830, 13901, 13902, 13930, 14001, 14002, 14031, 14032, 14100, 14130, 14201, 14202, 14203, 14204, 14205, 14231, 14232, 14233, 14234, 14235, 14301, 14302, 14303, 14331, 14332, 14333, 14400, 14430, 14501, 14502, 14531, 14532, 14601, 14602, 14631, 14632, 14701, 14702, 14731, 14732, 14801, 14802, 14803, 14831, 14832, 14833, 14901, 14902, 14903, 14904, 14931, 14932, 14933, 14934, 15001, 15002, 15003, 15004, 15005, 15006, 15007, 15008, 15009, 15010, 15031, 15032, 15033, 15034, 15035, 15036, 15037, 15038, 15039, 15040, 15101, 15102, 15103, 15104, 15105, 15131, 15132, 15133, 15134, 15135, 15201, 15202, 15230, 15914, 15915, 15916, 15917, 17348, 17349, 17350, 17351, 17352, 17353, 17354, 17355, 17356, 17357, 17358, 17448, 17449, 17450, 17451, 17452, 17453, 17454, 17455, 17456, 17457, 17458, 18031, 18032, 18033, 18034, 18035, 18036, 18037, 18051, 18052, 18053, 18054, 18072, 18073, 18074, 18141, 18142, 19900, 19905, 19912, Short.MAX_VALUE};
    public static final String[] PROJECTION = new String[]{"Undefined", "Alabama CS27 east", "Alabama CS27 west", "Alabama CS83 east", "Alabama CS83 west", "Arizona coordinate system east", "Arizona coordinate system central", "Arizona coordinate system west", "Arizona CS83 east", "Arizona CS83 central", "Arizona CS83 west", "Arkansas CS27 north", "Arkansas CS27 south", "Arkansas CS83 north", "Arkansas CS83 south", "California CS27 I", "California CS27 II", "California CS27 III", "California CS27 IV", "California CS27 V", "California CS27 VI", "California CS27 VII", "California CS83 1", "California CS83 2", "California CS83 3", "California CS83 4", "California CS83 5", "California CS83 6", "Colorado CS27 north", "Colorado CS27 central", "Colorado CS27 south", "Colorado CS83 north", "Colorado CS83 central", "Colorado CS83 south", "Connecticut CS27", "Connecticut CS83", "Delaware CS27", "Delaware CS83", "Florida CS27 east", "Florida CS27 west", "Florida CS27 north", "Florida CS83 east", "Florida CS83 west", "Florida CS83 north", "Georgia CS27 east", "Georgia CS27 west", "Georgia CS83 east", "Georgia CS83 west", "Idaho CS27 east", "Idaho CS27 central", "Idaho CS27 west", "Idaho CS83 east", "Idaho CS83 central", "Idaho CS83 west", "Illinois CS27 east", "Illinois CS27 west", "Illinois CS83 east", "Illinois CS83 west", "Indiana CS27 east", "Indiana CS27 west", "Indiana CS83 east", "Indiana CS83 west", "Iowa CS27 north", "Iowa CS27 south", "Iowa CS83 north", "Iowa CS83 south", "Kansas CS27 north", "Kansas CS27 south", "Kansas CS83 north", "Kansas CS83 south", "Kentucky CS27 north", "Kentucky CS27 south", "Kentucky CS83 north", "Kentucky CS83 south", "Louisiana CS27 north", "Louisiana CS27 south", "Louisiana CS83 north", "Louisiana CS83 south", "Maine CS27 east", "Maine CS27 west", "Maine CS83 east", "Maine CS83 west", "Maryland CS27", "Maryland CS83", "Massachusetts CS27 mainland", "Massachusetts CS27 island", "Massachusetts CS83 mainland", "Massachusetts CS83 island", "Michigan state plane east", "Michigan state plane old central", "Michigan state plane west", "Michigan CS27 north", "Michigan CS27 central", "Michigan CS27 south", "Michigan CS83 north", "Michigan CS83 central", "Michigan CS83 south", "Minnesota CS27 north", "Minnesota CS27 central", "Minnesota CS27 south", "Minnesota CS83 north", "Minnesota CS83 central", "Minnesota CS83 south", "Mississippi CS27 east", "Mississippi CS27 west", "Mississippi CS83 east", "Mississippi CS83 west", "Missouri CS27 east", "Missouri CS27 central", "Missouri CS27 west", "Missouri CS83 east", "Missouri CS83 central", "Missouri CS83 west", "Montana CS27 north", "Montana CS27 central", "Montana CS27 south", "Montana CS83", "Nebraska CS27 north", "Nebraska CS27 south", "Nebraska CS83", "Nevada CS27 east", "Nevada CS27 central", "Nevada CS27 west", "Nevada CS83 east", "Nevada CS83 central", "Nevada CS83 west", "New Hampshire CS27", "New Hampshire CS83", "New Jersey CS27", "New Jersey CS83", "New Mexico CS27 east", "New Mexico CS27 central", "New Mexico CS27 west", "New Mexico CS83 east", "New Mexico CS83 central", "New Mexico CS83 west", "New York CS27 east", "New York CS27 central", "New York CS27 west", "New York CS27 Long Island", "New York CS83 east", "New York CS83 central", "New York CS83 west", "New York CS83 Long Island", "north Carolina CS27", "north Carolina CS83", "north Dakota CS27 north", "north Dakota CS27 south", "north Dakota CS83 north", "north Dakota CS83 south", "Ohio CS27 north", "Ohio CS27 south", "Ohio CS83 north", "Ohio CS83 south", "Oklahoma CS27 north", "Oklahoma CS27 south", "Oklahoma CS83 north", "Oklahoma CS83 south", "Oregon CS27 north", "Oregon CS27 south", "Oregon CS83 north", "Oregon CS83 south", "Pennsylvania CS27 north", "Pennsylvania CS27 south", "Pennsylvania CS83 north", "Pennsylvania CS83 south", "Rhode Island CS27", "Rhode Island CS83", "South Carolina CS27 north", "South Carolina CS27 south", "South Carolina CS83", "South Dakota CS27 north", "South Dakota CS27 south", "South Dakota CS83 north", "South Dakota CS83 south", "Tennessee CS27", "Tennessee CS83", "Texas CS27 north", "Texas CS27 north central", "Texas CS27 central", "Texas CS27 south central", "Texas CS27 south", "Texas CS83 north", "Texas CS83 north central", "Texas CS83 central", "Texas CS83 south central", "Texas CS83 south", "Utah CS27 north", "Utah CS27 central", "Utah CS27 south", "Utah CS83 north", "Utah CS83 central", "Utah CS83 south", "Vermont CS27", "Vermont CS83", "Virginia CS27 north", "Virginia CS27 south", "Virginia CS83 north", "Virginia CS83 south", "Washington CS27 north", "Washington CS27 south", "Washington CS83 north", "Washington CS83 south", "west Virginia CS27 north", "west Virginia CS27 south", "west Virginia CS83 north", "west Virginia CS83 south", "Wisconsin CS27 north", "Wisconsin CS27 central", "Wisconsin CS27 south", "Wisconsin CS83 north", "Wisconsin CS83 central", "Wisconsin CS83 south", "Wyoming CS27 east", "Wyoming CS27 east central", "Wyoming CS27 west central", "Wyoming CS27 west", "Wyoming CS83 east", "Wyoming CS83 east central", "Wyoming CS83 west central", "Wyoming CS83 west", "Alaska CS27 1", "Alaska CS27 2", "Alaska CS27 3", "Alaska CS27 4", "Alaska CS27 5", "Alaska CS27 6", "Alaska CS27 7", "Alaska CS27 8", "Alaska CS27 9", "Alaska CS27 10", "Alaska CS83 1", "Alaska CS83 2", "Alaska CS83 3", "Alaska CS83 4", "Alaska CS83 5", "Alaska CS83 6", "Alaska CS83 7", "Alaska CS83 8", "Alaska CS83 9", "Alaska CS83 10", "Hawaii CS27 1", "Hawaii CS27 2", "Hawaii CS27 3", "Hawaii CS27 4", "Hawaii CS27 5", "Hawaii CS83 1", "Hawaii CS83 2", "Hawaii CS83 3", "Hawaii CS83 4", "Hawaii CS83 5", "Puerto Rico CS27", "St Croix", "Puerto Rico Virgin Is", "BLM 14N feet", "BLM 15N feet", "BLM 16N feet", "BLM 17N feet", "Map grid of Australia 48", "Map grid of Australia 49", "Map grid of Australia 50", "Map grid of Australia 51", "Map grid of Australia 52", "Map grid of Australia 53", "Map grid of Australia 54", "Map grid of Australia 55", "Map grid of Australia 56", "Map grid of Australia 57", "Map grid of Australia 58", "Australian map grid 48", "Australian map grid 49", "Australian map grid 50", "Australian map grid 51", "Australian map grid 52", "Australian map grid 53", "Australian map grid 54", "Australian map grid 55", "Australian map grid 56", "Australian map grid 57", "Australian map grid 58", "Argentina 1", "Argentina 2", "Argentina 3", "Argentina 4", "Argentina 5", "Argentina 6", "Argentina 7", "Colombia 3W", "Colombia Bogota", "Colombia 3E", "Colombia 6E", "Egypt red belt", "Egypt purple belt", "Extended Purple Belt", "New Zealand north island nat grid", "New Zealand south island nat grid", "Bahrain grid", "Netherlands E Indies Equatorial", "RSO Borneo", "User-defined"};
    public static final int[] COORDINATETRANSFORMATION_INDEX = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, Short.MAX_VALUE};
    public static final String[] COORDINATETRANSFORMATION = new String[]{"Undefined", "Transverse Mercator", "Transverse Mercator modified Alaska", "Oblique Mercator", "Oblique Mercator Laborde", "Oblique Mercator Rosenmund", "Oblique Mercator Spherical", "Mercator", "Lambert Conformal Conic 2SP", "Lambert Conformal conic Helmert", "Lambert Azimuthal equal area", "Albers equal area", "Azimuthal equidistant", "Equidistant conic", "Stereographic", "Polar stereographic", "Oblique stereographic", "Equirectangular", "Cassini Soldner", "Gnomonic", "Miller cylindrical", "Orthographic", "Polyconic", "Robinson", "Sinusoidal", "Van Der Grinten", "New Zealand map grid", "Transverse Mercator south oriented", "User-defined"};
    public static final int[] VERTICALCSTYPE_INDEX = new int[]{0, 5001, 5002, 5003, 5004, 5005, 5006, 5007, 5008, 5010, 5011, 5012, 5013, 5014, 5015, 5016, 5017, 5018, 5019, 5020, 5021, 5022, 5023, 5024, 5025, 5026, 5027, 5028, 5029, 5030, 5031, 5032, 5033, 5101, 5102, 5103, 5104, 5105, 5106, Short.MAX_VALUE};
    public static final String[] VERTICALCSTYPE = new String[]{"Undefined", "Airy 1830 ellipsoid", "Airy modified 1849 ellipsoid", "ANS ellipsoid", "Bessel 1841 ellipsoid", "Bessel Modified ellipsoid", "Bessel Namibia ellipsoid", "Clarke 1858 ellipsoid", "Clarke 1866 ellipsoid", "Clarke 1880 Benoit ellipsoid", "Clarke 1880 IGN ellipsoid", "Clarke 1880 RGS ellipsoid", "Clarke 1880 arc ellipsoid", "Clarke 1880 SGA 1922 ellipsoid", "Everest 1830 1937 adjustment ellipsoid", "Everest 1830 1967 definition ellipsoid", "Everest 1830 1975 definition ellipsoid", "Everest 1830 modified ellipsoid", "GRS 1980 ellipsoid", "Helmert 1906 ellipsoid", "INS ellipsoid", "International 1924 ellipsoid", "International 1967 ellipsoid", "Krassowsky 1940 ellipsoid", "NWL 9D ellipsoid", "NWL 10D ellipsoid", "Plessis 1817 ellipsoid", "Struve 1860 ellipsoid", "War Office ellipsoid", "WGS 84 ellipsoid", "GEM 10C ellipsoid", "OSU86F ellipsoid", "OSU91A ellipsoid", "Newlyn", "North American vertical datum 1929", "North American vertical datum 1988", "Yellow Sea 1956", "Baltic Sea", "Caspian Sea", "User-defined"};
    public static final int[] VERTICALCSDATUM_INDEX = new int[]{0, Short.MAX_VALUE};
    public static final String[] VERTICALCSDATUM = new String[]{"Undefined", "User-defined"};

    private GeoTiffStrings() {
    }
}

