/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.out;

import ch.docuteam.tools.out.Logger;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public abstract class MailSender {
    public static boolean sendMessageSMTP(String receiver, String subject, String body, Properties props) {
        return MailSender.sendMessageSMTP(receiver, subject, body, props, null);
    }

    public static boolean sendMessageSMTP(String receiver, String subject, String body, final Properties props, List<File> attachments) {
        try {
            Session session = null;
            session = Boolean.parseBoolean(MailSender.getMailSmtpAuthorization(props)) ? Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailSender.getMailSmtpUser(props), this.getMailSmtpPassword(props));
                }

                private String getMailSmtpPassword(Properties props2) {
                    return props2.getProperty("mail.smtp.pwd");
                }
            }) : Session.getDefaultInstance((Properties)props);
            MimeMessage message = new MimeMessage(session);
            message.setSender((Address)new InternetAddress(MailSender.getMailSmtpUser(props)));
            for (String recipient : receiver.split(",")) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            }
            message.setSubject(subject);
            if (attachments == null) {
                message.setText(body);
            } else {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setText(body);
                multipart.addBodyPart((BodyPart)messageBodyPart);
                for (File attachment : attachments) {
                    messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(attachment)));
                    messageBodyPart.setFileName(attachment.getName());
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
                message.setContent((Multipart)multipart);
            }
            Transport.send((Message)message, (Address[])message.getAllRecipients());
        }
        catch (NoSuchProviderException e) {
            Logger.warn("SMTP-Transfer did not succeed.", e);
            return false;
        }
        catch (AddressException e) {
            Logger.warn("Invalid address, check sender (" + MailSender.getMailSmtpUser(props) + ") or receiver (" + receiver + ") information", e);
            return false;
        }
        catch (MessagingException e) {
            Logger.warn("SMTP-Server " + props.getProperty("mail.smtp.host") + " ist not available", e);
            return false;
        }
        return true;
    }

    private static String getMailSmtpAuthorization(Properties props) {
        return props.getProperty("mail.smtp.auth");
    }

    private static String getMailSmtpUser(Properties props) {
        String user = props.getProperty("mail.smtp.user");
        Logger.debug("getMailSmtpUser: " + user);
        return user;
    }

    public static boolean sendMessageLocalClient(String receiver, String subject, String body, Properties props) {
        Logger.info("Opening local mail editor with mail template...");
        try {
            Logger.info(new URI("mailto", receiver + "?SUBJECT=" + subject + "&BODY=" + body, null).toString());
            Desktop.getDesktop().mail(new URI("mailto", receiver + "?SUBJECT=" + subject + "&BODY=" + body, null));
        }
        catch (Exception e) {
            Logger.warn("Mail could not be sent.", e);
            return false;
        }
        return true;
    }
}

