/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.string;

import ch.docuteam.tools.out.Tracer;
import ch.docuteam.tools.string.StringSetElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class StringSet {
    private static Map<String, Map<String, StringSetElement>> All = new HashMap<String, Map<String, StringSetElement>>();

    public static StringSetElement get(Class<? extends StringSetElement> elementClass, String value) {
        try {
            return All.get(elementClass.getName()).get(StringSetElement.asKey(value));
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public static List<StringSetElement> getAll(Class<? extends StringSetElement> elementClass) {
        try {
            ArrayList<StringSetElement> all = new ArrayList<StringSetElement>(All.get(elementClass.getName()).values());
            Collections.sort(all);
            return all;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public static void traceAll(Class<? extends StringSetElement> elementClass) {
        for (StringSetElement e : StringSet.getAll(elementClass)) {
            Tracer.trace(e);
        }
    }

    protected static void add(StringSetElement newElement) {
        String elementClassName = newElement.getClass().getName();
        if (!All.containsKey(elementClassName)) {
            All.put(elementClassName, new HashMap());
        }
        All.get(elementClassName).put(newElement.getValueAsKey(), newElement);
    }
}

