/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.byteseek.io.reader.FileReader;
import net.byteseek.io.reader.ReaderInputStream;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.cache.TopAndTailFixedLengthCache;
import net.byteseek.io.reader.cache.WindowCache;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;

public class FileSystemIdentificationRequest
implements IdentificationRequest<File> {
    private static final int TOP_TAIL_BUFFER_CAPACITY = 0x800000;
    private final String extension;
    private final String fileName;
    private final long size;
    private WindowReader fileReader;
    private final RequestIdentifier identifier;
    private RequestMetaData requestMetaData;
    private File file;

    public FileSystemIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier) {
        this.identifier = identifier;
        this.requestMetaData = metaData;
        this.size = metaData.getSize();
        this.fileName = metaData.getName();
        this.extension = ResourceUtils.getExtension(this.fileName);
    }

    @Override
    public final void open(File theFile) throws IOException {
        TopAndTailFixedLengthCache cache = new TopAndTailFixedLengthCache(theFile.length(), 0x800000L);
        this.fileReader = new FileReader(theFile, (WindowCache)cache);
        ((FileReader)this.fileReader).useSoftWindows(true);
        this.file = theFile;
        this.fileReader.getWindow(0L);
    }

    @Override
    public final String getExtension() {
        return this.extension;
    }

    @Override
    public final String getFileName() {
        return this.fileName;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final void close() throws IOException {
        this.file = null;
        this.fileReader.close();
    }

    @Override
    public final InputStream getSourceInputStream() throws IOException {
        return new ReaderInputStream(this.fileReader, false);
    }

    @Override
    public final RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    @Override
    public final RequestIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public byte getByte(long position) throws IOException {
        int result = this.fileReader.readByte(position);
        if (result < 0) {
            throw new IOException("No byte at position " + position);
        }
        return (byte)result;
    }

    @Override
    public WindowReader getWindowReader() {
        return this.fileReader;
    }

    public File getFile() {
        return this.file;
    }
}

