/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class OnEmptyHandler
extends ProxyReceiver {
    boolean processingParent = true;
    Expression onEmpty;
    XPathContext context;
    NodeName savedNodeName;
    SchemaType savedSchemaType;
    int savedLocationId;
    int savedProperties;
    List<NamespaceBinding> savedNamespaces = new ArrayList<NamespaceBinding>(4);

    public OnEmptyHandler(Receiver next, Expression onEmpty, XPathContext context) {
        super(next);
        this.onEmpty = onEmpty;
        this.context = context;
    }

    private void flush() throws XPathException {
        if (this.savedNodeName != null) {
            this.nextReceiver.startElement(this.savedNodeName, this.savedSchemaType, this.savedLocationId, this.savedProperties);
            for (NamespaceBinding binding : this.savedNamespaces) {
                this.nextReceiver.namespace(binding, 0);
            }
            this.savedNodeName = null;
        }
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        if (this.processingParent) {
            this.savedNodeName = elemName;
            this.savedSchemaType = typeCode;
            this.savedLocationId = locationId;
            this.savedProperties = properties;
        } else {
            this.flush();
            super.startElement(elemName, typeCode, locationId, properties);
        }
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (this.savedNodeName != null) {
            this.savedNamespaces.add(namespaceBinding);
        } else {
            super.namespace(namespaceBinding, properties);
        }
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        this.flush();
        super.attribute(nameCode, typeCode, value, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (chars.length() > 0) {
            this.flush();
            super.characters(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        this.flush();
        super.processingInstruction(target, data, locationId, properties);
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.flush();
        super.comment(chars, locationId, properties);
    }

    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        this.flush();
        super.append(item, locationId, copyNamespaces);
    }

    public void endElement() throws XPathException {
        if (this.savedNodeName != null) {
            this.onEmpty.process(this.context);
        } else {
            super.endElement();
        }
    }
}

